/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.iceberg;

import com.dremio.nessie.api.TreeApi;
import com.dremio.nessie.client.NessieClient;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.iceberg.NessieTableOperations;
import com.dremio.nessie.iceberg.ParsedTableIdentifier;
import com.dremio.nessie.iceberg.UpdateableReference;
import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.EntriesResponse;
import com.dremio.nessie.model.IcebergTable;
import com.dremio.nessie.model.ImmutableDelete;
import com.dremio.nessie.model.ImmutableMultiContents;
import com.dremio.nessie.model.ImmutablePut;
import com.dremio.nessie.model.MultiContents;
import com.dremio.nessie.model.Operation;
import com.dremio.nessie.model.Reference;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;

public class NessieCatalog
extends BaseMetastoreCatalog
implements AutoCloseable {
    public static final String CONF_NESSIE_URL = "nessie.url";
    public static final String CONF_NESSIE_USERNAME = "nessie.username";
    public static final String CONF_NESSIE_PASSWORD = "nessie.password";
    public static final String CONF_NESSIE_AUTH_TYPE = "nessie.auth_type";
    public static final String NESSIE_AUTH_TYPE_DEFAULT = "BASIC";
    public static final String CONF_NESSIE_REF = "nessie.ref";
    public static final String CONF_NESSIE_HASH = "nessie.hash";
    private static final Joiner SLASH = Joiner.on((String)"/");
    private static final String ICEBERG_HADOOP_WAREHOUSE_BASE = "iceberg/warehouse";
    private final NessieClient client;
    private final String warehouseLocation;
    private final Configuration config;
    private final UpdateableReference reference;
    private final String name;

    public NessieCatalog(Configuration config) {
        this("nessie", config);
    }

    public NessieCatalog(Configuration config, String ref) {
        this("nessie", config, ref);
    }

    public NessieCatalog(String name, Configuration config) {
        this(name, config, null);
    }

    public NessieCatalog(String name, Configuration config, String ref) {
        this.config = config;
        this.name = name;
        String path = config.get(CONF_NESSIE_URL);
        String username = config.get(CONF_NESSIE_USERNAME);
        String password = config.get(CONF_NESSIE_PASSWORD);
        String authTypeStr = config.get(CONF_NESSIE_AUTH_TYPE, NESSIE_AUTH_TYPE_DEFAULT);
        NessieClient.AuthType authType = NessieClient.AuthType.valueOf((String)authTypeStr);
        this.client = new NessieClient(authType, path, username, password);
        this.warehouseLocation = config.get("fs.defaultFS") + "/" + ICEBERG_HADOOP_WAREHOUSE_BASE;
        String requestedRef = ref != null ? ref : config.get(CONF_NESSIE_REF);
        this.reference = this.get(requestedRef);
    }

    private UpdateableReference get(String requestedRef) {
        try {
            Branch r = requestedRef == null ? this.client.getTreeApi().getDefaultBranch() : this.client.getTreeApi().getReferenceByName(requestedRef);
            return new UpdateableReference((Reference)r, this.client.getTreeApi());
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef != null) {
                throw new IllegalArgumentException(String.format("Nessie ref '%s' provided via %s does not exist. This ref must exist before creating a NessieCatalog.", requestedRef, CONF_NESSIE_REF), ex);
            }
            throw new IllegalArgumentException(String.format("Nessie does not have an existing default branch.Either configure an alternative ref via %s or create the default branch on the server.", CONF_NESSIE_REF), ex);
        }
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    protected String name() {
        return this.name;
    }

    private static ContentsKey toKey(TableIdentifier tableIdentifier) {
        ArrayList<String> identifiers = new ArrayList<String>();
        if (tableIdentifier.hasNamespace()) {
            identifiers.addAll(Arrays.asList(tableIdentifier.namespace().levels()));
        }
        identifiers.add(tableIdentifier.name());
        ContentsKey key = new ContentsKey(identifiers);
        return key;
    }

    private IcebergTable table(TableIdentifier tableIdentifier) {
        try {
            Contents table = this.client.getContentsApi().getContents(NessieCatalog.toKey(tableIdentifier), this.reference.getHash());
            if (table instanceof IcebergTable) {
                return (IcebergTable)table;
            }
        }
        catch (NessieNotFoundException nessieNotFoundException) {
            // empty catch block
        }
        return null;
    }

    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        ParsedTableIdentifier pti = ParsedTableIdentifier.getParsedTableIdentifier(tableIdentifier, (Map<String, String>)ImmutableMap.of());
        UpdateableReference newReference = this.reference;
        if (pti.getReference() != null) {
            newReference = this.get(pti.getReference());
        }
        return new NessieTableOperations(this.config, NessieCatalog.toKey(pti.getTableIdentifier()), newReference, this.client);
    }

    protected String defaultWarehouseLocation(TableIdentifier table) {
        if (table.hasNamespace()) {
            return SLASH.join((Object)this.warehouseLocation, (Object)table.namespace().toString(), new Object[]{table.name()});
        }
        return SLASH.join((Object)this.warehouseLocation, (Object)table.name(), new Object[0]);
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        try {
            return this.client.getTreeApi().getEntries(this.reference.getHash()).getEntries().stream().filter(NessieCatalog.namespacePredicate(namespace)).map(NessieCatalog::toIdentifier).collect(Collectors.toList());
        }
        catch (NessieNotFoundException ex) {
            throw new RuntimeException("Unable to list tables due to missing ref.", ex);
        }
    }

    private static Predicate<EntriesResponse.Entry> namespacePredicate(Namespace ns) {
        if (ns == null) {
            return e -> true;
        }
        List<String> namespace = Arrays.asList(ns.levels());
        Predicate<EntriesResponse.Entry> predicate = e -> {
            List names = e.getName().getElements();
            if (names.size() <= namespace.size()) {
                return false;
            }
            return namespace.equals(names.subList(0, namespace.size()));
        };
        return predicate;
    }

    private static TableIdentifier toIdentifier(EntriesResponse.Entry entry) {
        List elements = entry.getName().getElements();
        return TableIdentifier.of((String[])elements.toArray(new String[elements.size()]));
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        this.reference.checkMutable();
        IcebergTable existingTable = this.table(identifier);
        if (existingTable == null) {
            return false;
        }
        TableOperations ops = this.newTableOps(identifier);
        TableMetadata lastMetadata = purge && ops.current() != null ? ops.current() : null;
        try {
            this.client.getContentsApi().deleteContents(NessieCatalog.toKey(identifier), this.reference.getAsBranch().getName(), this.reference.getHash(), "no message");
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException("Failed to drop table as ref is no longer valid.", e);
        }
        catch (NessieConflictException e) {
            throw new RuntimeException("Failed to drop table as table state needs to be refreshed.");
        }
        if (purge && lastMetadata != null) {
            BaseMetastoreCatalog.dropTableData((FileIO)ops.io(), (TableMetadata)lastMetadata);
        }
        this.refresh();
        return true;
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        this.reference.checkMutable();
        IcebergTable existingFromTable = this.table(from);
        if (existingFromTable == null) {
            throw new NoSuchTableException(String.format("table %s doesn't exists", from.name()), new Object[0]);
        }
        IcebergTable existingToTable = this.table(to);
        if (existingToTable != null) {
            throw new AlreadyExistsException("table {} already exists", new Object[]{to.name()});
        }
        ImmutableMultiContents c = ImmutableMultiContents.builder().addOperations((Operation)ImmutablePut.builder().key(NessieCatalog.toKey(to)).contents((Contents)existingFromTable).build()).addOperations((Operation)ImmutableDelete.builder().key(NessieCatalog.toKey(from)).build()).build();
        try {
            this.client.getTreeApi().commitMultipleOperations(this.reference.getAsBranch().getName(), this.reference.getHash(), "iceberg rename table", (MultiContents)c);
            this.refresh();
        }
        catch (Exception e) {
            throw new CommitFailedException((Throwable)e, "failed", new Object[0]);
        }
    }

    public TreeApi getTreeApi() {
        return this.client.getTreeApi();
    }

    public void refresh() {
        this.reference.refresh();
    }

    public String getHash() {
        return this.reference.getHash();
    }
}

