/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.iceberg;

import com.dremio.nessie.client.NessieClient;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.iceberg.UpdateableReference;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.IcebergTable;
import com.dremio.nessie.model.ImmutableIcebergTable;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;

public class NessieTableOperations
extends BaseMetastoreTableOperations {
    private static Method sparkConfMethod;
    private static Method appIdMethod;
    private static Method sparkEnvMethod;
    private final Configuration conf;
    private final NessieClient client;
    private final ContentsKey key;
    private UpdateableReference reference;
    private IcebergTable table;
    private HadoopFileIO fileIO;

    public NessieTableOperations(Configuration conf, ContentsKey key, UpdateableReference reference, NessieClient client) {
        this.conf = conf;
        this.key = key;
        this.reference = reference;
        this.client = client;
    }

    protected void doRefresh() {
        this.reference.refresh();
        String metadataLocation = null;
        try {
            Contents c = this.client.getContentsApi().getContents(this.key, this.reference.getHash());
            this.table = (IcebergTable)c.unwrap(IcebergTable.class).orElseThrow(() -> new IllegalStateException("Nessie points to a non-Iceberg object for that path."));
            metadataLocation = this.table.getMetadataLocation();
        }
        catch (NessieNotFoundException ex) {
            this.table = null;
        }
        this.refreshFromMetadataLocation(metadataLocation, 2);
    }

    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        this.reference.checkMutable();
        String newMetadataLocation = this.writeNewMetadata(metadata, this.currentVersion() + 1);
        try {
            ImmutableIcebergTable table = ImmutableIcebergTable.builder().metadataLocation(newMetadataLocation).build();
            this.client.getContentsApi().setContents(this.key, this.reference.getAsBranch().getName(), this.reference.getHash(), String.format("iceberg commit%s", NessieTableOperations.applicationId()), (Contents)table);
        }
        catch (NessieConflictException | NessieNotFoundException ex) {
            this.io().deleteFile(newMetadataLocation);
            throw new CommitFailedException(ex, "failed", new Object[0]);
        }
        catch (Throwable e) {
            this.io().deleteFile(newMetadataLocation);
            throw new RuntimeException("Unexpected commit exception", e);
        }
    }

    public FileIO io() {
        if (this.fileIO == null) {
            this.fileIO = new HadoopFileIO(this.conf);
        }
        return this.fileIO;
    }

    private static String applicationId() {
        try {
            if (sparkConfMethod == null) {
                Class<?> sparkEnvClazz = Class.forName("org.apache.spark.SparkEnv");
                sparkEnvMethod = sparkEnvClazz.getMethod("get", new Class[0]);
                Class<?> sparkConfClazz = Class.forName("org.apache.spark.SparkConf");
                sparkConfMethod = sparkEnvClazz.getMethod("conf", new Class[0]);
                appIdMethod = sparkConfClazz.getMethod("getAppId", new Class[0]);
            }
            Object sparkEnv = sparkEnvMethod.invoke(null, new Object[0]);
            Object sparkConf = sparkConfMethod.invoke(sparkEnv, new Object[0]);
            return "\nspark.app.id= " + appIdMethod.invoke(sparkConf, new Object[0]);
        }
        catch (Exception e) {
            return "";
        }
    }
}

