/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.iceberg;

import java.time.Instant;
import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;

public class ParsedTableIdentifier {
    private final TableIdentifier tableIdentifier;
    private final Instant timestamp;
    private final String reference;

    public ParsedTableIdentifier(TableIdentifier tableIdentifier, Instant timestamp, String reference) {
        this.tableIdentifier = tableIdentifier;
        this.timestamp = timestamp;
        this.reference = reference;
    }

    public TableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getReference() {
        return this.reference;
    }

    public static ParsedTableIdentifier getParsedTableIdentifier(String path, Map<String, String> properties) {
        if (path.split("@").length > 2) {
            throw new IllegalArgumentException(String.format("Can only reference one branch in %s", path));
        }
        if (path.split("#").length > 2) {
            throw new IllegalArgumentException(String.format("Can only reference one hash in %s", path));
        }
        if (path.contains("@") && path.contains("#")) {
            throw new IllegalArgumentException("Currently we don't support referencing by timestamp, # is not allowed in the table name");
        }
        if (path.contains("@")) {
            String[] tableRef = path.split("@");
            TableIdentifier identifier = TableIdentifier.parse((String)tableRef[0]);
            return new ParsedTableIdentifier(identifier, null, tableRef[1]);
        }
        if (path.contains("#")) {
            throw new IllegalArgumentException("Currently we don't support referencing by timestamp, # is not allowed in the table name");
        }
        TableIdentifier identifier = TableIdentifier.parse((String)path);
        String reference = properties.get("nessie.ref");
        return new ParsedTableIdentifier(identifier, null, reference);
    }

    public static ParsedTableIdentifier getParsedTableIdentifier(TableIdentifier path, Map<String, String> properties) {
        ParsedTableIdentifier pti = ParsedTableIdentifier.getParsedTableIdentifier(path.name(), properties);
        return new ParsedTableIdentifier(TableIdentifier.of((Namespace)path.namespace(), (String)pti.getTableIdentifier().name()), pti.getTimestamp(), pti.getReference());
    }
}

