/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.iceberg;

import com.dremio.nessie.api.TreeApi;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.Hash;
import com.dremio.nessie.model.Reference;
import org.apache.iceberg.exceptions.NotFoundException;

class UpdateableReference {
    private Reference reference;
    private final TreeApi client;

    public UpdateableReference(Reference reference, TreeApi client) {
        this.reference = reference;
        this.client = client;
    }

    public boolean refresh() {
        if (this.reference instanceof Hash) {
            return false;
        }
        Reference oldReference = this.reference;
        try {
            this.reference = this.client.getReferenceByName(this.reference.getName());
        }
        catch (NessieNotFoundException e) {
            throw new NotFoundException("Failure refreshing data, table no longer exists.", new Object[]{e});
        }
        return !oldReference.equals(this.reference);
    }

    public boolean isBranch() {
        return this.reference instanceof Branch;
    }

    public UpdateableReference clone() {
        return new UpdateableReference(this.reference, this.client);
    }

    public String getHash() {
        return this.reference.getHash();
    }

    public Branch getAsBranch() {
        if (!this.isBranch()) {
            throw new IllegalArgumentException("Reference is not a branch");
        }
        return (Branch)this.reference;
    }

    public void checkMutable() {
        if (!this.isBranch()) {
            throw new IllegalArgumentException("You can only mutate tables when using a branch.");
        }
    }

    public String getName() {
        return this.reference.getName();
    }
}

