/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.iceberg;

import com.dremio.nessie.api.ContentsApi;
import com.dremio.nessie.api.TreeApi;
import com.dremio.nessie.client.NessieClient;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.iceberg.NessieCatalog;
import com.dremio.nessie.iceberg.NessieTableOperations;
import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.Reference;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseTestIceberg {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTestIceberg.class);
    private static final int NESSIE_PORT = Integer.getInteger("quarkus.http.test-port", 19121);
    private static final String NESSIE_ENDPOINT = String.format("http://localhost:%d/api/v1", NESSIE_PORT);
    protected static File ALLEY_LOCAL_DIR;
    protected NessieCatalog catalog;
    protected NessieClient client;
    protected TreeApi tree;
    protected ContentsApi contents;
    protected Configuration hadoopConfig;
    protected final String branch;

    @BeforeAll
    public static void create() throws Exception {
        ALLEY_LOCAL_DIR = Files.createTempDirectory("test", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx"))).toFile();
    }

    public BaseTestIceberg(String branch) {
        this.branch = branch;
    }

    private void resetData() throws NessieConflictException, NessieNotFoundException {
        for (Reference r : this.tree.getAllReferences()) {
            if (r instanceof Branch) {
                this.tree.deleteBranch(r.getName(), r.getHash());
                continue;
            }
            this.tree.deleteTag(r.getName(), r.getHash());
        }
        this.tree.createReference((Reference)Branch.of((String)"main", null));
    }

    @BeforeEach
    public void beforeEach() throws NessieConflictException, NessieNotFoundException {
        String username = "test";
        String password = "test123";
        this.client = new NessieClient(NessieClient.AuthType.NONE, NESSIE_ENDPOINT, username, password);
        this.tree = this.client.getTreeApi();
        this.contents = this.client.getContentsApi();
        this.resetData();
        try {
            this.tree.createReference((Reference)Branch.of((String)this.branch, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hadoopConfig = new Configuration();
        this.hadoopConfig.set("nessie.url", NESSIE_ENDPOINT);
        this.hadoopConfig.set("nessie.username", username);
        this.hadoopConfig.set("nessie.password", password);
        this.hadoopConfig.set("nessie.ref", this.branch);
        this.hadoopConfig.set("nessie.auth_type", "NONE");
        this.hadoopConfig.set("fs.defaultFS", ALLEY_LOCAL_DIR.toURI().toString());
        this.hadoopConfig.set("fs.file.impl", LocalFileSystem.class.getName());
        this.catalog = new NessieCatalog(this.hadoopConfig);
    }

    protected Table createTable(TableIdentifier tableIdentifier, int count) {
        try {
            return this.catalog.createTable(tableIdentifier, BaseTestIceberg.schema(count));
        }
        catch (Throwable t) {
            LOGGER.error("unable to do create " + tableIdentifier.toString(), t);
            throw t;
        }
    }

    protected void createTable(TableIdentifier tableIdentifier) {
        Schema schema = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())}).fields());
        this.catalog.createTable(tableIdentifier, schema).location();
    }

    protected static Schema schema(int count) {
        ArrayList<Types.NestedField> fields = new ArrayList<Types.NestedField>();
        for (int i = 0; i < count; ++i) {
            fields.add(Types.NestedField.required((int)i, (String)("id" + i), (Type)Types.LongType.get()));
        }
        return new Schema(Types.StructType.of(fields).fields());
    }

    void createBranch(String name, String hash) throws NessieNotFoundException, NessieConflictException {
        this.tree.createReference((Reference)Branch.of((String)name, (String)hash));
    }

    @AfterEach
    public void afterEach() throws Exception {
        this.catalog.close();
        this.client.close();
        this.catalog = null;
        this.client = null;
        this.hadoopConfig = null;
    }

    @AfterAll
    public static void destroy() throws Exception {
        ALLEY_LOCAL_DIR.delete();
    }

    static String getContent(NessieCatalog catalog, TableIdentifier tableIdentifier) {
        Table table = catalog.loadTable(tableIdentifier);
        BaseTable baseTable = (BaseTable)table;
        TableOperations ops = baseTable.operations();
        NessieTableOperations icebergOps = (NessieTableOperations)ops;
        return icebergOps.currentMetadataLocation();
    }
}

