/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.iceberg;

import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.iceberg.BaseTestIceberg;
import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.IcebergTable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.Files;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ITNessieTable
extends BaseTestIceberg {
    private static final String BRANCH = "iceberg-table-test";
    private static final String DB_NAME = "db";
    private static final String TABLE_NAME = "tbl";
    private static final TableIdentifier TABLE_IDENTIFIER = TableIdentifier.of((String[])new String[]{"db", "tbl"});
    private static final ContentsKey KEY = ContentsKey.of((String[])new String[]{"db", "tbl"});
    private static final Schema schema = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())}).fields());
    private static final Schema altered = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.LongType.get())}).fields());
    private Path tableLocation;

    public ITNessieTable() {
        super(BRANCH);
    }

    @Override
    @BeforeEach
    public void beforeEach() throws NessieConflictException, NessieNotFoundException {
        super.beforeEach();
        this.tableLocation = new Path(this.catalog.createTable(TABLE_IDENTIFIER, schema).location());
    }

    @Override
    @AfterEach
    public void afterEach() throws Exception {
        if (this.tableLocation != null) {
            this.tableLocation.getFileSystem(this.hadoopConfig).delete(this.tableLocation, true);
            this.catalog.refresh();
            this.catalog.dropTable(TABLE_IDENTIFIER, false);
        }
        super.afterEach();
    }

    private IcebergTable getTable(ContentsKey key) throws NessieNotFoundException {
        return (IcebergTable)this.client.getContentsApi().getContents(key, BRANCH).unwrap(IcebergTable.class).get();
    }

    @Test
    public void testCreate() throws NessieNotFoundException {
        String tableName = TABLE_IDENTIFIER.name();
        Table icebergTable = this.catalog.loadTable(TABLE_IDENTIFIER);
        icebergTable.updateSchema().addColumn("mother", (Type)Types.LongType.get()).commit();
        IcebergTable table = this.getTable(KEY);
        Assertions.assertEquals((Object)ITNessieTable.getTableLocation(tableName), (Object)(ALLEY_LOCAL_DIR.toURI().toString() + "iceberg/warehouse/" + DB_NAME + "/" + tableName).replace("//", "/"));
        Assertions.assertEquals((int)2, (int)ITNessieTable.metadataVersionFiles(tableName).size());
        Assertions.assertEquals((int)0, (int)ITNessieTable.manifestFiles(tableName).size());
    }

    @Test
    public void testRename() {
        String renamedTableName = "rename_table_name";
        TableIdentifier renameTableIdentifier = TableIdentifier.of((Namespace)TABLE_IDENTIFIER.namespace(), (String)renamedTableName);
        Table original = this.catalog.loadTable(TABLE_IDENTIFIER);
        this.catalog.renameTable(TABLE_IDENTIFIER, renameTableIdentifier);
        Assertions.assertFalse((boolean)this.catalog.tableExists(TABLE_IDENTIFIER));
        Assertions.assertTrue((boolean)this.catalog.tableExists(renameTableIdentifier));
        Table renamed = this.catalog.loadTable(renameTableIdentifier);
        Assertions.assertEquals((Object)original.schema().asStruct(), (Object)renamed.schema().asStruct());
        Assertions.assertEquals((Object)original.spec(), (Object)renamed.spec());
        Assertions.assertEquals((Object)original.location(), (Object)renamed.location());
        Assertions.assertEquals((Object)original.currentSnapshot(), (Object)renamed.currentSnapshot());
        Assertions.assertTrue((boolean)this.catalog.dropTable(renameTableIdentifier));
    }

    @Test
    public void testDrop() {
        Assertions.assertTrue((boolean)this.catalog.tableExists(TABLE_IDENTIFIER));
        Assertions.assertTrue((boolean)this.catalog.dropTable(TABLE_IDENTIFIER));
        Assertions.assertFalse((boolean)this.catalog.tableExists(TABLE_IDENTIFIER));
    }

    @Test
    public void testDropWithoutPurgeLeavesTableData() throws IOException {
        Table table = this.catalog.loadTable(TABLE_IDENTIFIER);
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(AvroSchemaUtil.convert((Schema)schema, (String)"test"));
        ArrayList<GenericData.Record> records = new ArrayList<GenericData.Record>();
        records.add(recordBuilder.set("id", (Object)1L).build());
        records.add(recordBuilder.set("id", (Object)2L).build());
        records.add(recordBuilder.set("id", (Object)3L).build());
        String fileLocation = table.location().replace("file:", "") + "/data/file.avro";
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((String)fileLocation)).schema(schema).named("test").build();){
            for (GenericData.Record rec : records) {
                writer.add((Object)rec);
            }
        }
        DataFile file = DataFiles.builder((PartitionSpec)table.spec()).withRecordCount(3L).withPath(fileLocation).withFileSizeInBytes(Files.localInput((String)fileLocation).getLength()).build();
        table.newAppend().appendFile(file).commit();
        String manifestListLocation = table.currentSnapshot().manifestListLocation().replace("file:", "");
        Assertions.assertTrue((boolean)this.catalog.dropTable(TABLE_IDENTIFIER, false));
        Assertions.assertFalse((boolean)this.catalog.tableExists(TABLE_IDENTIFIER));
        Assertions.assertTrue((boolean)new File(fileLocation).exists());
        Assertions.assertTrue((boolean)new File(manifestListLocation).exists());
    }

    @Test
    public void testDropTable() throws IOException {
        Table table = this.catalog.loadTable(TABLE_IDENTIFIER);
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(AvroSchemaUtil.convert((Schema)schema, (String)"test"));
        ArrayList<GenericData.Record> records = new ArrayList<GenericData.Record>();
        records.add(recordBuilder.set("id", (Object)1L).build());
        records.add(recordBuilder.set("id", (Object)2L).build());
        records.add(recordBuilder.set("id", (Object)3L).build());
        String location1 = table.location().replace("file:", "") + "/data/file1.avro";
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((String)location1)).schema(schema).named("test").build();){
            for (GenericData.Record record : records) {
                writer.add((Object)record);
            }
        }
        String location2 = table.location().replace("file:", "") + "/data/file2.avro";
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((String)location2)).schema(schema).named("test").build();){
            for (GenericData.Record rec : records) {
                writer.add((Object)rec);
            }
        }
        DataFile file1 = DataFiles.builder((PartitionSpec)table.spec()).withRecordCount(3L).withPath(location1).withFileSizeInBytes(Files.localInput((String)location2).getLength()).build();
        DataFile dataFile = DataFiles.builder((PartitionSpec)table.spec()).withRecordCount(3L).withPath(location2).withFileSizeInBytes(Files.localInput((String)location1).getLength()).build();
        table.newAppend().appendFile(file1).appendFile(dataFile).commit();
        table.newDelete().deleteFile(dataFile.path()).commit();
        String manifestListLocation = table.currentSnapshot().manifestListLocation().replace("file:", "");
        List manifests = table.currentSnapshot().allManifests();
        Assertions.assertTrue((boolean)this.catalog.dropTable(TABLE_IDENTIFIER));
        Assertions.assertFalse((boolean)this.catalog.tableExists(TABLE_IDENTIFIER));
        Assertions.assertFalse((boolean)new File(location1).exists());
        Assertions.assertFalse((boolean)new File(location2).exists());
        Assertions.assertFalse((boolean)new File(manifestListLocation).exists());
        for (ManifestFile manifest : manifests) {
            Assertions.assertFalse((boolean)new File(manifest.path().replace("file:", "")).exists());
        }
        Assertions.assertFalse((boolean)new File(((HasTableOperations)table).operations().current().metadataFileLocation().replace("file:", "")).exists());
    }

    @Test
    public void testExistingTableUpdate() {
        Table icebergTable = this.catalog.loadTable(TABLE_IDENTIFIER);
        icebergTable.updateSchema().addColumn("data", (Type)Types.LongType.get()).commit();
        icebergTable = this.catalog.loadTable(TABLE_IDENTIFIER);
        Assertions.assertEquals((int)2, (int)ITNessieTable.metadataVersionFiles(TABLE_NAME).size());
        Assertions.assertEquals((int)0, (int)ITNessieTable.manifestFiles(TABLE_NAME).size());
        Assertions.assertEquals((Object)altered.asStruct(), (Object)icebergTable.schema().asStruct());
    }

    @Test
    public void testFailure() throws NessieNotFoundException, NessieConflictException {
        Table icebergTable = this.catalog.loadTable(TABLE_IDENTIFIER);
        Branch branch = (Branch)this.client.getTreeApi().getReferenceByName(BRANCH);
        IcebergTable table = (IcebergTable)this.client.getContentsApi().getContents(KEY, BRANCH).unwrap(IcebergTable.class).get();
        this.client.getContentsApi().setContents(KEY, branch.getName(), branch.getHash(), "", (Contents)IcebergTable.of((String)"dummytable.metadata.json"));
        Assertions.assertThrows(CommitFailedException.class, () -> icebergTable.updateSchema().addColumn("data", (Type)Types.LongType.get()).commit());
    }

    @Test
    public void testListTables() {
        List tableIdents = this.catalog.listTables(TABLE_IDENTIFIER.namespace());
        List expectedIdents = tableIdents.stream().filter(t -> t.namespace().level(0).equals(DB_NAME) && t.name().equals(TABLE_NAME)).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)expectedIdents.size());
        Assertions.assertTrue((boolean)this.catalog.tableExists(TABLE_IDENTIFIER));
    }

    private static String getTableBasePath(String tableName) {
        String databasePath = ALLEY_LOCAL_DIR.toString() + "/iceberg/warehouse/" + DB_NAME;
        return Paths.get(databasePath, tableName).toAbsolutePath().toString();
    }

    protected static Path getTableLocationPath(String tableName) {
        return new Path("file", null, Paths.get(ITNessieTable.getTableBasePath(tableName), new String[0]).toString());
    }

    protected static String getTableLocation(String tableName) {
        return ITNessieTable.getTableLocationPath(tableName).toString();
    }

    private static String metadataLocation(String tableName) {
        return Paths.get(ITNessieTable.getTableBasePath(tableName), "metadata").toString();
    }

    private static List<String> metadataFiles(String tableName) {
        return Arrays.stream(new File(ITNessieTable.metadataLocation(tableName)).listFiles()).map(File::getAbsolutePath).collect(Collectors.toList());
    }

    protected static List<String> metadataVersionFiles(String tableName) {
        return ITNessieTable.filterByExtension(tableName, TableMetadataParser.getFileExtension((TableMetadataParser.Codec)TableMetadataParser.Codec.NONE));
    }

    protected static List<String> manifestFiles(String tableName) {
        return ITNessieTable.filterByExtension(tableName, ".avro");
    }

    private static List<String> filterByExtension(String tableName, String extension) {
        return ITNessieTable.metadataFiles(tableName).stream().filter(f -> f.endsWith(extension)).collect(Collectors.toList());
    }
}

