/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.iceberg;

import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.iceberg.BaseTestIceberg;
import com.dremio.nessie.iceberg.NessieCatalog;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ITTestBranchHash
extends BaseTestIceberg {
    private static final String BRANCH = "test-branch-hash";

    public ITTestBranchHash() {
        super(BRANCH);
    }

    @Test
    public void testBasicBranch() throws NessieNotFoundException, NessieConflictException {
        TableIdentifier foobar = TableIdentifier.of((String[])new String[]{"foo", "bar"});
        Table bar = this.createTable(foobar, 1);
        this.catalog.refresh();
        this.createBranch("test", this.catalog.getHash());
        this.hadoopConfig.set("nessie.ref", "test");
        NessieCatalog newCatalog = new NessieCatalog(this.hadoopConfig);
        String initialMetadataLocation = ITTestBranchHash.getContent(newCatalog, foobar);
        Assertions.assertEquals((Object)initialMetadataLocation, (Object)ITTestBranchHash.getContent(this.catalog, foobar));
        bar.updateSchema().addColumn("id1", (Type)Types.LongType.get()).commit();
        Assertions.assertNotEquals((Object)ITTestBranchHash.getContent(this.catalog, foobar), (Object)ITTestBranchHash.getContent(newCatalog, foobar));
        Assertions.assertEquals((Object)initialMetadataLocation, (Object)ITTestBranchHash.getContent(newCatalog, foobar));
        String mainHash = this.tree.getReferenceByName(BRANCH).getHash();
        NessieCatalog refCatalog = new NessieCatalog(this.hadoopConfig, "test");
        Assertions.assertEquals((Object)ITTestBranchHash.getContent(newCatalog, foobar), (Object)ITTestBranchHash.getContent(refCatalog, foobar));
        NessieCatalog refHashCatalog = new NessieCatalog(this.hadoopConfig, mainHash);
        Assertions.assertEquals((Object)ITTestBranchHash.getContent(this.catalog, foobar), (Object)ITTestBranchHash.getContent(refHashCatalog, foobar));
        Assertions.assertEquals((Object)ITTestBranchHash.getContent(newCatalog, foobar), (Object)ITTestBranchHash.getContent(this.catalog, TableIdentifier.of((String[])new String[]{"foo", "bar@test"})));
        Assertions.assertEquals((Object)ITTestBranchHash.getContent(this.catalog, foobar), (Object)ITTestBranchHash.getContent(this.catalog, TableIdentifier.of((String[])new String[]{"foo", "bar@" + mainHash})));
    }
}

