/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.iceberg;

import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.iceberg.BaseTestIceberg;
import com.dremio.nessie.iceberg.NessieCatalog;
import com.dremio.nessie.model.Branch;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ITTestCatalogBranch
extends BaseTestIceberg {
    public ITTestCatalogBranch() {
        super("main");
    }

    @Test
    public void testBasicBranch() throws NessieNotFoundException, NessieConflictException {
        TableIdentifier foobar = TableIdentifier.of((String[])new String[]{"foo", "bar"});
        TableIdentifier foobaz = TableIdentifier.of((String[])new String[]{"foo", "baz"});
        Table bar = this.createTable(foobar, 1);
        this.createTable(foobaz, 1);
        this.catalog.refresh();
        this.createBranch("test", this.catalog.getHash());
        this.hadoopConfig.set("nessie.ref", "test");
        NessieCatalog newCatalog = new NessieCatalog(this.hadoopConfig);
        String initialMetadataLocation = ITTestCatalogBranch.getContent(newCatalog, foobar);
        Assertions.assertEquals((Object)initialMetadataLocation, (Object)ITTestCatalogBranch.getContent(this.catalog, foobar));
        Assertions.assertEquals((Object)ITTestCatalogBranch.getContent(newCatalog, foobaz), (Object)ITTestCatalogBranch.getContent(this.catalog, foobaz));
        bar.updateSchema().addColumn("id1", (Type)Types.LongType.get()).commit();
        Assertions.assertNotEquals((Object)ITTestCatalogBranch.getContent(this.catalog, foobar), (Object)ITTestCatalogBranch.getContent(newCatalog, foobar));
        Assertions.assertEquals((Object)initialMetadataLocation, (Object)ITTestCatalogBranch.getContent(newCatalog, foobar));
        initialMetadataLocation = ITTestCatalogBranch.getContent(newCatalog, foobaz);
        newCatalog.loadTable(foobaz).updateSchema().addColumn("id1", (Type)Types.LongType.get()).commit();
        Assertions.assertNotEquals((Object)ITTestCatalogBranch.getContent(this.catalog, foobaz), (Object)ITTestCatalogBranch.getContent(newCatalog, foobaz));
        Assertions.assertEquals((Object)initialMetadataLocation, (Object)ITTestCatalogBranch.getContent(this.catalog, foobaz));
        String mainHash = this.tree.getReferenceByName("main").getHash();
        this.tree.assignBranch("main", mainHash, Branch.of((String)"main", (String)newCatalog.getHash()));
        Assertions.assertEquals((Object)ITTestCatalogBranch.getContent(newCatalog, foobar), (Object)ITTestCatalogBranch.getContent(this.catalog, foobar));
        Assertions.assertEquals((Object)ITTestCatalogBranch.getContent(newCatalog, foobaz), (Object)ITTestCatalogBranch.getContent(this.catalog, foobaz));
        this.catalog.dropTable(foobar);
        this.catalog.dropTable(foobaz);
        newCatalog.refresh();
        this.catalog.getTreeApi().deleteBranch("test", newCatalog.getHash());
    }
}

