/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.iceberg;

import com.dremio.nessie.iceberg.ParsedTableIdentifier;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestParsedTableIdentifier {
    TestParsedTableIdentifier() {
    }

    @Test
    void noMarkings() {
        String path = "foo";
        ParsedTableIdentifier pti = ParsedTableIdentifier.getParsedTableIdentifier((String)path, new HashMap());
        Assertions.assertEquals((Object)path, (Object)pti.getTableIdentifier().name());
        Assertions.assertNull((Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
    }

    @Test
    void branchOnly() {
        String path = "foo@bar";
        ParsedTableIdentifier pti = ParsedTableIdentifier.getParsedTableIdentifier((String)path, new HashMap());
        Assertions.assertEquals((Object)"foo", (Object)pti.getTableIdentifier().name());
        Assertions.assertEquals((Object)"bar", (Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
    }

    @Test
    void timestampOnly() {
        String path = "foo#baz";
        Assertions.assertThrows(IllegalArgumentException.class, () -> ParsedTableIdentifier.getParsedTableIdentifier((String)path, new HashMap()));
    }

    @Test
    void branchAndTimestamp() {
        String path = "foo@bar#baz";
        Assertions.assertThrows(IllegalArgumentException.class, () -> ParsedTableIdentifier.getParsedTableIdentifier((String)path, new HashMap()));
    }

    @Test
    void twoBranches() {
        String path = "foo@bar@boo";
        Assertions.assertThrows(IllegalArgumentException.class, () -> ParsedTableIdentifier.getParsedTableIdentifier((String)path, new HashMap()));
    }

    @Test
    void twoTimestamps() {
        String path = "foo#baz#baa";
        Assertions.assertThrows(IllegalArgumentException.class, () -> ParsedTableIdentifier.getParsedTableIdentifier((String)path, new HashMap()));
    }

    @Test
    void branchOnlyInProps() {
        String path = "foo";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nessie.ref", "bar");
        ParsedTableIdentifier pti = ParsedTableIdentifier.getParsedTableIdentifier((String)path, map);
        Assertions.assertEquals((Object)"foo", (Object)pti.getTableIdentifier().name());
        Assertions.assertEquals((Object)"bar", (Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
    }

    @Test
    void strangeCharacters() {
        String branch = "bar";
        String path = "/%";
        ParsedTableIdentifier pti = ParsedTableIdentifier.getParsedTableIdentifier((String)path, new HashMap());
        Assertions.assertEquals((Object)path, (Object)pti.getTableIdentifier().name());
        Assertions.assertNull((Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
        pti = ParsedTableIdentifier.getParsedTableIdentifier((String)(path + "@" + branch), new HashMap());
        Assertions.assertEquals((Object)path, (Object)pti.getTableIdentifier().name());
        Assertions.assertEquals((Object)branch, (Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
        path = "&&";
        pti = ParsedTableIdentifier.getParsedTableIdentifier((String)path, new HashMap());
        Assertions.assertEquals((Object)path, (Object)pti.getTableIdentifier().name());
        Assertions.assertNull((Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
        pti = ParsedTableIdentifier.getParsedTableIdentifier((String)(path + "@" + branch), new HashMap());
        Assertions.assertEquals((Object)path, (Object)pti.getTableIdentifier().name());
        Assertions.assertEquals((Object)branch, (Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
    }

    @Test
    void doubleByte() {
        String branch = "bar";
        String path = "/%\u56fd";
        ParsedTableIdentifier pti = ParsedTableIdentifier.getParsedTableIdentifier((String)path, new HashMap());
        Assertions.assertEquals((Object)path, (Object)pti.getTableIdentifier().name());
        Assertions.assertNull((Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
        pti = ParsedTableIdentifier.getParsedTableIdentifier((String)(path + "@" + branch), new HashMap());
        Assertions.assertEquals((Object)path, (Object)pti.getTableIdentifier().name());
        Assertions.assertEquals((Object)branch, (Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
        path = "\u56fd.\u56fd";
        pti = ParsedTableIdentifier.getParsedTableIdentifier((String)path, new HashMap());
        Assertions.assertEquals((Object)path, (Object)pti.getTableIdentifier().toString());
        Assertions.assertNull((Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
        pti = ParsedTableIdentifier.getParsedTableIdentifier((String)(path + "@" + branch), new HashMap());
        Assertions.assertEquals((Object)path, (Object)pti.getTableIdentifier().toString());
        Assertions.assertEquals((Object)branch, (Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
    }

    @Test
    void whitespace() {
        String branch = "bar ";
        String path = "foo ";
        ParsedTableIdentifier pti = ParsedTableIdentifier.getParsedTableIdentifier((String)path, new HashMap());
        Assertions.assertEquals((Object)path, (Object)pti.getTableIdentifier().name());
        Assertions.assertNull((Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
        pti = ParsedTableIdentifier.getParsedTableIdentifier((String)(path + "@" + branch), new HashMap());
        Assertions.assertEquals((Object)path, (Object)pti.getTableIdentifier().name());
        Assertions.assertEquals((Object)branch, (Object)pti.getReference());
        Assertions.assertNull((Object)pti.getTimestamp());
    }
}

