/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.viewdepoc;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.viewdepoc.BaseMetastoreViewOperations;
import org.apache.iceberg.viewdepoc.BaseView;
import org.apache.iceberg.viewdepoc.View;
import org.apache.iceberg.viewdepoc.ViewDefinition;
import org.apache.iceberg.viewdepoc.ViewUtils;
import org.apache.iceberg.viewdepoc.ViewVersionMetadata;
import org.apache.iceberg.viewdepoc.Views;

public abstract class BaseMetastoreViews
implements Views {
    protected BaseMetastoreViews() {
    }

    protected abstract BaseMetastoreViewOperations newViewOps(TableIdentifier var1);

    protected String defaultWarehouseLocation(TableIdentifier viewIdentifier) {
        throw new UnsupportedOperationException("Implementation for 'defaultWarehouseLocation' not provided.");
    }

    @Override
    public void create(String viewIdentifier, ViewDefinition definition, Map<String, String> properties) {
        TableIdentifier viewName = ViewUtils.toCatalogTableIdentifier(viewIdentifier);
        BaseMetastoreViewOperations ops = this.newViewOps(viewName);
        if (ops.current() != null) {
            throw new AlreadyExistsException("View already exists: %s", new Object[]{viewName});
        }
        String location = this.defaultWarehouseLocation(viewName);
        int parentId = -1;
        ViewUtils.doCommit("create", properties, 1, parentId, definition, location, ops, null);
    }

    @Override
    public void replace(String viewIdentifier, ViewDefinition definition, Map<String, String> properties) {
        TableIdentifier viewName = ViewUtils.toCatalogTableIdentifier(viewIdentifier);
        BaseMetastoreViewOperations ops = this.newViewOps(viewName);
        if (ops.current() == null) {
            throw new AlreadyExistsException("View %s is expected to exist", new Object[]{viewName});
        }
        ViewVersionMetadata prevViewVersionMetadata = ops.current();
        Preconditions.checkState((prevViewVersionMetadata.versions().size() > 0 ? 1 : 0) != 0, (Object)"Version history not found");
        int parentId = prevViewVersionMetadata.currentVersionId();
        String location = prevViewVersionMetadata.location();
        ViewUtils.doCommit("replace", properties, parentId + 1, parentId, definition, location, ops, prevViewVersionMetadata);
    }

    @Override
    public void drop(String viewIdentifier) {
        TableIdentifier viewName = ViewUtils.toCatalogTableIdentifier(viewIdentifier);
        BaseMetastoreViewOperations ops = this.newViewOps(viewName);
        ops.drop(viewName.toString());
    }

    @Override
    public View load(String viewIdentifier) {
        TableIdentifier viewName = ViewUtils.toCatalogTableIdentifier(viewIdentifier);
        BaseMetastoreViewOperations ops = this.newViewOps(viewName);
        if (ops.current() == null) {
            throw new NotFoundException("View does not exist: %s", new Object[]{viewName});
        }
        return new BaseView(ops, viewName.toString());
    }

    @Override
    public ViewDefinition loadDefinition(String viewIdentifier) {
        TableIdentifier viewName = ViewUtils.toCatalogTableIdentifier(viewIdentifier);
        BaseMetastoreViewOperations ops = this.newViewOps(viewName);
        if (ops.current() == null) {
            throw new NotFoundException("View does not exist: %s", new Object[]{viewName});
        }
        return ops.current().definition();
    }
}

