/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.viewdepoc;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.viewdepoc.BaseView;
import org.apache.iceberg.viewdepoc.HadoopViewOperations;
import org.apache.iceberg.viewdepoc.View;
import org.apache.iceberg.viewdepoc.ViewDefinition;
import org.apache.iceberg.viewdepoc.ViewOperations;
import org.apache.iceberg.viewdepoc.ViewUtils;
import org.apache.iceberg.viewdepoc.ViewVersionMetadata;
import org.apache.iceberg.viewdepoc.Views;

public class HadoopViews
implements Views,
Configurable {
    private Configuration conf;

    public HadoopViews(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public View load(String location) {
        ViewOperations ops = this.newViewOps(location);
        if (ops.current() == null) {
            throw new NoSuchTableException("View does not exist at location: %s", new Object[]{location});
        }
        return new BaseView(ops, location);
    }

    @Override
    public ViewDefinition loadDefinition(String location) {
        ViewOperations ops = this.newViewOps(location);
        if (ops.current() == null) {
            throw new NoSuchTableException("View does not exist at location: %s", new Object[]{location});
        }
        return ops.current().definition();
    }

    @Override
    public void create(String location, ViewDefinition viewDefinition, Map<String, String> properties) {
        ViewOperations ops = this.newViewOps(location);
        if (ops.current() != null) {
            throw new AlreadyExistsException("View already exists at location: %s", new Object[]{location});
        }
        int parentId = -1;
        ViewUtils.doCommit("create", properties, 1, parentId, viewDefinition, location, ops, null);
    }

    @Override
    public void replace(String location, ViewDefinition definition, Map<String, String> properties) {
        ViewOperations ops = this.newViewOps(location);
        if (ops.current() == null) {
            throw new AlreadyExistsException("View is expected to exist at location: %s", new Object[]{location});
        }
        ViewVersionMetadata prevViewVersionMetadata = ops.current();
        Preconditions.checkState((prevViewVersionMetadata.versions().size() > 0 ? 1 : 0) != 0, (Object)"Version history not found");
        int parentId = prevViewVersionMetadata.currentVersionId();
        ViewUtils.doCommit("replace", properties, parentId + 1, parentId, definition, location, ops, prevViewVersionMetadata);
    }

    @Override
    public void drop(String location) {
        ViewOperations ops = this.newViewOps(location);
        ops.drop(location);
    }

    private ViewOperations newViewOps(String location) {
        return new HadoopViewOperations(new Path(location), this.conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

