/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.viewdepoc;

import java.util.List;
import java.util.Objects;
import org.apache.iceberg.Schema;
import org.apache.iceberg.viewdepoc.ViewDefinition;

class BaseViewDefinition
implements ViewDefinition {
    private final String sql;
    private final Schema schema;
    private final String sessionCatalog;
    private final List<String> sessionNamespace;

    public BaseViewDefinition(String sql, Schema schema, String sessionCatalog, List<String> sessionNamespace) {
        this.sql = sql;
        this.schema = schema;
        this.sessionCatalog = sessionCatalog;
        this.sessionNamespace = sessionNamespace;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public String sessionCatalog() {
        return this.sessionCatalog;
    }

    @Override
    public List<String> sessionNamespace() {
        return this.sessionNamespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseViewDefinition)) {
            return false;
        }
        BaseViewDefinition that = (BaseViewDefinition)o;
        return Objects.equals(this.sql, that.sql) && Objects.equals(this.sessionCatalog, that.sessionCatalog) && Objects.equals(this.sessionNamespace, that.sessionNamespace);
    }

    public int hashCode() {
        return Objects.hash(this.sql, this.sessionCatalog, this.sessionNamespace);
    }

    public String toString() {
        return "BaseViewDefinition{sql='" + this.sql + '\'' + ", schema=" + this.schema + ", sessionCatalog='" + this.sessionCatalog + '\'' + ", sessionNamespace=" + this.sessionNamespace + '}';
    }
}

