/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.viewdepoc;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.viewdepoc.HistoryEntry;
import org.apache.iceberg.viewdepoc.Version;
import org.apache.iceberg.viewdepoc.VersionLogEntry;
import org.apache.iceberg.viewdepoc.VersionParser;
import org.apache.iceberg.viewdepoc.ViewDefinition;
import org.apache.iceberg.viewdepoc.ViewVersionMetadata;

public class ViewVersionMetadataParser {
    static final String FORMAT_VERSION = "format-version";
    static final String LOCATION = "location";
    static final String CURRENT_VERSION_ID = "current-version-id";
    static final String VERSIONS = "versions";
    static final String VERSION_ID = "version-id";
    static final String TIMESTAMP_MS = "timestamp-ms";
    static final String VERSION_LOG = "version-log";
    private static final String PROPERTIES = "properties";

    private ViewVersionMetadataParser() {
    }

    public static void overwrite(ViewVersionMetadata metadata, OutputFile outputFile) {
        ViewVersionMetadataParser.internalWrite(metadata, outputFile, true);
    }

    public static void write(ViewVersionMetadata metadata, OutputFile outputFile) {
        ViewVersionMetadataParser.internalWrite(metadata, outputFile, false);
    }

    public static void internalWrite(ViewVersionMetadata metadata, OutputFile outputFile, boolean overwrite) {
        PositionOutputStream stream = overwrite ? outputFile.createOrOverwrite() : outputFile.create();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");){
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            generator.useDefaultPrettyPrinter();
            ViewVersionMetadataParser.toJson(metadata, generator);
            generator.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write json to file: %s", new Object[]{outputFile});
        }
    }

    public static void toJson(ViewVersionMetadata metadata, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField(FORMAT_VERSION, 1);
        generator.writeStringField(LOCATION, metadata.location());
        generator.writeNumberField(CURRENT_VERSION_ID, metadata.currentVersionId());
        generator.writeObjectFieldStart(PROPERTIES);
        for (Map.Entry<String, String> keyValue : metadata.properties().entrySet()) {
            generator.writeStringField(keyValue.getKey(), keyValue.getValue());
        }
        generator.writeEndObject();
        generator.writeArrayFieldStart(VERSIONS);
        for (Version version : metadata.versions()) {
            VersionParser.toJson(version, generator);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart(VERSION_LOG);
        for (HistoryEntry logEntry : metadata.history()) {
            generator.writeStartObject();
            generator.writeNumberField(TIMESTAMP_MS, logEntry.timestampMillis());
            generator.writeNumberField(VERSION_ID, logEntry.versionId());
            generator.writeEndObject();
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    public static ViewVersionMetadata read(InputFile file) {
        ViewVersionMetadata viewVersionMetadata;
        block8: {
            SeekableInputStream is = file.newStream();
            try {
                viewVersionMetadata = ViewVersionMetadataParser.fromJson(file, (JsonNode)JsonUtil.mapper().readValue((InputStream)is, JsonNode.class));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to read file: %s", new Object[]{file});
                }
            }
            is.close();
        }
        return viewVersionMetadata;
    }

    static ViewVersionMetadata fromJson(InputFile file, JsonNode node) {
        Preconditions.checkArgument((boolean)node.isObject(), (String)"Cannot parse metadata from a non-object: %s", (Object)node);
        int formatVersion = JsonUtil.getInt((String)FORMAT_VERSION, (JsonNode)node);
        Preconditions.checkArgument((formatVersion == 1 ? 1 : 0) != 0, (String)"Cannot read unsupported version %s", (int)formatVersion);
        String location = JsonUtil.getString((String)LOCATION, (JsonNode)node);
        int currentVersionId = JsonUtil.getInt((String)CURRENT_VERSION_ID, (JsonNode)node);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (node.has(PROPERTIES)) {
            properties.putAll(JsonUtil.getStringMap((String)PROPERTIES, (JsonNode)node));
        }
        JsonNode versionArray = node.get(VERSIONS);
        Preconditions.checkArgument((boolean)versionArray.isArray(), (String)"Cannot parse versions from non-array: %s", (Object)versionArray);
        ArrayList versions = Lists.newArrayListWithExpectedSize((int)versionArray.size());
        Iterator iterator = versionArray.elements();
        while (iterator.hasNext()) {
            versions.add(VersionParser.fromJson((JsonNode)iterator.next()));
        }
        TreeSet entries = Sets.newTreeSet(Comparator.comparingLong(VersionLogEntry::timestampMillis));
        if (node.has(VERSION_LOG)) {
            Iterator logIterator = node.get(VERSION_LOG).elements();
            while (logIterator.hasNext()) {
                JsonNode entryNode = (JsonNode)logIterator.next();
                entries.add(new VersionLogEntry(JsonUtil.getLong((String)TIMESTAMP_MS, (JsonNode)entryNode), JsonUtil.getInt((String)VERSION_ID, (JsonNode)entryNode)));
            }
        }
        if (((Version)versions.get(versions.size() - 1)).versionId() != currentVersionId) {
            throw new RuntimeIOException("Version history is corrupt. Latest version info with id: %s does not match current version id: %s", new Object[]{((Version)versions.get(versions.size() - 1)).versionId(), currentVersionId});
        }
        ViewDefinition viewMetadata = ((Version)versions.get(versions.size() - 1)).viewDefinition();
        return new ViewVersionMetadata(location, viewMetadata, properties, currentVersionId, (List<Version>)versions, (List<HistoryEntry>)ImmutableList.copyOf(entries.iterator()));
    }
}

