/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieViewOperations;
import org.apache.iceberg.nessie.UpdateableReference;
import org.apache.iceberg.viewdepoc.BaseMetastoreViewOperations;
import org.apache.iceberg.viewdepoc.BaseMetastoreViews;
import org.apache.iceberg.viewdepoc.ViewUtils;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Reference;
import org.projectnessie.model.TableReference;
import org.projectnessie.model.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieViewCatalog
extends BaseMetastoreViews
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(NessieViewCatalog.class);
    private NessieApiV1 api;
    private String warehouseLocation;
    private Configuration config;
    private UpdateableReference reference;
    private FileIO fileIO;
    private Map<String, String> catalogOptions;

    public NessieViewCatalog(Configuration conf) {
        this.config = conf;
    }

    @Override
    protected String defaultWarehouseLocation(TableIdentifier viewIdentifier) {
        if (null != this.warehouseLocation && this.warehouseLocation.endsWith("/")) {
            this.warehouseLocation = this.warehouseLocation.substring(0, this.warehouseLocation.length() - 1);
        }
        return String.format("%s/%s/%s", this.warehouseLocation, viewIdentifier.namespace(), viewIdentifier.name());
    }

    public void initialize(String inputName, Map<String, String> options) {
        this.catalogOptions = ImmutableMap.copyOf(options);
        String fileIOImpl = options.get("io-impl");
        this.fileIO = fileIOImpl == null ? new HadoopFileIO(this.config) : CatalogUtil.loadFileIO((String)fileIOImpl, options, (Object)this.config);
        Function<String, String> removePrefix = x -> x.replace("nessie.", "");
        this.api = (NessieApiV1)NessieViewCatalog.createNessieClientBuilder(options.get("nessie.client-builder-impl")).fromConfig(x -> (String)options.get(removePrefix.apply((String)x))).build(NessieApiV1.class);
        this.warehouseLocation = options.get("warehouse");
        if (this.warehouseLocation == null) {
            logger.warn("Catalog creation for inputName={} and options {} failed, because parameter 'warehouse' is not set, Nessie can't store data.", (Object)inputName, options);
            throw new IllegalStateException("Parameter 'warehouse' not set, Nessie can't store data.");
        }
        String requestedRef = options.get(removePrefix.apply("nessie.ref"));
        String hashOnRef = options.get(removePrefix.apply("nessie.ref.hash"));
        this.reference = this.loadReference(requestedRef, hashOnRef);
    }

    private static NessieClientBuilder createNessieClientBuilder(String customBuilder) {
        HttpClientBuilder clientBuilder;
        if (customBuilder != null) {
            try {
                clientBuilder = (NessieClientBuilder)DynMethods.builder((String)"builder").impl(customBuilder, new Class[0]).build().asStatic().invoke(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to use custom NessieClientBuilder '%s'.", customBuilder), e);
            }
        } else {
            clientBuilder = HttpClientBuilder.builder();
        }
        return clientBuilder;
    }

    @Override
    public void close() {
        this.api.close();
    }

    public void refresh() throws NessieNotFoundException {
        this.reference.refresh(this.api);
    }

    private UpdateableReference loadReference(String requestedRef, String hash) {
        try {
            Object ref;
            Object object = ref = requestedRef == null ? this.api.getDefaultBranch() : this.api.getReference().refName(requestedRef).get();
            if (hash != null) {
                ref = ref instanceof Branch ? Branch.of((String)ref.getName(), (String)hash) : Tag.of((String)ref.getName(), (String)hash);
            }
            return new UpdateableReference((Reference)ref, hash != null);
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef != null) {
                throw new IllegalArgumentException(String.format("Nessie ref '%s' does not exist. This ref must exist before creating a NessieViewCatalog.", requestedRef), ex);
            }
            throw new IllegalArgumentException(String.format("Nessie does not have an existing default branch.Either configure an alternative ref via %s or create the default branch on the server.", "nessie.ref"), ex);
        }
    }

    @Override
    protected BaseMetastoreViewOperations newViewOps(TableIdentifier viewIdentifier) {
        ViewUtils.validateTableIdentifier(viewIdentifier);
        TableReference tr = TableReference.parse((String)viewIdentifier.name());
        Preconditions.checkArgument((!tr.hasTimestamp() ? 1 : 0) != 0, (Object)"Invalid view name: # is only allowed for hashes (reference by timestamp is not supported)");
        UpdateableReference newReference = this.reference;
        if (tr.getReference() != null) {
            newReference = this.loadReference(tr.getReference(), tr.getHash());
        }
        return new NessieViewOperations(ContentKey.of((Namespace)Namespace.of((String[])viewIdentifier.namespace().levels()), (String)tr.getName()), newReference, this.api, this.fileIO, this.catalogOptions);
    }
}

