/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.params;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v1.params.MultipleNamespacesParamsBuilder;
import org.projectnessie.model.Namespace;

public class MultipleNamespacesParams {
    @Parameter(description="name of ref to fetch", examples={@ExampleObject(ref="ref")})
    @PathParam(value="ref")
    @jakarta.ws.rs.PathParam(value="ref")
    @javax.validation.constraints.NotNull
    @NotNull
    @javax.validation.constraints.Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    private @javax.validation.constraints.NotNull @NotNull @javax.validation.constraints.Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String refName;
    @Parameter(description="the name of the namespace", examples={@ExampleObject(ref="namespaceName"), @ExampleObject(ref="emptyNamespaceName")})
    @QueryParam(value="name")
    @jakarta.ws.rs.QueryParam(value="name")
    @Nullable
    @jakarta.annotation.Nullable
    private Namespace namespace;
    @Parameter(description="a particular hash on the given ref", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")})
    @QueryParam(value="hashOnRef")
    @jakarta.ws.rs.QueryParam(value="hashOnRef")
    @Nullable
    @jakarta.annotation.Nullable
    private String hashOnRef;

    public MultipleNamespacesParams() {
    }

    @Builder.Constructor
    MultipleNamespacesParams(@javax.validation.constraints.NotNull @NotNull String refName, @Nullable @jakarta.annotation.Nullable Namespace namespace, @Nullable @jakarta.annotation.Nullable String hashOnRef) {
        this.refName = refName;
        this.namespace = namespace;
        this.hashOnRef = hashOnRef;
    }

    public String getRefName() {
        return this.refName;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String getHashOnRef() {
        return this.hashOnRef;
    }

    public static MultipleNamespacesParamsBuilder builder() {
        return new MultipleNamespacesParamsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultipleNamespacesParams)) {
            return false;
        }
        MultipleNamespacesParams that = (MultipleNamespacesParams)o;
        return Objects.equals(this.refName, that.refName) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.hashOnRef, that.hashOnRef);
    }

    public int hashCode() {
        return Objects.hash(this.refName, this.namespace, this.hashOnRef);
    }

    public String toString() {
        return new StringJoiner(", ", MultipleNamespacesParams.class.getSimpleName() + "[", "]").add("refName='" + this.refName + "'").add("namespace=" + this.namespace).add("hashOnRef='" + this.hashOnRef + "'").toString();
    }
}

