/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v1.http;

import com.fasterxml.jackson.annotation.JsonView;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.projectnessie.api.v1.ContentApi;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.ser.Views;

@Tag(name="v1")
@Consumes(value={"application/json"})
@Path(value="v1/contents")
public interface HttpContentApi
extends ContentApi {
    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="{key}")
    @Operation(summary="Get object content associated with a key.", description="This operation returns the content-value for a content-key in a named-reference (a branch or tag).\n\nIf the table-metadata is tracked globally (Iceberg), Nessie returns a 'Content' object, that contains the most up-to-date part for the globally tracked part (Iceberg: table-metadata) plus the per-Nessie-reference/hash specific part (Iceberg: snapshot-id, schema-id, partition-spec-id, default-sort-order-id).")
    @APIResponses(value={@APIResponse(responseCode="200", description="Information for table", content={@org.eclipse.microprofile.openapi.annotations.media.Content(mediaType="application/json", examples={@ExampleObject(ref="iceberg")}, schema=@Schema(implementation=Content.class))}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or read object content for a key"), @APIResponse(responseCode="404", description="Table not found on ref")})
    @JsonView(value={Views.V1.class})
    public Content getContent(@Parameter(description="object name to search for", examples={@ExampleObject(ref="ContentKeyGet")}, schema=@Schema(type=SchemaType.STRING)) @PathParam(value="key") ContentKey var1, @Parameter(description="Reference to use. Defaults to default branch if not provided.", examples={@ExampleObject(ref="ref")}) @QueryParam(value="ref") String var2, @Parameter(description="a particular hash on the given ref", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")}) @QueryParam(value="hashOnRef") String var3) throws NessieNotFoundException;

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Get multiple objects' content.", description="Similar to 'getContent', but takes multiple 'ContentKey's and returns the content-values for the one or more content-keys in a named-reference (a branch or tag).\n\nIf the table-metadata is tracked globally (Iceberg), Nessie returns a 'Content' object, that contains the most up-to-date part for the globally tracked part (Iceberg: table-metadata) plus the per-Nessie-reference/hash specific part (Iceberg: snapshot-ID,schema-ID, partition-spec-ID, default-sort-order-ID).")
    @APIResponses(value={@APIResponse(responseCode="200", description="Retrieved successfully.", content={@org.eclipse.microprofile.openapi.annotations.media.Content(mediaType="application/json", examples={@ExampleObject(ref="multiGetResponse")}, schema=@Schema(implementation=GetMultipleContentsResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or read object content for a key"), @APIResponse(responseCode="404", description="Provided ref doesn't exists")})
    @JsonView(value={Views.V1.class})
    public GetMultipleContentsResponse getMultipleContents(@Parameter(description="Reference to use. Defaults to default branch if not provided.", examples={@ExampleObject(ref="ref")}) @QueryParam(value="ref") String var1, @Parameter(description="a particular hash on the given ref", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")}) @QueryParam(value="hashOnRef") String var2, @RequestBody(description="Keys to retrieve.", content={@org.eclipse.microprofile.openapi.annotations.media.Content(examples={@ExampleObject(ref="multiGetRequest")})}) GetMultipleContentsRequest var3) throws NessieNotFoundException;
}

