/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Locale;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableConflict;
import org.projectnessie.model.Util;

@JsonSerialize(as=ImmutableConflict.class)
@JsonDeserialize(as=ImmutableConflict.class)
@Value.Immutable
public interface Conflict {
    @Nullable
    @jakarta.annotation.Nullable
    @JsonDeserialize(using=Util.ConflictTypeDeserializer.class)
    @Value.Parameter(order=1)
    public ConflictType conflictType();

    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=2)
    public ContentKey key();

    @Value.Parameter(order=3)
    public String message();

    public static Conflict conflict(@Nullable @jakarta.annotation.Nullable ConflictType conflictType, @Nullable @jakarta.annotation.Nullable ContentKey key, String message) {
        return ImmutableConflict.of(conflictType, key, message);
    }

    public static enum ConflictType {
        UNKNOWN,
        KEY_EXISTS,
        KEY_DOES_NOT_EXIST,
        PAYLOAD_DIFFERS,
        CONTENT_ID_DIFFERS,
        VALUE_DIFFERS,
        NAMESPACE_ABSENT,
        NOT_A_NAMESPACE,
        NAMESPACE_NOT_EMPTY,
        UNEXPECTED_HASH,
        KEY_CONFLICT;


        public static ConflictType parse(String conflictType) {
            try {
                if (conflictType != null) {
                    return ConflictType.valueOf(conflictType.toUpperCase(Locale.ROOT));
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }
}

