/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.deltalake;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.storage.ClosableIterator;
import org.apache.spark.sql.delta.storage.DeltaFileType;
import org.apache.spark.sql.delta.storage.LogFileMeta;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.FileNames$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.deltalake.DeltaContentKeyUtil$;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.TableReference;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u001df\u0001B\u00181\u0001]B\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t/\u0002\u0011\t\u0011)A\u00051\")\u0001\r\u0001C\u0001C\"9a\r\u0001b\u0001\n\u00039\u0007B\u0002:\u0001A\u0003%\u0001\u000eC\u0004t\u0001\t\u0007I\u0011A4\t\rQ\u0004\u0001\u0015!\u0003i\u0011\u001d)\bA1A\u0005\u0002\u001dDaA\u001e\u0001!\u0002\u0013A\u0007bB<\u0001\u0001\u0004%\t\u0001\u001f\u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0001\u0003#Aq!!\b\u0001A\u0003&\u0011\u0010C\u0005\u0002 \u0001\u0011\r\u0011\"\u0003\u0002\"!A\u0011\u0011\u0007\u0001!\u0002\u0013\t\u0019\u0003C\u0004\u00024\u0001!I!!\u000e\t\u000f\u0005]\u0002\u0001\"\u0003\u00026!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002\"CA\"\u0001\t\u0007I\u0011BA#\u0011!\tI\u0006\u0001Q\u0001\n\u0005\u001d\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003?\u0002A\u0011BA1\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!a\u001c\u0001\t\u0013\t\t\bC\u0004\u0002v\u0001!\t%a\u001e\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011Q\u0016\u0001\u0005B\u0005=\u0006\"CAb\u0001E\u0005I\u0011AAc\u0011\u001d\tY\u000e\u0001C\u0005\u0003;D\u0011\"!>\u0001#\u0003%I!a>\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u0012\u0001\u0011%!Q\u0005\u0005\n\u0005k\u0001\u0011\u0013!C\u0005\u0003oD\u0011Ba\u000e\u0001#\u0003%I!a>\t\u000f\te\u0002\u0001\"\u0005\u0003<!9!Q\t\u0001\u0005\u0002\t\u001d\u0003b\u0002B*\u0001\u0011\u0005!Q\u000b\u0005\b\u0005?\u0002A\u0011\u0001B1\u0011\u001d\u0011i\u0007\u0001C\u0001\u0005_BqAa\u001d\u0001\t\u0003\u0011)\bC\u0004\u0003|\u0001!IA! \t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\"9!\u0011\u0013\u0001\u0005B\tM\u0005b\u0002BL\u0001\u0011\u0005#\u0011\u0014\u0005\b\u00057\u0003A\u0011\tBO\u0011\u001d\u0011\t\u000b\u0001C!\u0005G\u0013aBT3tg&,Gj\\4Ti>\u0014XM\u0003\u00022e\u0005IA-\u001a7uC2\f7.\u001a\u0006\u0003gQ\nQ\u0002\u001d:pU\u0016\u001cGO\\3tg&,'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Ad\b\u0014\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}RU\"\u0001!\u000b\u0005\u0005\u0013\u0015aB:u_J\fw-\u001a\u0006\u0003\u0007\u0012\u000bQ\u0001Z3mi\u0006T!!\u0012$\u0002\u0007M\fHN\u0003\u0002H\u0011\u0006)1\u000f]1sW*\u0011\u0011\nN\u0001\u0007CB\f7\r[3\n\u0005-\u0003%\u0001\u0003'pON#xN]3\u0011\u00055\u0003V\"\u0001(\u000b\u0005=3\u0015\u0001C5oi\u0016\u0014h.\u00197\n\u0005Es%a\u0002'pO\u001eLgnZ\u0001\ngB\f'o[\"p]\u001a\u0004\"\u0001V+\u000e\u0003\u0019K!A\u0016$\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u00035bI>|\u0007oQ8oMB\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0005G>tgM\u0003\u0002^\u0011\u00061\u0001.\u00193p_BL!a\u0018.\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0019!\rZ3\u0011\u0005\r\u0004Q\"\u0001\u0019\t\u000bI\u001b\u0001\u0019A*\t\u000b]\u001b\u0001\u0019\u0001-\u0002!\u0011,G\u000e^1GS2,\u0007+\u0019;uKJtW#\u00015\u0011\u0005%\u0004X\"\u00016\u000b\u0005-d\u0017!\u0002:fO\u0016D(BA7o\u0003\u0011)H/\u001b7\u000b\u0003=\fAA[1wC&\u0011\u0011O\u001b\u0002\b!\u0006$H/\u001a:o\u0003E!W\r\u001c;b\r&dW\rU1ui\u0016\u0014h\u000eI\u0001\u0014G\",7m[:v[\u001aKG.\u001a)biR,'O\\\u0001\u0015G\",7m[:v[\u001aKG.\u001a)biR,'O\u001c\u0011\u0002+\rDWmY6q_&tGOR5mKB\u000bG\u000f^3s]\u000612\r[3dWB|\u0017N\u001c;GS2,\u0007+\u0019;uKJt\u0007%\u0001\tmCN$8K\\1qg\"|G/V;jIV\t\u0011\u0010E\u0002:urL!a\u001f\u001e\u0003\r=\u0003H/[8o!\ri\u0018\u0011\u0002\b\u0004}\u0006\u0015\u0001CA@;\u001b\t\t\tAC\u0002\u0002\u0004Y\na\u0001\u0010:p_Rt\u0014bAA\u0004u\u00051\u0001K]3eK\u001aLA!a\u0003\u0002\u000e\t11\u000b\u001e:j]\u001eT1!a\u0002;\u0003Qa\u0017m\u001d;T]\u0006\u00048\u000f[8u+VLGm\u0018\u0013fcR!\u00111CA\r!\rI\u0014QC\u0005\u0004\u0003/Q$\u0001B+oSRD\u0001\"a\u0007\f\u0003\u0003\u0005\r!_\u0001\u0004q\u0012\n\u0014!\u00057bgR\u001cf.\u00199tQ>$X+^5eA\u0005\u0019\u0011\r]5\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003[i!!a\n\u000b\t\u0005}\u0011\u0011\u0006\u0006\u0004\u0003W\u0011\u0014AB2mS\u0016tG/\u0003\u0003\u00020\u0005\u001d\"a\u0003(fgNLW-\u00119j-F\nA!\u00199jA\u0005Y1-\u0019;bY><g*Y7f)\u0005a\u0018A\u00029sK\u001aL\u00070A\u0006dCR\fGn\\4D_:4WCAA\u001f!\u0015i\u0018q\b?}\u0013\u0011\t\t%!\u0004\u0003\u00075\u000b\u0007/\u0001\u0007sK\u001a,'/\u001a8dK6\u000b\u0007/\u0006\u0002\u0002HA9\u0011\u0011JA&y\u00065S\"\u00017\n\u0007\u0005\u0005C\u000e\u0005\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019FM\u0001\u0006[>$W\r\\\u0005\u0005\u0003/\n\tFA\u0005SK\u001a,'/\u001a8dK\u0006i!/\u001a4fe\u0016t7-Z'ba\u0002\nQbY8oM&<WO]3e%\u00164GCAA'\u0003=\u0011XMZ3sK:\u001cWMQ=OC6,G\u0003BA'\u0003GBa!!\u001a\u0016\u0001\u0004a\u0018a\u0002:fM:\u000bW.Z\u0001\u0010kB$\u0017\r^3SK\u001a,'/\u001a8dKR!\u00111CA6\u0011\u001d\tiG\u0006a\u0001\u0003\u001b\n1A]3g\u0003A\u0011XM\u001a:fg\"\u0014VMZ3sK:\u001cW\r\u0006\u0003\u0002\u0014\u0005M\u0004BBA3/\u0001\u0007A0\u0001\u0005mSN$hI]8n)\u0011\tI(a&\u0011\r\u0005m\u0014QQAF\u001d\u0011\ti(!!\u000f\u0007}\fy(C\u0001<\u0013\r\t\u0019IO\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9)!#\u0003\u0011%#XM]1u_JT1!a!;!\u0011\ti)a%\u000e\u0005\u0005=%bAAI9\u0006\u0011am]\u0005\u0005\u0003+\u000byI\u0001\u0006GS2,7\u000b^1ukNDq!!'\u0019\u0001\u0004\tY*\u0001\u0003qCRD\u0007\u0003BAG\u0003;KA!a(\u0002\u0010\n!\u0001+\u0019;i\u0003Q\u0001\u0018M]:f)\u0006\u0014G.Z%eK:$\u0018NZ5feR!\u0011QUAV!\u0019I\u0014q\u0015?}y&\u0019\u0011\u0011\u0016\u001e\u0003\rQ+\b\u000f\\34\u0011\u0019\tI*\u0007a\u0001y\u0006)qO]5uKRA\u00111CAY\u0003g\u000bI\fC\u0004\u0002\u001aj\u0001\r!a'\t\u000f\u0005U&\u00041\u0001\u00028\u00069\u0011m\u0019;j_:\u001c\b#BA>\u0003\u000bc\b\"CA^5A\u0005\t\u0019AA_\u0003%yg/\u001a:xe&$X\rE\u0002:\u0003\u007fK1!!1;\u0005\u001d\u0011un\u001c7fC:\fqb\u001e:ji\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000fTC!!0\u0002J.\u0012\u00111\u001a\t\u0005\u0003\u001b\f9.\u0004\u0002\u0002P*!\u0011\u0011[Aj\u0003%)hn\u00195fG.,GMC\u0002\u0002Vj\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI.a4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\tva\u0012\fG/\u001a#fYR\fG+\u00192mKRQ\u0011q\\As\u0003W\fi/!=\u0011\t\u0005=\u0013\u0011]\u0005\u0005\u0003G\f\tF\u0001\bEK2$\u0018\rT1lKR\u000b'\r\\3\t\u000f\u0005\u001dH\u00041\u0001\u0002j\u0006a1-\u001e:sK:$H+\u00192mKB!\u0011H_Ap\u0011\u001d\tI\n\ba\u0001\u00037Ca!a<\u001d\u0001\u0004a\u0018!\u0003;be\u001e,GOU3g\u0011!\t\u0019\u0010\bI\u0001\u0002\u0004a\u0018A\u00047bgR\u001c\u0005.Z2la>Lg\u000e^\u0001\u001bkB$\u0017\r^3EK2$\u0018\rV1cY\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003sT3\u0001`Ae\u0003E)\u0007\u0010\u001e:bGR\u001c\u0005.Z2la>Lg\u000e\u001e\u000b\u0007\u0003\u007f\u0014\tBa\u0005\u0011\u000fe\u0012\tA!\u0002\u0003\f%\u0019!1\u0001\u001e\u0003\rQ+\b\u000f\\33!\rI$qA\u0005\u0004\u0005\u0013Q$\u0001\u0002'p]\u001e\u0004R!a\u001f\u0003\u000eqLAAa\u0004\u0002\n\n\u00191+Z9\t\r\u0005Mh\u00041\u0001}\u0011\u001d\tIJ\ba\u0001\u00037\u000b1#\\8wK\u000eCWmY6q_&tGOR5mKN$bAa\u0003\u0003\u001a\t}\u0001b\u0002B\u000e?\u0001\u0007!QD\u0001\u0006M&dWm\u001d\t\u0007\u0003w\u0012i!a'\t\u000f\t\u0005r\u00041\u0001\u0002\u001c\u00069A-Z:u\t&\u0014\u0018AB2p[6LG\u000f\u0006\u0007\u0002>\n\u001d\"\u0011\u0006B\u0016\u0005_\u0011\u0019\u0004C\u0004\u0002\u001a\u0002\u0002\r!a'\t\r\u00055\u0004\u00051\u0001}\u0011\u0019\u0011i\u0003\ta\u0001y\u0006!\u0001.Y:i\u0011!\u0011\t\u0004\tI\u0001\u0002\u0004a\u0018aB7fgN\fw-\u001a\u0005\t\u0003g\u0004\u0003\u0013!a\u0001y\u0006\u00012m\\7nSR$C-\u001a4bk2$H\u0005N\u0001\u0011G>lW.\u001b;%I\u00164\u0017-\u001e7uIU\nQb\u001e:ji\u0016Le\u000e^3s]\u0006dGCCA\n\u0005{\u0011yD!\u0011\u0003D!9\u0011\u0011T\u0012A\u0002\u0005m\u0005bBA[G\u0001\u0007\u0011q\u0017\u0005\u0007\u0003[\u001a\u0003\u0019\u0001?\t\r\t52\u00051\u0001}\u0003IqW/\\\"iK\u000e\\\u0007o\\5oiB\u000b'\u000f^:\u0015\t\t%#\u0011\u000b\t\u0005si\u0014Y\u0005E\u0002:\u0005\u001bJ1Aa\u0014;\u0005\rIe\u000e\u001e\u0005\b\u00033#\u0003\u0019AAN\u0003-9W\r\u001e$jY\u0016$\u0016\u0010]3\u0015\t\t]#Q\f\t\u0004\u007f\te\u0013b\u0001B.\u0001\niA)\u001a7uC\u001aKG.\u001a+za\u0016Dq!!'&\u0001\u0004\tY*A\u0006fqR\u0014\u0018m\u0019;NKR\fG\u0003\u0002B2\u0005S\u00022a\u0010B3\u0013\r\u00119\u0007\u0011\u0002\f\u0019><g)\u001b7f\u001b\u0016$\u0018\rC\u0004\u0003l\u0019\u0002\r!a#\u0002\u0015\u0019LG.Z*uCR,8/\u0001\bfqR\u0014\u0018m\u0019;WKJ\u001c\u0018n\u001c8\u0015\t\t\u0015!\u0011\u000f\u0005\b\u00033;\u0003\u0019AAN\u00035a\u0017n\u001d;GS2,7O\u0012:p[R!!q\u000fB=!\u0019\tY(!\"\u0003d!9\u0011\u0011\u0014\u0015A\u0002\u0005m\u0015aD3naRL8\t[3dWB|\u0017N\u001c;\u0015\r\t\r$q\u0010BB\u0011\u001d\u0011\t)\u000ba\u0001\u0005\u000b\tqA^3sg&|g\u000eC\u0004\u0003\u0006&\u0002\rAa\u0019\u0002\u00171|wMR5mK6+G/Y\u0001\tO\u0016$H+\u00192mKR1\u0011\u0011\u001eBF\u0005\u001bCq!!'+\u0001\u0004\tY\n\u0003\u0004\u0003\u0010*\u0002\r\u0001`\u0001\u0007EJ\fgn\u00195\u0002\tI,\u0017\r\u001a\u000b\u0005\u0005\u0017\u0011)\nC\u0004\u0002\u001a.\u0002\r!a'\u0002\u001f%tg/\u00197jI\u0006$XmQ1dQ\u0016$\"!a\u0005\u0002+%\u001c\b+\u0019:uS\u0006dwK]5uKZK7/\u001b2mKR!\u0011Q\u0018BP\u0011\u001d\tI*\fa\u0001\u00037\u000bQC]3t_24Xm\u00115fG.\u0004x.\u001b8u!\u0006$\b\u000e\u0006\u0003\u0002\u001c\n\u0015\u0006bBAM]\u0001\u0007\u00111\u0014")
public class NessieLogStore
implements LogStore,
Logging {
    private final SparkConf sparkConf;
    private final Configuration hadoopConf;
    private final Pattern deltaFilePattern;
    private final Pattern checksumFilePattern;
    private final Pattern checkpointFilePattern;
    private Option<String> lastSnapshotUuid;
    private final NessieApiV1 api;
    private final Map<String, Reference> referenceMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public final Seq<String> read(String path) {
        return LogStore.read$((LogStore)this, (String)path);
    }

    public Seq<String> read(Path path, Configuration hadoopConf) {
        return LogStore.read$((LogStore)this, (Path)path, (Configuration)hadoopConf);
    }

    public final ClosableIterator<String> readAsIterator(String path) {
        return LogStore.readAsIterator$((LogStore)this, (String)path);
    }

    public ClosableIterator<String> readAsIterator(Path path) {
        return LogStore.readAsIterator$((LogStore)this, (Path)path);
    }

    public ClosableIterator<String> readAsIterator(Path path, Configuration hadoopConf) {
        return LogStore.readAsIterator$((LogStore)this, (Path)path, (Configuration)hadoopConf);
    }

    public final void write(String path, Iterator<String> actions) {
        LogStore.write$((LogStore)this, (String)path, actions);
    }

    public void write(Path path, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        LogStore.write$((LogStore)this, (Path)path, actions, (boolean)overwrite, (Configuration)hadoopConf);
    }

    public final Iterator<FileStatus> listFrom(String path) {
        return LogStore.listFrom$((LogStore)this, (String)path);
    }

    public Iterator<FileStatus> listFrom(Path path, Configuration hadoopConf) {
        return LogStore.listFrom$((LogStore)this, (Path)path, (Configuration)hadoopConf);
    }

    public Path resolvePathOnPhysicalStorage(Path path) {
        return LogStore.resolvePathOnPhysicalStorage$((LogStore)this, (Path)path);
    }

    public Path resolvePathOnPhysicalStorage(Path path, Configuration hadoopConf) {
        return LogStore.resolvePathOnPhysicalStorage$((LogStore)this, (Path)path, (Configuration)hadoopConf);
    }

    public boolean isPartialWriteVisible(Path path, Configuration hadoopConf) {
        return LogStore.isPartialWriteVisible$((LogStore)this, (Path)path, (Configuration)hadoopConf);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Pattern deltaFilePattern() {
        return this.deltaFilePattern;
    }

    public Pattern checksumFilePattern() {
        return this.checksumFilePattern;
    }

    public Pattern checkpointFilePattern() {
        return this.checkpointFilePattern;
    }

    public Option<String> lastSnapshotUuid() {
        return this.lastSnapshotUuid;
    }

    public void lastSnapshotUuid_$eq(Option<String> x$1) {
        this.lastSnapshotUuid = x$1;
    }

    private NessieApiV1 api() {
        return this.api;
    }

    private String catalogName() {
        CatalogPlugin currentCatalog = SparkSession$.MODULE$.active().sessionState().catalogManager().currentCatalog();
        return currentCatalog.name();
    }

    private String prefix() {
        return new StringBuilder(19).append("spark.sql.catalog.").append(this.catalogName()).append(".").toString();
    }

    private scala.collection.immutable.Map<String, String> catalogConf() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SparkSession$.MODULE$.active().sparkContext().getConf().getAllWithPrefix(this.prefix()))).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, Reference> referenceMap() {
        return this.referenceMap;
    }

    private Reference configuredRef() {
        String refName = SparkSession$.MODULE$.active().sparkContext().getConf().get(new StringBuilder(3).append(this.prefix()).append("ref").toString());
        return this.referenceByName(refName);
    }

    private Reference referenceByName(String refName) {
        Object object;
        Reference ref = this.referenceMap().get(refName);
        if (ref == null) {
            ref = this.api().getReference().refName(refName).get();
            object = this.referenceMap().put(refName, ref);
        } else {
            object = BoxedUnit.UNIT;
        }
        return ref;
    }

    private void updateReference(Reference ref) {
        this.referenceMap().put(ref.getName(), ref);
    }

    private void refreshReference(String refName) {
        this.referenceMap().remove(refName);
    }

    public Iterator<FileStatus> listFrom(Path path) {
        throw new UnsupportedOperationException("listFrom from Nessie does not work.");
    }

    private Tuple3<String, String, String> parseTableIdentifier(String path) {
        TableReference tr = TableReference.parse(path);
        if (tr.hasTimestamp()) {
            throw new IllegalArgumentException("Invalid table name: # is only allowed for hashes (reference by timestamp is not supported)");
        }
        if (tr.hasReference()) {
            return new Tuple3((Object)tr.getName(), (Object)tr.getReference(), (Object)tr.getHash());
        }
        return new Tuple3((Object)path, (Object)SparkSession$.MODULE$.active().sparkContext().getConf().get(new StringBuilder(3).append(this.prefix()).append("ref").toString()), (Object)SparkSession$.MODULE$.active().sparkContext().getConf().get(new StringBuilder(4).append(this.prefix()).append("hash").toString(), null));
    }

    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        if (path.getName().equals("_last_checkpoint")) {
            Path x$1 = path;
            String x$2 = this.configuredRef().getName();
            String x$3 = this.configuredRef().getHash();
            String x$4 = actions.mkString();
            String x$5 = this.commit$default$4();
            this.commit(x$1, x$2, x$3, x$5, x$4);
            return;
        }
        Path parent = path.getParent();
        String[] nameSplit = path.getName().split("\\.", 2);
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(nameSplit[0]);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        String tableName2 = (String)tuple32._1();
        String ref2 = (String)tuple32._2();
        String hash2 = (String)tuple32._3();
        String name = new StringBuilder(2).append(tableName2).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(nameSplit[1]).toString();
        Path nessiePath = new Path(parent, name);
        if (overwrite) {
            throw new IllegalStateException(new StringBuilder(32).append("Nessie won't overwrite for path ").append(path).toString());
        }
        this.writeInternal(nessiePath, actions, ref2, hash2);
    }

    public boolean write$default$3() {
        return false;
    }

    private DeltaLakeTable updateDeltaTable(Option<DeltaLakeTable> currentTable, Path path, String targetRef, String lastCheckpoint) {
        ImmutableDeltaLakeTable table = (ImmutableDeltaLakeTable)currentTable.map((Function1 & Serializable & scala.Serializable)instance -> ImmutableDeltaLakeTable.copyOf(instance)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ImmutableDeltaLakeTable.builder().build());
        DeltaFileType deltaFileType = this.getFileType(path);
        if (DeltaFileType.DELTA$.MODULE$.equals(deltaFileType)) {
            String string = path.toString();
            return table.withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(table.getMetadataLocationHistory()).asScala()).toList().$colon$colon((Object)string)).asJava());
        }
        if (DeltaFileType.CHECKPOINT$.MODULE$.equals(deltaFileType)) {
            throw new UnsupportedOperationException("Can't write checkpoints from LogStore");
        }
        if (DeltaFileType.CHECKSUM$.MODULE$.equals(deltaFileType)) {
            return table;
        }
        if (DeltaFileType.UNKNOWN$.MODULE$.equals(deltaFileType)) {
            if (!path.getName().equals("_last_checkpoint")) {
                return table;
            }
            Tuple2<Object, Seq<String>> tuple2 = this.extractCheckpoint(lastCheckpoint, path.getParent());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long version = tuple2._1$mcJ$sp();
            Seq parts = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)version), (Object)parts);
            long version2 = tuple22._1$mcJ$sp();
            Seq parts2 = (Seq)tuple22._2();
            return table.withCheckpointLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(parts2).asJava()).withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(table.getCheckpointLocationHistory()).asScala()).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$updateDeltaTable$3(this, version2, x)))).asJava()).withLastCheckpoint(lastCheckpoint);
        }
        return table;
    }

    private String updateDeltaTable$default$4() {
        return null;
    }

    private Tuple2<Object, Seq<String>> extractCheckpoint(String lastCheckpoint, Path path) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        CheckpointMetaData checkpoint = (CheckpointMetaData)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(lastCheckpoint), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(CheckpointMetaData.class));
        long version = checkpoint.version();
        Option parts = checkpoint.parts();
        Path tempPath = new Path(path, (String)this.lastSnapshotUuid().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("didn't write the correct checkpoint dir");
        }));
        Seq files = parts.isEmpty() ? (Seq)new .colon.colon((Object)FileNames$.MODULE$.checkpointFileSingular(tempPath, version), (List)Nil$.MODULE$) : FileNames$.MODULE$.checkpointFileWithParts(tempPath, version, BoxesRunTime.unboxToInt((Object)checkpoint.parts().get()));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)version), this.moveCheckpointFiles((Seq<Path>)files, path));
    }

    private Seq<String> moveCheckpointFiles(Seq<Path> files, Path destDir) {
        Seq movedFiles = (Seq)files.map((Function1 & Serializable & scala.Serializable)f -> {
            FileSystem fs = f.getFileSystem($this.hadoopConf);
            String[] parts = f.getName().split("\\.", 2);
            String destFile = new StringBuilder(2).append(parts[0]).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(parts[1]).toString();
            Path dest = new Path(destDir, destFile);
            fs.rename(f, dest);
            return dest.toString();
        }, Seq$.MODULE$.canBuildFrom());
        ((Path)files.head()).getFileSystem(this.hadoopConf).delete(((Path)files.head()).getParent(), true);
        return movedFiles;
    }

    private boolean commit(Path path, String ref, String hash, String message, String lastCheckpoint) {
        int retries = hash == null ? 1 : 0;
        while (true) {
            String targetRef = ref == null ? this.configuredRef().getName() : ref;
            String targetHash = hash == null ? this.referenceByName(targetRef).getHash() : hash;
            Option<DeltaLakeTable> currentTable = this.getTable(path.getParent(), targetRef);
            DeltaLakeTable table = this.updateDeltaTable(currentTable, path, targetRef, lastCheckpoint);
            Operation.Put put = Operation.Put.of(DeltaContentKeyUtil$.MODULE$.fromHadoopPath(path.getParent()), table);
            ImmutableCommitMeta meta = CommitMeta.builder().message(message).putProperties("spark.app.id", this.sparkConf.get("spark.app.id")).putProperties("application.type", "delta").build();
            try {
                Branch updated = ((CommitMultipleOperationsBuilder)this.api().commitMultipleOperations().branchName(targetRef).hash(targetHash)).operation(put).commitMeta(meta).commit();
                this.updateReference(updated != null ? updated : this.api().getReference().refName(targetRef).get());
                return true;
            }
            catch (NessieConflictException ex) {
                this.refreshReference(targetRef);
                if (retries <= 0) {
                    throw ex;
                }
                --retries;
                continue;
            }
            break;
        }
    }

    private String commit$default$4() {
        return "delta commit";
    }

    private String commit$default$5() {
        return null;
    }

    public void writeInternal(Path path, Iterator<String> actions, String ref, String hash) {
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        if (!fs.exists(path.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
        }
        if (fs.exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        boolean streamClosed = false;
        boolean commitDone = false;
        FSDataOutputStream stream = fs.create(path);
        try {
            actions.map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(1).append((String)x$5).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                stream.write(x$1);
                return BoxedUnit.UNIT;
            });
            stream.close();
            streamClosed = true;
            try {
                commitDone = this.commit(path, ref, hash, this.commit$default$4(), this.commit$default$5());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!commitDone) {
                fs.delete(path, false);
            }
        }
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] stringArray;
        String[] segments = path.getName().split("\\.");
        String[] stringArray2 = segments;
        if (stringArray2 != null && (stringArray = stringArray2).length == 6) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(segments[4])).toInt()));
        }
        return None$.MODULE$;
    }

    public DeltaFileType getFileType(Path path) {
        Path path2 = path;
        if (this.checkpointFilePattern().matcher(path.getName()).matches()) {
            return DeltaFileType.CHECKPOINT$.MODULE$;
        }
        if (this.deltaFilePattern().matcher(path.getName()).matches()) {
            return DeltaFileType.DELTA$.MODULE$;
        }
        if (this.checksumFilePattern().matcher(path.getName()).matches()) {
            return DeltaFileType.CHECKSUM$.MODULE$;
        }
        return DeltaFileType.UNKNOWN$.MODULE$;
    }

    public LogFileMeta extractMeta(FileStatus fileStatus) {
        return new LogFileMeta(fileStatus, this.extractVersion(fileStatus.getPath()), this.getFileType(fileStatus.getPath()), this.numCheckpointParts(fileStatus.getPath()));
    }

    public long extractVersion(Path path) {
        DeltaFileType deltaFileType = this.getFileType(path);
        if (DeltaFileType.DELTA$.MODULE$.equals(deltaFileType)) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".json").split("-")[0])).toLong();
        }
        if (DeltaFileType.CHECKPOINT$.MODULE$.equals(deltaFileType)) {
            return new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0].split("-")[0])).toLong();
        }
        if (DeltaFileType.CHECKSUM$.MODULE$.equals(deltaFileType)) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".crc").split("-")[0])).toLong();
        }
        return -1L;
    }

    public Iterator<LogFileMeta> listFilesFrom(Path path2) {
        FileSystem fs = path2.getFileSystem(this.hadoopConf);
        if (!fs.exists(path2.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path2.getParent()).toString());
        }
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(path2.toUri().getPath());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        String tableName2 = (String)tuple32._1();
        String ref2 = (String)tuple32._2();
        String hash2 = (String)tuple32._3();
        String name = null;
        name = hash2 != null ? hash2 : (ref2 != null ? ref2 : this.configuredRef().getName());
        Option<DeltaLakeTable> currentTable = this.getTable(new Path(tableName2).getParent(), name);
        Set currentMetadataPath = (Set)currentTable.map((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8.getMetadataLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> new Path(x$9), Buffer$.MODULE$.canBuildFrom())).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new FileNotFoundException(new StringBuilder(15).append("No such table: ").append(path2).toString());
        });
        Set currentPath = ((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory() != null ? (Set)currentMetadataPath.$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> new Path(x$10), Buffer$.MODULE$.canBuildFrom())) : currentMetadataPath;
        long requestedVersion = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> FileNames$.MODULE$.getFileVersion(path2)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path2.getName())).stripSuffix(".checkpoint"))).toLong()));
        FileStatus[] files = fs.listStatus(path2.getParent());
        LogFileMeta[] filteredFiles = (LogFileMeta[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)fileStatus -> this.extractMeta((FileStatus)fileStatus), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)currentPath.contains((Object)x.fileStatus().getPath()))))).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$9(requestedVersion, x$11))))).sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.version()), (Ordering)Ordering.Long$.MODULE$);
        None$ maxExpected = currentPath.nonEmpty() ? new Some(((TraversableOnce)currentPath.map((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToLong((long)this.extractVersion(path)), Set$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        None$ maxFound = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).nonEmpty() ? new Some(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.version()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)maxFound.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) == BoxesRunTime.unboxToLong((Object)maxExpected.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), () -> NessieLogStore.$anonfun$listFilesFrom$15((Option)maxFound, (Option)maxExpected));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.fileType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DeltaFileType.class))))).count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$19(x$15))) == filteredFiles.length) {
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.emptyCheckpoint(requestedVersion, (LogFileMeta)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).head()), (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).iterator();
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).iterator();
    }

    private LogFileMeta emptyCheckpoint(long version, LogFileMeta logFileMeta) {
        FileStatus fileStatus = new FileStatus(0L, false, 0, 0L, logFileMeta.fileStatus().getModificationTime(), FileNames$.MODULE$.deltaFile(logFileMeta.fileStatus().getPath().getParent(), version));
        return new LogFileMeta(fileStatus, version, (DeltaFileType)DeltaFileType.DELTA$.MODULE$, (Option)None$.MODULE$);
    }

    private Option<DeltaLakeTable> getTable(Path path, String branch) {
        ContentKey key = DeltaContentKeyUtil$.MODULE$.fromHadoopPath(path);
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((GetContentBuilder)this.api().getContent().key(key).refName(branch)).get().get(key)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$getTable$2(x))).map((Function1 & Serializable & scala.Serializable)x$16 -> (DeltaLakeTable)x$16).toOption();
    }

    public Seq<String> read(Path path) {
        Seq seq;
        if (path.getName().equals("_last_checkpoint")) {
            Option<DeltaLakeTable> table = this.getTable(path.getParent(), this.configuredRef().getName());
            String data = (String)table.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.getLastCheckpoint()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new FileNotFoundException();
            });
            if (data == null) {
                throw new FileNotFoundException();
            }
            return (Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$);
        }
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        try (FSDataInputStream stream = fs.open(path);){
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
            seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((Reader)reader)).asScala()).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.trim(), Buffer$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public void invalidateCache() {
    }

    public boolean isPartialWriteVisible(Path path) {
        return true;
    }

    public Path resolveCheckpointPath(Path path) {
        this.lastSnapshotUuid_$eq((Option<String>)new Some((Object)UUID.randomUUID().toString()));
        return path.getFileSystem(this.hadoopConf).makeQualified(new Path(path, (String)this.lastSnapshotUuid().get()));
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Map liftedTree1$1(String requestedRef$1) {
        void v0;
        try {
            void var3_3;
            Reference ref = (Reference)Option$.MODULE$.apply((Object)requestedRef$1).map((Function1 & Serializable & scala.Serializable)x$1 -> this.api().getReference().refName((String)x$1).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.api().getDefaultBranch());
            HashMap<String, Reference> map = new HashMap<String, Reference>();
            map.put(requestedRef$1, ref);
            v0 = var3_3;
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef$1 != null) {
                throw new IllegalArgumentException(new StringBuilder(104).append("Nessie ref ").append(requestedRef$1).append(" provided ").append("via ").append("nessie.ref").append(" does not exist. This ref must exist before creating a NessieCatalog.").toString(), ex);
            }
            throw new IllegalArgumentException(new StringBuilder(143).append("Nessie does not have an existing default branch. Either configure ").append("an alternative ref via ").append("nessie.ref").append(" or create the default branch on the server.").toString(), ex);
        }
        return v0;
    }

    public static final /* synthetic */ boolean $anonfun$updateDeltaTable$3(NessieLogStore $this, long version$1, String x) {
        return $this.extractVersion(new Path(x)) < version$1;
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$9(long requestedVersion$1, LogFileMeta x$11) {
        return x$11.version() >= requestedVersion$1;
    }

    public static final /* synthetic */ String $anonfun$listFilesFrom$15(Option maxFound$1, Option maxExpected$1) {
        return new StringBuilder(27).append("maxFound(").append(maxFound$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)).append(") != maxExpected(").append(maxExpected$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$19(DeltaFileType x$15) {
        DeltaFileType deltaFileType = x$15;
        DeltaFileType.CHECKPOINT$ cHECKPOINT$ = DeltaFileType.CHECKPOINT$.MODULE$;
        return !(deltaFileType != null ? !deltaFileType.equals(cHECKPOINT$) : cHECKPOINT$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTable$2(Content x) {
        return x != null && x instanceof DeltaLakeTable;
    }

    public NessieLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        this.sparkConf = sparkConf;
        this.hadoopConf = hadoopConf;
        LogStore.$init$((LogStore)this);
        Logging.$init$((Logging)this);
        this.deltaFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.json")).r().pattern();
        this.checksumFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.crc")).r().pattern();
        this.checkpointFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.checkpoint(\\.\\d+\\.\\d+)?\\.parquet")).r().pattern();
        this.lastSnapshotUuid = None$.MODULE$;
        Function1 & Serializable & scala.Serializable removePrefix = (Function1 & Serializable & scala.Serializable)x -> x.replace("nessie.", "");
        this.api = ((HttpClientBuilder)HttpClientBuilder.builder().fromConfig(c -> (String)this.catalogConf().getOrElse(removePrefix.apply(c), (Function0 & Serializable & scala.Serializable)() -> null))).build(NessieApiV1.class);
        String requestedRef = SparkSession$.MODULE$.active().sparkContext().getConf().get(new StringBuilder(3).append(this.prefix()).append("ref").toString());
        this.referenceMap = this.liftedTree1$1(requestedRef);
    }
}

