/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.model.Base;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Detached;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Util;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Reference", oneOf={Branch.class, Tag.class, Detached.class}, discriminatorMapping={@DiscriminatorMapping(value="TAG", schema=Tag.class), @DiscriminatorMapping(value="BRANCH", schema=Branch.class), @DiscriminatorMapping(value="DETACHED", schema=Detached.class)}, discriminatorProperty="type", properties={@SchemaProperty(name="name", pattern="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$"), @SchemaProperty(name="hash", pattern="^[0-9a-fA-F]{8,64}$"), @SchemaProperty(name="metadata", nullable=true)})
@JsonSubTypes(value={@JsonSubTypes.Type(value=Branch.class), @JsonSubTypes.Type(value=Tag.class), @JsonSubTypes.Type(value=Detached.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public interface Reference
extends Base {
    @NotBlank
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    public @NotBlank @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String getName();

    @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    public @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String getHash();

    @Value.Check
    default public void checkHash() {
        String hash = this.getHash();
        if (hash != null) {
            Validation.validateHash(hash);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public ReferenceMetadata getMetadata();

    @JsonIgnore
    @Value.Redacted
    public ReferenceType getType();

    default public String toPathString() {
        return Reference.toPathString(this.getName(), this.getHash());
    }

    public static String toPathString(String name, String hash) {
        return Util.toPathStringRef(name, hash);
    }

    @Schema(enumeration={"branch", "tag"})
    public static enum ReferenceType {
        BRANCH,
        TAG;

    }
}

