/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v2.params.DiffParamsBuilder;
import org.projectnessie.api.v2.params.KeyRangeParams;
import org.projectnessie.model.ContentKey;

public class DiffParams
extends KeyRangeParams<DiffParams> {
    @NotNull
    @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit")
    @Parameter(description="A reference to a particular version of the contents tree (a point in history).\n\nReference representations consist of:\n- The reference name. '-' means the default branch name.\n- A commit hash prefixed with '@'.\n- A relative commit specification. '~N' means the N-th predecessor commit, '*T' means the commit for which the timestamp T (milliseconds since epoch or ISO-8601 instant) is valid, '^N' means the N-th parentin a commit (N=2 is the merge parent).\n\nIf neither the reference name or the default branch name placeholder '-' is specified, the reference type 'DETACHED' will be assumed.\nIf no commit hash is specified, the HEAD of the specified named reference will be used.\nAn empty reference parameter is not valid.\n\nThis reference can be specified in these forms:\n- \\- (literal minus character) - identifies the HEAD of the default branch.\n- name - Identifies the HEAD commit of a branch or tag.\n- name@hash - Identifies the 'hash' commit on a branch or tag.\n- @hash - Identifies the 'hash' commit in an unspecified branch or tag.\n- -~3 - The 3rd predecessor commit from the HEAD of the default branch.\n- name~3 - The 3rd predecessor commit from the HEAD of a branch or tag.\n- @hash~3 - The 3rd predecessor commit of the 'hash' commit.\n- name@hash^2 - The merge parent of the 'hash' commit of a branch or tag.\n- @hash^2 - The merge parent of the 'hash' commit.\n- -*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of the default branch for the given ISO-8601 timestamp.\n- name*2021-04-07T14:42:25.534748Z - The predecessor commit closest to the HEAD of a branch or tag valid for the given ISO-8601 timestamp.\n- name*1685185847230 - The predecessor commit closest to the HEAD of a branch or tag valid for the given timestamp in milliseconds since epoch.\n\nIf both 'name' and 'hash' are given, 'hash' must be reachable from the current HEAD of the branch or tag. If 'name' is omitted, the reference will be of type 'DETACHED' (referencing a specific commit hash without claiming its reachability from any live HEAD). Using references of the last form may have authorization implications when compared to an equivalent reference of the former forms.\n\nAn empty reference parameter is invalid.\n\nThe 'name@hash' form always refers to the exact commit on a specific named reference. This is the most complete form of a reference. Other forms omit some of the details and require those gaps to be filled by the server at runtime. Although these forms may be convenient to a human-being, they may resolve differently at different times depending on the state of the system. Using the full 'name@hash' form is recommended to avoid ambiguity.\n", examples={@ExampleObject(ref="ref"), @ExampleObject(ref="refWithHash"), @ExampleObject(ref="refWithTimestampMillisSinceEpoch", description="The commit 'valid for' the timestamp 1685185847230 in ms since epoch on main"), @ExampleObject(ref="refWithTimestampInstant", description="The commit 'valid for' the given ISO-8601 instant on main"), @ExampleObject(ref="refWithNthPredecessor", description="The 10th commit from HEAD of main"), @ExampleObject(ref="refWithMergeParent", description="References the merge-parent of commit 2e1cfa82b035c26cbbbdae632cea070514eb8b773f616aaeaf668e2f0be8f10d on main"), @ExampleObject(ref="refDefault"), @ExampleObject(ref="refDetached")})
    @PathParam(value="from-ref")
    private @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String fromRef;
    @NotNull
    @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit")
    @Parameter(description="Same reference spec as in the 'from-ref' parameter but identifying the other tree for comparison.")
    @PathParam(value="to-ref")
    private @NotNull @Pattern(regexp="^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String toRef;
    @Parameter(description="Restrict the result to one or more keys.\n\nCan be combined with min/max-key and prefix-key parameters, however both predicates must match. This means that keys specified via this parameter that do not match a given min/max-key or prefix-key will not be returned.\n\nKey components (namespaces) are separated by the dot ('.') character. Dot ('.') characters that are not Nessie namespace separators must be encoded as the 'group separator' ASCII character (0x1D).\n")
    @QueryParam(value="key")
    private List<ContentKey> requestedKeys;
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\n\nUsable variables within the expression are:\n\n- 'key' (string, namespace + table name), 'keyElements' (list of strings), 'namespace' (string), 'namespaceElements' (list of strings) and 'name' (string, the \"simple\" table name)")
    @QueryParam(value="filter")
    private String filter;

    public DiffParams() {
    }

    @Builder.Constructor
    DiffParams(@NotNull String fromRef, @NotNull String toRef, @Nullable Integer maxRecords, @Nullable String pageToken, @Nullable ContentKey minKey, @Nullable ContentKey maxKey, @Nullable ContentKey prefixKey, @Nullable List<ContentKey> requestedKeys, @Nullable String filter) {
        super(maxRecords, pageToken, minKey, maxKey, prefixKey);
        this.fromRef = fromRef;
        this.toRef = toRef;
        this.requestedKeys = requestedKeys;
        this.filter = filter;
    }

    public String getFromRef() {
        return this.fromRef;
    }

    public String getToRef() {
        return this.toRef;
    }

    public List<ContentKey> getRequestedKeys() {
        return this.requestedKeys;
    }

    public String getFilter() {
        return this.filter;
    }

    public static DiffParamsBuilder builder() {
        return new DiffParamsBuilder();
    }

    @Override
    public DiffParams forNextPage(String pageToken) {
        return new DiffParams(this.fromRef, this.toRef, this.maxRecords(), pageToken, this.minKey(), this.maxKey(), this.prefixKey(), this.requestedKeys, this.filter);
    }
}

