/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.api;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.projectnessie.model.Tag;

public interface OnTagBuilder<R extends OnTagBuilder<R>> {
    public R tagName(@NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @NotNull @Pattern(regexp="^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1);

    public R hash(@NotNull @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional timestamp with optional parent must consist of a valid commit hash (consist of the hex representation of 4-32 bytes), optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") @NotNull @Pattern(regexp="^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$", message="Hash with optional timestamp with optional parent must consist of a valid commit hash (consist of the hex representation of 4-32 bytes), optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit") String var1);

    default public R tag(Tag tag) {
        return this.tagName(tag.getName()).hash(tag.getHash());
    }
}

