/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.RefreshTokensRequest;
import org.projectnessie.client.auth.oauth2.TokensRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RefreshTokensRequest", generator="Immutables")
@Immutable
final class ImmutableRefreshTokensRequest
implements RefreshTokensRequest {
    @Nullable
    private final String scope;
    private final String grantType;
    private final String refreshToken;

    private ImmutableRefreshTokensRequest(Builder builder) {
        this.scope = builder.scope;
        this.refreshToken = builder.refreshToken;
        this.grantType = builder.grantType != null ? builder.grantType : Objects.requireNonNull(RefreshTokensRequest.super.getGrantType(), "grantType");
    }

    private ImmutableRefreshTokensRequest(@Nullable String scope, String grantType, String refreshToken) {
        this.scope = scope;
        this.grantType = grantType;
        this.refreshToken = refreshToken;
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="grant_type")
    public String getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="refresh_token")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public final ImmutableRefreshTokensRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableRefreshTokensRequest(value, this.grantType, this.refreshToken);
    }

    public final ImmutableRefreshTokensRequest withGrantType(String value) {
        String newValue = Objects.requireNonNull(value, "grantType");
        if (this.grantType.equals(newValue)) {
            return this;
        }
        return new ImmutableRefreshTokensRequest(this.scope, newValue, this.refreshToken);
    }

    public final ImmutableRefreshTokensRequest withRefreshToken(String value) {
        String newValue = Objects.requireNonNull(value, "refreshToken");
        if (this.refreshToken.equals(newValue)) {
            return this;
        }
        return new ImmutableRefreshTokensRequest(this.scope, this.grantType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefreshTokensRequest && this.equalTo(0, (ImmutableRefreshTokensRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableRefreshTokensRequest another) {
        return Objects.equals(this.scope, another.scope) && this.grantType.equals(another.grantType) && this.refreshToken.equals(another.refreshToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + this.grantType.hashCode();
        h += (h << 5) + this.refreshToken.hashCode();
        return h;
    }

    public String toString() {
        return "RefreshTokensRequest{scope=" + this.scope + ", grantType=" + this.grantType + ", refreshToken=" + this.refreshToken + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRefreshTokensRequest fromJson(Json json) {
        Builder builder = ImmutableRefreshTokensRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.grantType != null) {
            builder.grantType(json.grantType);
        }
        if (json.refreshToken != null) {
            builder.refreshToken(json.refreshToken);
        }
        return builder.build();
    }

    public static ImmutableRefreshTokensRequest copyOf(RefreshTokensRequest instance) {
        if (instance instanceof ImmutableRefreshTokensRequest) {
            return (ImmutableRefreshTokensRequest)instance;
        }
        return ImmutableRefreshTokensRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RefreshTokensRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REFRESH_TOKEN = 1L;
        private long initBits = 1L;
        @Nullable
        private String scope;
        @Nullable
        private String grantType;
        @Nullable
        private String refreshToken;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TokensRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefreshTokensRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String scopeValue;
            TokensRequestBase instance;
            long bits = 0L;
            if (object instanceof TokensRequestBase) {
                instance = (TokensRequestBase)object;
                if ((bits & 2L) == 0L) {
                    this.grantType(instance.getGrantType());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof RefreshTokensRequest) {
                instance = (RefreshTokensRequest)object;
                if ((bits & 2L) == 0L) {
                    this.grantType(instance.getGrantType());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
                this.refreshToken(instance.getRefreshToken());
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="grant_type")
        @CanIgnoreReturnValue
        public final Builder grantType(String grantType) {
            this.grantType = Objects.requireNonNull(grantType, "grantType");
            return this;
        }

        @JsonProperty(value="refresh_token")
        @CanIgnoreReturnValue
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRefreshTokensRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRefreshTokensRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("refreshToken");
            }
            return "Cannot build RefreshTokensRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RefreshTokensRequest", generator="Immutables")
    static final class Json
    implements RefreshTokensRequest {
        @Nullable
        String scope;
        @Nullable
        String grantType;
        @Nullable
        String refreshToken;

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="grant_type")
        public void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @JsonProperty(value="refresh_token")
        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRefreshToken() {
            throw new UnsupportedOperationException();
        }
    }
}

