/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Util;

@JsonSerialize(as=ImmutableNamespace.class)
@JsonDeserialize(as=ImmutableNamespace.class)
@JsonTypeName(value="NAMESPACE")
@Value.Immutable
public abstract class Namespace
extends Content {
    static final String ERROR_MSG_TEMPLATE = "'%s' is not a valid namespace identifier (should not end with '.')";
    public static final Namespace EMPTY = Namespace.builder().elements(Collections.emptyList()).build();

    public static ImmutableNamespace.Builder builder() {
        return ImmutableNamespace.builder();
    }

    @Override
    public Content.Type getType() {
        return Content.Type.NAMESPACE;
    }

    @NotNull
    @JsonIgnore
    @Value.Derived
    public String name() {
        return this.toPathString();
    }

    @JsonIgnore
    @Value.Redacted
    public boolean isEmpty() {
        return this.getElements().isEmpty();
    }

    @NotNull
    public abstract List<String> getElements();

    @JsonIgnore
    @Value.Redacted
    public String[] getElementsArray() {
        return this.getElements().toArray(new String[0]);
    }

    @JsonIgnore
    @Value.Redacted
    public int getElementCount() {
        return this.getElements().size();
    }

    @JsonIgnore
    @Value.Redacted
    public Namespace getParent() {
        List<String> elements = this.getElements();
        if (elements.size() <= 1) {
            throw new IllegalArgumentException("Namespace has no parent");
        }
        return Namespace.of(elements.subList(0, elements.size() - 1));
    }

    @NotNull
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public abstract Map<String, String> getProperties();

    @Override
    public abstract Namespace withId(String var1);

    public static Namespace of(ContentKey contentKey) {
        return Namespace.of(contentKey.getElementsArray());
    }

    public static Namespace of(String ... elements) {
        return Namespace.of(Collections.emptyMap(), elements);
    }

    public static Namespace of(Map<String, String> properties, String ... elements) {
        Objects.requireNonNull(elements, "elements must be non-null");
        if (elements.length == 0 || elements.length == 1 && "".equals(elements[0])) {
            return EMPTY;
        }
        for (String e : elements) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Namespace '%s' must not contain a null element.", Arrays.toString(elements)));
            }
            if (e.isEmpty()) {
                throw new IllegalArgumentException(String.format("Namespace '%s' must not contain an empty element.", Arrays.toString(elements)));
            }
            if (!e.chars().anyMatch(i -> i < 32)) continue;
            throw new IllegalArgumentException(String.format("Namespace '%s' must not contain characters less than 0x%2h.", Arrays.toString(elements), 32));
        }
        if (".".equals(elements[elements.length - 1])) {
            throw new IllegalArgumentException(String.format(ERROR_MSG_TEMPLATE, Arrays.toString(elements)));
        }
        return ImmutableNamespace.builder().elements(Arrays.asList(elements)).properties(properties).build();
    }

    public static Namespace of(List<String> elements) {
        Objects.requireNonNull(elements, "elements must be non-null");
        return Namespace.of(elements.toArray(new String[0]));
    }

    public static Namespace of(List<String> elements, Map<String, String> properties) {
        Objects.requireNonNull(elements, "elements must be non-null");
        return Namespace.of(properties, elements.toArray(new String[0]));
    }

    public static Namespace parse(String identifier) {
        Objects.requireNonNull(identifier, "identifier must be non-null");
        if (identifier.isEmpty()) {
            return EMPTY;
        }
        if (identifier.endsWith(".")) {
            throw new IllegalArgumentException(String.format(ERROR_MSG_TEMPLATE, identifier));
        }
        return Namespace.of(Util.fromPathString(identifier));
    }

    public boolean isSameOrSubElementOf(Namespace parent) {
        Objects.requireNonNull(parent, "namespace must be non-null");
        if (this.getElementCount() < parent.getElementCount()) {
            return false;
        }
        for (int i = 0; i < parent.getElementCount(); ++i) {
            if (this.getElements().get(i).equals(parent.getElements().get(i))) continue;
            return false;
        }
        return true;
    }

    public static Namespace fromPathString(String encoded) {
        return Namespace.parse(encoded);
    }

    public String toPathString() {
        return Util.toPathString(this.getElements());
    }

    public String toString() {
        return this.name();
    }

    public ContentKey toContentKey() {
        return ContentKey.of(this.getElements());
    }
}

