/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Validation {
    public static final String HASH_RAW_REGEX = "[0-9a-fA-F]{8,64}";
    public static final String HASH_REGEX = "^[0-9a-fA-F]{8,64}$";
    public static final String RELATIVE_COMMIT_SPEC_RAW_REGEX = "([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+))";
    public static final String HASH_OR_RELATIVE_COMMIT_SPEC_RAW_REGEX = "([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)";
    public static final String HASH_OR_RELATIVE_COMMIT_SPEC_REGEX = "^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$";
    public static final String REF_NAME_RAW_REGEX = "(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-";
    public static final String REF_NAME_REGEX = "^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$";
    public static final String REF_NAME_OR_HASH_REGEX = "^(?:([0-9a-fA-F]{8,64})|((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-))$";
    public static final String REF_NAME_PATH_REGEX = "^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$";
    public static final String REF_NAME_PATH_ELEMENT_REGEX = "([^/]+|[^@]+(@|%40)[^@/]*)";
    public static final Pattern HASH_PATTERN = Pattern.compile("^[0-9a-fA-F]{8,64}$");
    public static final Pattern REF_NAME_PATTERN = Pattern.compile("^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$");
    public static final Pattern RELATIVE_COMMIT_SPEC_PART_PATTERN = Pattern.compile("([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+))");
    public static final Pattern HASH_OR_RELATIVE_COMMIT_SPEC_PATTERN = Pattern.compile("^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$");
    public static final Pattern REF_NAME_OR_HASH_PATTERN = Pattern.compile("^(?:([0-9a-fA-F]{8,64})|((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-))$");
    public static final Pattern REF_NAME_PATH_PATTERN = Pattern.compile("^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$");
    public static final Pattern REF_NAME_PATH_ELEMENT_PATTERN = Pattern.compile("([^/]+|[^@]+(@|%40)[^@/]*)");
    public static final String HASH_RULE = "consist of the hex representation of 4-32 bytes";
    private static final String REF_RULE = "start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'";
    public static final String HASH_MESSAGE = "Hash must consist of the hex representation of 4-32 bytes";
    public static final String RELATIVE_COMMIT_SPEC_RULE = "numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit";
    public static final String HASH_OR_RELATIVE_COMMIT_SPEC_RULE = "consist of a valid commit hash (consist of the hex representation of 4-32 bytes), optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit";
    public static final String HASH_OR_RELATIVE_COMMIT_SPEC_MESSAGE = "Hash with optional timestamp with optional parent must consist of a valid commit hash (consist of the hex representation of 4-32 bytes), optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit";
    public static final String REF_NAME_PATH_MESSAGE = "Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a commit hash, which must consist of the hex representation of 4-32 bytes, optionally followed by a numeric timestamp (milliseconds since epoch), optionally followed relative pointers: '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit or '*' + a number representing the created timestamp in milliseconds since epoch of a commit";
    public static final String REF_NAME_MESSAGE = "Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'";
    public static final String REF_NAME_OR_HASH_MESSAGE = "Reference must be either a reference name or hash, start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' or consist of the hex representation of 4-32 bytes";
    public static final String FORBIDDEN_REF_NAME_MESSAGE = "Reference name mut not be HEAD, DETACHED or a potential commit ID representation.";
    public static final Set<String> FORBIDDEN_REF_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("HEAD", "DETACHED")));

    private Validation() {
    }

    public static boolean isValidReferenceName(String referenceName) {
        Objects.requireNonNull(referenceName, "referenceName must not be null");
        Matcher matcher = REF_NAME_PATTERN.matcher(referenceName);
        return matcher.matches();
    }

    public static boolean isValidHash(String hash) {
        Objects.requireNonNull(hash, "hash must not be null");
        Matcher matcher = HASH_PATTERN.matcher(hash);
        return matcher.matches();
    }

    public static boolean isValidReferenceNameOrHash(String ref) {
        Objects.requireNonNull(ref, "reference (name or hash) must not be null");
        Matcher matcher = REF_NAME_OR_HASH_PATTERN.matcher(ref);
        return matcher.matches();
    }

    public static String validateReferenceName(String referenceName) throws IllegalArgumentException {
        if (Validation.isValidReferenceName(referenceName)) {
            return referenceName;
        }
        throw new IllegalArgumentException("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' - but was: " + referenceName);
    }

    public static String validateHash(String referenceName) throws IllegalArgumentException {
        if (Validation.isValidHash(referenceName)) {
            return referenceName;
        }
        throw new IllegalArgumentException("Hash must consist of the hex representation of 4-32 bytes - but was: " + referenceName);
    }

    public static String validateReferenceNameOrHash(String ref) throws IllegalArgumentException {
        if (Validation.isValidReferenceNameOrHash(ref)) {
            return ref;
        }
        throw new IllegalArgumentException("Reference must be either a reference name or hash, start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' or consist of the hex representation of 4-32 bytes - but was: " + ref);
    }

    public static boolean isForbiddenReferenceName(String ref) {
        return FORBIDDEN_REF_NAMES.contains(ref.toUpperCase(Locale.ROOT)) || HASH_PATTERN.matcher(ref).matches();
    }

    public static String validateForbiddenReferenceName(String ref) throws IllegalArgumentException {
        if (Validation.isForbiddenReferenceName(ref)) {
            throw new IllegalArgumentException("Reference name mut not be HEAD, DETACHED or a potential commit ID representation. - but was " + ref);
        }
        return ref;
    }
}

