/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.files;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.aws.s3.S3FileIO;
import org.apache.iceberg.io.FileIO;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.files.IcebergFiles;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IcebergFiles", generator="Immutables")
@Immutable
public final class ImmutableIcebergFiles
extends IcebergFiles {
    private final Configuration hadoopConfiguration;
    private final ImmutableMap<String, String> properties;
    private volatile transient long lazyInitBitmap;
    private static final long RESOLVING_FILE_I_O_LAZY_INIT_BIT = 1L;
    private transient FileIO resolvingFileIO;
    private static final long S3_LAZY_INIT_BIT = 2L;
    private transient S3FileIO s3;

    private ImmutableIcebergFiles(Builder builder) {
        this.properties = builder.properties.build();
        this.hadoopConfiguration = builder.hadoopConfiguration != null ? builder.hadoopConfiguration : Objects.requireNonNull(super.hadoopConfiguration(), "hadoopConfiguration");
    }

    private ImmutableIcebergFiles(Configuration hadoopConfiguration, ImmutableMap<String, String> properties) {
        this.hadoopConfiguration = hadoopConfiguration;
        this.properties = properties;
    }

    @Override
    Configuration hadoopConfiguration() {
        return this.hadoopConfiguration;
    }

    ImmutableMap<String, String> properties() {
        return this.properties;
    }

    public final ImmutableIcebergFiles withHadoopConfiguration(Configuration value) {
        if (this.hadoopConfiguration == value) {
            return this;
        }
        Configuration newValue = Objects.requireNonNull(value, "hadoopConfiguration");
        return new ImmutableIcebergFiles(newValue, this.properties);
    }

    public final ImmutableIcebergFiles withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableIcebergFiles(this.hadoopConfiguration, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIcebergFiles && this.equalTo(0, (ImmutableIcebergFiles)another);
    }

    private boolean equalTo(int synthetic, ImmutableIcebergFiles another) {
        return this.hadoopConfiguration.equals(another.hadoopConfiguration) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hadoopConfiguration.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IcebergFiles").omitNullValues().add("hadoopConfiguration", (Object)this.hadoopConfiguration).add("properties", this.properties).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileIO resolvingFileIO() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableIcebergFiles immutableIcebergFiles = this;
            synchronized (immutableIcebergFiles) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.resolvingFileIO = Objects.requireNonNull(super.resolvingFileIO(), "resolvingFileIO");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.resolvingFileIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    S3FileIO s3() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableIcebergFiles immutableIcebergFiles = this;
            synchronized (immutableIcebergFiles) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.s3 = Objects.requireNonNull(super.s3(), "s3");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.s3;
    }

    public static ImmutableIcebergFiles copyOf(IcebergFiles instance) {
        if (instance instanceof ImmutableIcebergFiles) {
            return (ImmutableIcebergFiles)instance;
        }
        return ImmutableIcebergFiles.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IcebergFiles", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements IcebergFiles.Builder {
        @Nullable
        private Configuration hadoopConfiguration;
        private ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IcebergFiles instance) {
            Objects.requireNonNull(instance, "instance");
            this.hadoopConfiguration(instance.hadoopConfiguration());
            this.putAllProperties(instance.properties());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder hadoopConfiguration(Configuration hadoopConfiguration) {
            this.hadoopConfiguration = Objects.requireNonNull(hadoopConfiguration, "hadoopConfiguration");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putProperties(String key, String value) {
            this.properties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
            this.properties.put(entry);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends String> entries) {
            this.properties = ImmutableMap.builder();
            return this.putAllProperties((Map)entries);
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends String> entries) {
            this.properties.putAll(entries);
            return this;
        }

        @Override
        public ImmutableIcebergFiles build() {
            return new ImmutableIcebergFiles(this);
        }
    }
}

