/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.files;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.MustBeClosed;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.ResolvingFileIO;
import org.apache.iceberg.io.SupportsBulkOperations;
import org.apache.iceberg.io.SupportsPrefixOperations;
import org.immutables.value.Value;
import org.projectnessie.gc.files.DeleteResult;
import org.projectnessie.gc.files.DeleteSummary;
import org.projectnessie.gc.files.FileDeleter;
import org.projectnessie.gc.files.FileReference;
import org.projectnessie.gc.files.FilesLister;
import org.projectnessie.gc.files.NessieFileIOException;
import org.projectnessie.gc.iceberg.files.ImmutableIcebergFiles;
import org.projectnessie.storage.uri.StorageUri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class IcebergFiles
implements FilesLister,
FileDeleter,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergFiles.class);
    private volatile boolean hasResolvingFileIO;

    public static Builder builder() {
        return ImmutableIcebergFiles.builder();
    }

    static Stream<String> filesAsStrings(Stream<FileReference> fileObjects) {
        return fileObjects.map(FileReference::absolutePath).map(StorageUri::location);
    }

    @Value.Default
    Configuration hadoopConfiguration() {
        return new Configuration();
    }

    abstract Map<String, String> properties();

    @Value.Lazy
    public FileIO resolvingFileIO() {
        ResolvingFileIO fileIO = new ResolvingFileIO();
        fileIO.initialize(this.properties());
        fileIO.setConf(this.hadoopConfiguration());
        this.hasResolvingFileIO = true;
        LOGGER.debug("Instantiated Iceberg's ResolvingFileIO");
        return fileIO;
    }

    @Override
    public void close() {
        if (this.hasResolvingFileIO) {
            this.resolvingFileIO().close();
        }
    }

    private boolean supportsBulkAndPrefixOperations(StorageUri uri) {
        switch (uri.scheme()) {
            case "s3": 
            case "s3a": 
            case "s3n": 
            case "gs": 
            case "abfs": 
            case "abfss": {
                return true;
            }
        }
        return false;
    }

    @MustBeClosed
    public Stream<FileReference> listRecursively(StorageUri path) throws NessieFileIOException {
        StorageUri basePath = path.withTrailingSeparator();
        if (this.supportsBulkAndPrefixOperations(path)) {
            Iterable fileInfos;
            SupportsPrefixOperations fileIo = (SupportsPrefixOperations)this.resolvingFileIO();
            try {
                fileInfos = fileIo.listPrefix(basePath.toString());
            }
            catch (Exception e) {
                throw new NessieFileIOException("Failed to list prefix of " + path, (Throwable)e);
            }
            return StreamSupport.stream(fileInfos.spliterator(), false).map(f -> FileReference.of((StorageUri)basePath.relativize(f.location()), (StorageUri)basePath, (long)f.createdAtMillis()));
        }
        return this.listHadoop(basePath);
    }

    private Stream<FileReference> listHadoop(final StorageUri basePath) throws NessieFileIOException {
        FileSystem fs;
        final Path p = new Path(basePath.location());
        try {
            fs = p.getFileSystem(this.hadoopConfiguration());
        }
        catch (IOException e) {
            throw new NessieFileIOException("Failed to get Hadoop file system " + basePath, (Throwable)e);
        }
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<FileReference>(Long.MAX_VALUE, 0){
            private RemoteIterator<LocatedFileStatus> iterator;

            @Override
            public boolean tryAdvance(Consumer<? super FileReference> action) {
                try {
                    if (this.iterator == null) {
                        this.iterator = fs.listFiles(p, true);
                    }
                    if (!this.iterator.hasNext()) {
                        return false;
                    }
                    LocatedFileStatus status = (LocatedFileStatus)this.iterator.next();
                    if (status.isFile()) {
                        action.accept((FileReference)FileReference.of((StorageUri)basePath.relativize(StorageUri.of((URI)status.getPath().toUri())), (StorageUri)basePath, (long)status.getModificationTime()));
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to list (via Hadoop) " + basePath, e);
                }
            }
        }, false);
    }

    public DeleteResult delete(FileReference fileReference) {
        try {
            StorageUri absolutePath = fileReference.absolutePath();
            FileIO fileIO = this.resolvingFileIO();
            fileIO.deleteFile(absolutePath.toString());
            return DeleteResult.SUCCESS;
        }
        catch (Exception e) {
            LOGGER.debug("Failed to delete {}", (Object)fileReference, (Object)e);
            return DeleteResult.FAILURE;
        }
    }

    public DeleteSummary deleteMultiple(StorageUri baseUri, Stream<FileReference> fileObjects) {
        Stream<String> filesAsStrings = IcebergFiles.filesAsStrings(fileObjects);
        if (this.supportsBulkAndPrefixOperations(baseUri)) {
            return this.s3DeleteMultiple(filesAsStrings);
        }
        return this.hadoopDeleteMultiple(filesAsStrings);
    }

    private DeleteSummary s3DeleteMultiple(Stream<String> filesAsStrings) {
        SupportsBulkOperations fileIo = (SupportsBulkOperations)this.resolvingFileIO();
        List files = filesAsStrings.collect(Collectors.toList());
        long failed = 0L;
        try {
            fileIo.deleteFiles(files);
        }
        catch (BulkDeletionFailureException e) {
            failed = e.numberFailedObjects();
            LOGGER.debug("Failed to delete {} files (no further details available)", (Object)failed, (Object)e);
        }
        return DeleteSummary.of((long)((long)files.size() - failed), (long)failed);
    }

    private DeleteSummary hadoopDeleteMultiple(Stream<String> filesAsStrings) {
        FileIO fileIo = this.resolvingFileIO();
        return filesAsStrings.map(f -> {
            try {
                fileIo.deleteFile(f);
                return DeleteResult.SUCCESS;
            }
            catch (Exception e) {
                LOGGER.debug("Failed to delete {}", f, (Object)e);
                return DeleteResult.FAILURE;
            }
        }).reduce(DeleteSummary.EMPTY, DeleteSummary::add, DeleteSummary::add);
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder hadoopConfiguration(Configuration var1);

        @CanIgnoreReturnValue
        public Builder putProperties(String var1, String var2);

        @CanIgnoreReturnValue
        public Builder putAllProperties(Map<String, ? extends String> var1);

        @CanIgnoreReturnValue
        public Builder properties(Map<String, ? extends String> var1);

        public IcebergFiles build();
    }
}

