/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.mocks.MockSortOrderField;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MockSortOrderField", generator="Immutables")
@Immutable
public final class ImmutableMockSortOrderField
extends MockSortOrderField {
    private final int sourceId;
    private final String transform;
    private final String direction;
    private final String nullOrder;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long JSON_NODE_LAZY_INIT_BIT = 1L;
    private transient JsonNode jsonNode;

    private ImmutableMockSortOrderField(Builder builder) {
        if (builder.sourceIdIsSet()) {
            this.initShim.sourceId(builder.sourceId);
        }
        if (builder.transform != null) {
            this.initShim.transform(builder.transform);
        }
        if (builder.direction != null) {
            this.initShim.direction(builder.direction);
        }
        if (builder.nullOrder != null) {
            this.initShim.nullOrder(builder.nullOrder);
        }
        this.sourceId = this.initShim.sourceId();
        this.transform = this.initShim.transform();
        this.direction = this.initShim.direction();
        this.nullOrder = this.initShim.nullOrder();
        this.initShim = null;
    }

    private ImmutableMockSortOrderField(int sourceId, String transform, String direction, String nullOrder) {
        this.sourceId = sourceId;
        this.transform = transform;
        this.direction = direction;
        this.nullOrder = nullOrder;
        this.initShim = null;
    }

    @Override
    public int sourceId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceId() : this.sourceId;
    }

    @Override
    public String transform() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transform() : this.transform;
    }

    @Override
    public String direction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.direction() : this.direction;
    }

    @Override
    public String nullOrder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nullOrder() : this.nullOrder;
    }

    public final ImmutableMockSortOrderField withSourceId(int value) {
        if (this.sourceId == value) {
            return this;
        }
        return new ImmutableMockSortOrderField(value, this.transform, this.direction, this.nullOrder);
    }

    public final ImmutableMockSortOrderField withTransform(String value) {
        String newValue = Objects.requireNonNull(value, "transform");
        if (this.transform.equals(newValue)) {
            return this;
        }
        return new ImmutableMockSortOrderField(this.sourceId, newValue, this.direction, this.nullOrder);
    }

    public final ImmutableMockSortOrderField withDirection(String value) {
        String newValue = Objects.requireNonNull(value, "direction");
        if (this.direction.equals(newValue)) {
            return this;
        }
        return new ImmutableMockSortOrderField(this.sourceId, this.transform, newValue, this.nullOrder);
    }

    public final ImmutableMockSortOrderField withNullOrder(String value) {
        String newValue = Objects.requireNonNull(value, "nullOrder");
        if (this.nullOrder.equals(newValue)) {
            return this;
        }
        return new ImmutableMockSortOrderField(this.sourceId, this.transform, this.direction, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockSortOrderField && this.equalTo(0, (ImmutableMockSortOrderField)another);
    }

    private boolean equalTo(int synthetic, ImmutableMockSortOrderField another) {
        return this.sourceId == another.sourceId && this.transform.equals(another.transform) && this.direction.equals(another.direction) && this.nullOrder.equals(another.nullOrder);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sourceId;
        h += (h << 5) + this.transform.hashCode();
        h += (h << 5) + this.direction.hashCode();
        h += (h << 5) + this.nullOrder.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockSortOrderField").omitNullValues().add("sourceId", this.sourceId).add("transform", (Object)this.transform).add("direction", (Object)this.direction).add("nullOrder", (Object)this.nullOrder).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode jsonNode() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableMockSortOrderField immutableMockSortOrderField = this;
            synchronized (immutableMockSortOrderField) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.jsonNode = Objects.requireNonNull(super.jsonNode(), "jsonNode");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.jsonNode;
    }

    public static ImmutableMockSortOrderField copyOf(MockSortOrderField instance) {
        if (instance instanceof ImmutableMockSortOrderField) {
            return (ImmutableMockSortOrderField)instance;
        }
        return ImmutableMockSortOrderField.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockSortOrderField", generator="Immutables")
    private final class InitShim {
        private byte sourceIdBuildStage = 0;
        private int sourceId;
        private byte transformBuildStage = 0;
        private String transform;
        private byte directionBuildStage = 0;
        private String direction;
        private byte nullOrderBuildStage = 0;
        private String nullOrder;

        private InitShim() {
        }

        int sourceId() {
            if (this.sourceIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceIdBuildStage == 0) {
                this.sourceIdBuildStage = (byte)-1;
                this.sourceId = ImmutableMockSortOrderField.super.sourceId();
                this.sourceIdBuildStage = 1;
            }
            return this.sourceId;
        }

        void sourceId(int sourceId) {
            this.sourceId = sourceId;
            this.sourceIdBuildStage = 1;
        }

        String transform() {
            if (this.transformBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transformBuildStage == 0) {
                this.transformBuildStage = (byte)-1;
                this.transform = Objects.requireNonNull(ImmutableMockSortOrderField.super.transform(), "transform");
                this.transformBuildStage = 1;
            }
            return this.transform;
        }

        void transform(String transform) {
            this.transform = transform;
            this.transformBuildStage = 1;
        }

        String direction() {
            if (this.directionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.directionBuildStage == 0) {
                this.directionBuildStage = (byte)-1;
                this.direction = Objects.requireNonNull(ImmutableMockSortOrderField.super.direction(), "direction");
                this.directionBuildStage = 1;
            }
            return this.direction;
        }

        void direction(String direction) {
            this.direction = direction;
            this.directionBuildStage = 1;
        }

        String nullOrder() {
            if (this.nullOrderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nullOrderBuildStage == 0) {
                this.nullOrderBuildStage = (byte)-1;
                this.nullOrder = Objects.requireNonNull(ImmutableMockSortOrderField.super.nullOrder(), "nullOrder");
                this.nullOrderBuildStage = 1;
            }
            return this.nullOrder;
        }

        void nullOrder(String nullOrder) {
            this.nullOrder = nullOrder;
            this.nullOrderBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sourceIdBuildStage == -1) {
                attributes.add("sourceId");
            }
            if (this.transformBuildStage == -1) {
                attributes.add("transform");
            }
            if (this.directionBuildStage == -1) {
                attributes.add("direction");
            }
            if (this.nullOrderBuildStage == -1) {
                attributes.add("nullOrder");
            }
            return "Cannot build MockSortOrderField, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="MockSortOrderField", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SOURCE_ID = 1L;
        private long optBits;
        private int sourceId;
        @Nullable
        private String transform;
        @Nullable
        private String direction;
        @Nullable
        private String nullOrder;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockSortOrderField instance) {
            Objects.requireNonNull(instance, "instance");
            this.sourceId(instance.sourceId());
            this.transform(instance.transform());
            this.direction(instance.direction());
            this.nullOrder(instance.nullOrder());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceId(int sourceId) {
            this.sourceId = sourceId;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transform(String transform) {
            this.transform = Objects.requireNonNull(transform, "transform");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder direction(String direction) {
            this.direction = Objects.requireNonNull(direction, "direction");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nullOrder(String nullOrder) {
            this.nullOrder = Objects.requireNonNull(nullOrder, "nullOrder");
            return this;
        }

        public ImmutableMockSortOrderField build() {
            return new ImmutableMockSortOrderField(this);
        }

        private boolean sourceIdIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

