/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.mocks.MockPartitionSpec;
import org.projectnessie.gc.iceberg.mocks.MockSchema;
import org.projectnessie.gc.iceberg.mocks.MockSnapshot;
import org.projectnessie.gc.iceberg.mocks.MockSortOrder;
import org.projectnessie.gc.iceberg.mocks.MockTableMetadata;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MockTableMetadata", generator="Immutables")
@Immutable
public final class ImmutableMockTableMetadata
extends MockTableMetadata {
    private final ImmutableList<MockSnapshot> snapshots;
    private final ImmutableList<MockSchema> schemas;
    private final ImmutableList<MockSortOrder> sortOrders;
    private final ImmutableList<MockPartitionSpec> partitionSpecs;
    private final long currentSnapshotId;
    private final int defaultSortOrderId;
    private final int lastPartitionId;
    private final int defaultSpecId;
    private final int currentSchemaId;
    private final int lastColumnId;
    private final long lastUpdatedMs;
    private final int lastSequenceNumber;
    private final String location;
    private final String tableUuid;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long JSON_NODE_LAZY_INIT_BIT = 1L;
    private transient JsonNode jsonNode;

    private ImmutableMockTableMetadata(Builder builder) {
        this.snapshots = builder.snapshots.build();
        this.location = builder.location;
        if (builder.schemasIsSet()) {
            this.initShim.schemas((ImmutableList<MockSchema>)builder.schemas.build());
        }
        if (builder.sortOrdersIsSet()) {
            this.initShim.sortOrders((ImmutableList<MockSortOrder>)builder.sortOrders.build());
        }
        if (builder.partitionSpecsIsSet()) {
            this.initShim.partitionSpecs((ImmutableList<MockPartitionSpec>)builder.partitionSpecs.build());
        }
        if (builder.currentSnapshotIdIsSet()) {
            this.initShim.currentSnapshotId(builder.currentSnapshotId);
        }
        if (builder.defaultSortOrderIdIsSet()) {
            this.initShim.defaultSortOrderId(builder.defaultSortOrderId);
        }
        if (builder.lastPartitionIdIsSet()) {
            this.initShim.lastPartitionId(builder.lastPartitionId);
        }
        if (builder.defaultSpecIdIsSet()) {
            this.initShim.defaultSpecId(builder.defaultSpecId);
        }
        if (builder.currentSchemaIdIsSet()) {
            this.initShim.currentSchemaId(builder.currentSchemaId);
        }
        if (builder.lastColumnIdIsSet()) {
            this.initShim.lastColumnId(builder.lastColumnId);
        }
        if (builder.lastUpdatedMsIsSet()) {
            this.initShim.lastUpdatedMs(builder.lastUpdatedMs);
        }
        if (builder.lastSequenceNumberIsSet()) {
            this.initShim.lastSequenceNumber(builder.lastSequenceNumber);
        }
        if (builder.tableUuid != null) {
            this.initShim.tableUuid(builder.tableUuid);
        }
        this.schemas = this.initShim.schemas();
        this.sortOrders = this.initShim.sortOrders();
        this.partitionSpecs = this.initShim.partitionSpecs();
        this.currentSnapshotId = this.initShim.currentSnapshotId();
        this.defaultSortOrderId = this.initShim.defaultSortOrderId();
        this.lastPartitionId = this.initShim.lastPartitionId();
        this.defaultSpecId = this.initShim.defaultSpecId();
        this.currentSchemaId = this.initShim.currentSchemaId();
        this.lastColumnId = this.initShim.lastColumnId();
        this.lastUpdatedMs = this.initShim.lastUpdatedMs();
        this.lastSequenceNumber = this.initShim.lastSequenceNumber();
        this.tableUuid = this.initShim.tableUuid();
        this.initShim = null;
    }

    private ImmutableMockTableMetadata(ImmutableList<MockSnapshot> snapshots, ImmutableList<MockSchema> schemas, ImmutableList<MockSortOrder> sortOrders, ImmutableList<MockPartitionSpec> partitionSpecs, long currentSnapshotId, int defaultSortOrderId, int lastPartitionId, int defaultSpecId, int currentSchemaId, int lastColumnId, long lastUpdatedMs, int lastSequenceNumber, String location, String tableUuid) {
        this.snapshots = snapshots;
        this.schemas = schemas;
        this.sortOrders = sortOrders;
        this.partitionSpecs = partitionSpecs;
        this.currentSnapshotId = currentSnapshotId;
        this.defaultSortOrderId = defaultSortOrderId;
        this.lastPartitionId = lastPartitionId;
        this.defaultSpecId = defaultSpecId;
        this.currentSchemaId = currentSchemaId;
        this.lastColumnId = lastColumnId;
        this.lastUpdatedMs = lastUpdatedMs;
        this.lastSequenceNumber = lastSequenceNumber;
        this.location = location;
        this.tableUuid = tableUuid;
        this.initShim = null;
    }

    public ImmutableList<MockSnapshot> snapshots() {
        return this.snapshots;
    }

    public ImmutableList<MockSchema> schemas() {
        InitShim shim = this.initShim;
        return shim != null ? shim.schemas() : this.schemas;
    }

    public ImmutableList<MockSortOrder> sortOrders() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sortOrders() : this.sortOrders;
    }

    public ImmutableList<MockPartitionSpec> partitionSpecs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.partitionSpecs() : this.partitionSpecs;
    }

    @Override
    public long currentSnapshotId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.currentSnapshotId() : this.currentSnapshotId;
    }

    @Override
    public int defaultSortOrderId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultSortOrderId() : this.defaultSortOrderId;
    }

    @Override
    public int lastPartitionId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lastPartitionId() : this.lastPartitionId;
    }

    @Override
    public int defaultSpecId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultSpecId() : this.defaultSpecId;
    }

    @Override
    public int currentSchemaId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.currentSchemaId() : this.currentSchemaId;
    }

    @Override
    public int lastColumnId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lastColumnId() : this.lastColumnId;
    }

    @Override
    public long lastUpdatedMs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lastUpdatedMs() : this.lastUpdatedMs;
    }

    @Override
    public int lastSequenceNumber() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lastSequenceNumber() : this.lastSequenceNumber;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public String tableUuid() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tableUuid() : this.tableUuid;
    }

    public final ImmutableMockTableMetadata withSnapshots(MockSnapshot ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMockTableMetadata((ImmutableList<MockSnapshot>)newValue, this.schemas, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withSnapshots(Iterable<? extends MockSnapshot> elements) {
        if (this.snapshots == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMockTableMetadata((ImmutableList<MockSnapshot>)newValue, this.schemas, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withSchemas(MockSchema ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMockTableMetadata(this.snapshots, (ImmutableList<MockSchema>)newValue, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withSchemas(Iterable<? extends MockSchema> elements) {
        if (this.schemas == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMockTableMetadata(this.snapshots, (ImmutableList<MockSchema>)newValue, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withSortOrders(MockSortOrder ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, (ImmutableList<MockSortOrder>)newValue, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withSortOrders(Iterable<? extends MockSortOrder> elements) {
        if (this.sortOrders == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, (ImmutableList<MockSortOrder>)newValue, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withPartitionSpecs(MockPartitionSpec ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, (ImmutableList<MockPartitionSpec>)newValue, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withPartitionSpecs(Iterable<? extends MockPartitionSpec> elements) {
        if (this.partitionSpecs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, (ImmutableList<MockPartitionSpec>)newValue, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withCurrentSnapshotId(long value) {
        if (this.currentSnapshotId == value) {
            return this;
        }
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, this.partitionSpecs, value, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withDefaultSortOrderId(int value) {
        if (this.defaultSortOrderId == value) {
            return this;
        }
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, value, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withLastPartitionId(int value) {
        if (this.lastPartitionId == value) {
            return this;
        }
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, value, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withDefaultSpecId(int value) {
        if (this.defaultSpecId == value) {
            return this;
        }
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, value, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withCurrentSchemaId(int value) {
        if (this.currentSchemaId == value) {
            return this;
        }
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, value, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withLastColumnId(int value) {
        if (this.lastColumnId == value) {
            return this;
        }
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, value, this.lastUpdatedMs, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withLastUpdatedMs(long value) {
        if (this.lastUpdatedMs == value) {
            return this;
        }
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, value, this.lastSequenceNumber, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withLastSequenceNumber(int value) {
        if (this.lastSequenceNumber == value) {
            return this;
        }
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, value, this.location, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withLocation(String value) {
        String newValue = Objects.requireNonNull(value, "location");
        if (this.location.equals(newValue)) {
            return this;
        }
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, newValue, this.tableUuid);
    }

    public final ImmutableMockTableMetadata withTableUuid(String value) {
        String newValue = Objects.requireNonNull(value, "tableUuid");
        if (this.tableUuid.equals(newValue)) {
            return this;
        }
        return new ImmutableMockTableMetadata(this.snapshots, this.schemas, this.sortOrders, this.partitionSpecs, this.currentSnapshotId, this.defaultSortOrderId, this.lastPartitionId, this.defaultSpecId, this.currentSchemaId, this.lastColumnId, this.lastUpdatedMs, this.lastSequenceNumber, this.location, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockTableMetadata && this.equalTo(0, (ImmutableMockTableMetadata)another);
    }

    private boolean equalTo(int synthetic, ImmutableMockTableMetadata another) {
        return this.snapshots.equals(another.snapshots) && this.schemas.equals(another.schemas) && this.sortOrders.equals(another.sortOrders) && this.partitionSpecs.equals(another.partitionSpecs) && this.currentSnapshotId == another.currentSnapshotId && this.defaultSortOrderId == another.defaultSortOrderId && this.lastPartitionId == another.lastPartitionId && this.defaultSpecId == another.defaultSpecId && this.currentSchemaId == another.currentSchemaId && this.lastColumnId == another.lastColumnId && this.lastUpdatedMs == another.lastUpdatedMs && this.lastSequenceNumber == another.lastSequenceNumber && this.location.equals(another.location) && this.tableUuid.equals(another.tableUuid);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.snapshots.hashCode();
        h += (h << 5) + this.schemas.hashCode();
        h += (h << 5) + this.sortOrders.hashCode();
        h += (h << 5) + this.partitionSpecs.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.currentSnapshotId);
        h += (h << 5) + this.defaultSortOrderId;
        h += (h << 5) + this.lastPartitionId;
        h += (h << 5) + this.defaultSpecId;
        h += (h << 5) + this.currentSchemaId;
        h += (h << 5) + this.lastColumnId;
        h += (h << 5) + Longs.hashCode((long)this.lastUpdatedMs);
        h += (h << 5) + this.lastSequenceNumber;
        h += (h << 5) + this.location.hashCode();
        h += (h << 5) + this.tableUuid.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockTableMetadata").omitNullValues().add("snapshots", this.snapshots).add("schemas", this.schemas).add("sortOrders", this.sortOrders).add("partitionSpecs", this.partitionSpecs).add("currentSnapshotId", this.currentSnapshotId).add("defaultSortOrderId", this.defaultSortOrderId).add("lastPartitionId", this.lastPartitionId).add("defaultSpecId", this.defaultSpecId).add("currentSchemaId", this.currentSchemaId).add("lastColumnId", this.lastColumnId).add("lastUpdatedMs", this.lastUpdatedMs).add("lastSequenceNumber", this.lastSequenceNumber).add("location", (Object)this.location).add("tableUuid", (Object)this.tableUuid).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode jsonNode() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableMockTableMetadata immutableMockTableMetadata = this;
            synchronized (immutableMockTableMetadata) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.jsonNode = Objects.requireNonNull(super.jsonNode(), "jsonNode");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.jsonNode;
    }

    public static ImmutableMockTableMetadata copyOf(MockTableMetadata instance) {
        if (instance instanceof ImmutableMockTableMetadata) {
            return (ImmutableMockTableMetadata)instance;
        }
        return ImmutableMockTableMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockTableMetadata", generator="Immutables")
    private final class InitShim {
        private byte schemasBuildStage = 0;
        private ImmutableList<MockSchema> schemas;
        private byte sortOrdersBuildStage = 0;
        private ImmutableList<MockSortOrder> sortOrders;
        private byte partitionSpecsBuildStage = 0;
        private ImmutableList<MockPartitionSpec> partitionSpecs;
        private byte currentSnapshotIdBuildStage = 0;
        private long currentSnapshotId;
        private byte defaultSortOrderIdBuildStage = 0;
        private int defaultSortOrderId;
        private byte lastPartitionIdBuildStage = 0;
        private int lastPartitionId;
        private byte defaultSpecIdBuildStage = 0;
        private int defaultSpecId;
        private byte currentSchemaIdBuildStage = 0;
        private int currentSchemaId;
        private byte lastColumnIdBuildStage = 0;
        private int lastColumnId;
        private byte lastUpdatedMsBuildStage = 0;
        private long lastUpdatedMs;
        private byte lastSequenceNumberBuildStage = 0;
        private int lastSequenceNumber;
        private byte tableUuidBuildStage = 0;
        private String tableUuid;

        private InitShim() {
        }

        ImmutableList<MockSchema> schemas() {
            if (this.schemasBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemasBuildStage == 0) {
                this.schemasBuildStage = (byte)-1;
                this.schemas = ImmutableList.copyOf((Collection)ImmutableMockTableMetadata.super.schemas());
                this.schemasBuildStage = 1;
            }
            return this.schemas;
        }

        void schemas(ImmutableList<MockSchema> schemas) {
            this.schemas = schemas;
            this.schemasBuildStage = 1;
        }

        ImmutableList<MockSortOrder> sortOrders() {
            if (this.sortOrdersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sortOrdersBuildStage == 0) {
                this.sortOrdersBuildStage = (byte)-1;
                this.sortOrders = ImmutableList.copyOf((Collection)ImmutableMockTableMetadata.super.sortOrders());
                this.sortOrdersBuildStage = 1;
            }
            return this.sortOrders;
        }

        void sortOrders(ImmutableList<MockSortOrder> sortOrders) {
            this.sortOrders = sortOrders;
            this.sortOrdersBuildStage = 1;
        }

        ImmutableList<MockPartitionSpec> partitionSpecs() {
            if (this.partitionSpecsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partitionSpecsBuildStage == 0) {
                this.partitionSpecsBuildStage = (byte)-1;
                this.partitionSpecs = ImmutableList.copyOf((Collection)ImmutableMockTableMetadata.super.partitionSpecs());
                this.partitionSpecsBuildStage = 1;
            }
            return this.partitionSpecs;
        }

        void partitionSpecs(ImmutableList<MockPartitionSpec> partitionSpecs) {
            this.partitionSpecs = partitionSpecs;
            this.partitionSpecsBuildStage = 1;
        }

        long currentSnapshotId() {
            if (this.currentSnapshotIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.currentSnapshotIdBuildStage == 0) {
                this.currentSnapshotIdBuildStage = (byte)-1;
                this.currentSnapshotId = ImmutableMockTableMetadata.super.currentSnapshotId();
                this.currentSnapshotIdBuildStage = 1;
            }
            return this.currentSnapshotId;
        }

        void currentSnapshotId(long currentSnapshotId) {
            this.currentSnapshotId = currentSnapshotId;
            this.currentSnapshotIdBuildStage = 1;
        }

        int defaultSortOrderId() {
            if (this.defaultSortOrderIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultSortOrderIdBuildStage == 0) {
                this.defaultSortOrderIdBuildStage = (byte)-1;
                this.defaultSortOrderId = ImmutableMockTableMetadata.super.defaultSortOrderId();
                this.defaultSortOrderIdBuildStage = 1;
            }
            return this.defaultSortOrderId;
        }

        void defaultSortOrderId(int defaultSortOrderId) {
            this.defaultSortOrderId = defaultSortOrderId;
            this.defaultSortOrderIdBuildStage = 1;
        }

        int lastPartitionId() {
            if (this.lastPartitionIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastPartitionIdBuildStage == 0) {
                this.lastPartitionIdBuildStage = (byte)-1;
                this.lastPartitionId = ImmutableMockTableMetadata.super.lastPartitionId();
                this.lastPartitionIdBuildStage = 1;
            }
            return this.lastPartitionId;
        }

        void lastPartitionId(int lastPartitionId) {
            this.lastPartitionId = lastPartitionId;
            this.lastPartitionIdBuildStage = 1;
        }

        int defaultSpecId() {
            if (this.defaultSpecIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultSpecIdBuildStage == 0) {
                this.defaultSpecIdBuildStage = (byte)-1;
                this.defaultSpecId = ImmutableMockTableMetadata.super.defaultSpecId();
                this.defaultSpecIdBuildStage = 1;
            }
            return this.defaultSpecId;
        }

        void defaultSpecId(int defaultSpecId) {
            this.defaultSpecId = defaultSpecId;
            this.defaultSpecIdBuildStage = 1;
        }

        int currentSchemaId() {
            if (this.currentSchemaIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.currentSchemaIdBuildStage == 0) {
                this.currentSchemaIdBuildStage = (byte)-1;
                this.currentSchemaId = ImmutableMockTableMetadata.super.currentSchemaId();
                this.currentSchemaIdBuildStage = 1;
            }
            return this.currentSchemaId;
        }

        void currentSchemaId(int currentSchemaId) {
            this.currentSchemaId = currentSchemaId;
            this.currentSchemaIdBuildStage = 1;
        }

        int lastColumnId() {
            if (this.lastColumnIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastColumnIdBuildStage == 0) {
                this.lastColumnIdBuildStage = (byte)-1;
                this.lastColumnId = ImmutableMockTableMetadata.super.lastColumnId();
                this.lastColumnIdBuildStage = 1;
            }
            return this.lastColumnId;
        }

        void lastColumnId(int lastColumnId) {
            this.lastColumnId = lastColumnId;
            this.lastColumnIdBuildStage = 1;
        }

        long lastUpdatedMs() {
            if (this.lastUpdatedMsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastUpdatedMsBuildStage == 0) {
                this.lastUpdatedMsBuildStage = (byte)-1;
                this.lastUpdatedMs = ImmutableMockTableMetadata.super.lastUpdatedMs();
                this.lastUpdatedMsBuildStage = 1;
            }
            return this.lastUpdatedMs;
        }

        void lastUpdatedMs(long lastUpdatedMs) {
            this.lastUpdatedMs = lastUpdatedMs;
            this.lastUpdatedMsBuildStage = 1;
        }

        int lastSequenceNumber() {
            if (this.lastSequenceNumberBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastSequenceNumberBuildStage == 0) {
                this.lastSequenceNumberBuildStage = (byte)-1;
                this.lastSequenceNumber = ImmutableMockTableMetadata.super.lastSequenceNumber();
                this.lastSequenceNumberBuildStage = 1;
            }
            return this.lastSequenceNumber;
        }

        void lastSequenceNumber(int lastSequenceNumber) {
            this.lastSequenceNumber = lastSequenceNumber;
            this.lastSequenceNumberBuildStage = 1;
        }

        String tableUuid() {
            if (this.tableUuidBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tableUuidBuildStage == 0) {
                this.tableUuidBuildStage = (byte)-1;
                this.tableUuid = Objects.requireNonNull(ImmutableMockTableMetadata.super.tableUuid(), "tableUuid");
                this.tableUuidBuildStage = 1;
            }
            return this.tableUuid;
        }

        void tableUuid(String tableUuid) {
            this.tableUuid = tableUuid;
            this.tableUuidBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.schemasBuildStage == -1) {
                attributes.add("schemas");
            }
            if (this.sortOrdersBuildStage == -1) {
                attributes.add("sortOrders");
            }
            if (this.partitionSpecsBuildStage == -1) {
                attributes.add("partitionSpecs");
            }
            if (this.currentSnapshotIdBuildStage == -1) {
                attributes.add("currentSnapshotId");
            }
            if (this.defaultSortOrderIdBuildStage == -1) {
                attributes.add("defaultSortOrderId");
            }
            if (this.lastPartitionIdBuildStage == -1) {
                attributes.add("lastPartitionId");
            }
            if (this.defaultSpecIdBuildStage == -1) {
                attributes.add("defaultSpecId");
            }
            if (this.currentSchemaIdBuildStage == -1) {
                attributes.add("currentSchemaId");
            }
            if (this.lastColumnIdBuildStage == -1) {
                attributes.add("lastColumnId");
            }
            if (this.lastUpdatedMsBuildStage == -1) {
                attributes.add("lastUpdatedMs");
            }
            if (this.lastSequenceNumberBuildStage == -1) {
                attributes.add("lastSequenceNumber");
            }
            if (this.tableUuidBuildStage == -1) {
                attributes.add("tableUuid");
            }
            return "Cannot build MockTableMetadata, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="MockTableMetadata", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOCATION = 1L;
        private static final long OPT_BIT_SCHEMAS = 1L;
        private static final long OPT_BIT_SORT_ORDERS = 2L;
        private static final long OPT_BIT_PARTITION_SPECS = 4L;
        private static final long OPT_BIT_CURRENT_SNAPSHOT_ID = 8L;
        private static final long OPT_BIT_DEFAULT_SORT_ORDER_ID = 16L;
        private static final long OPT_BIT_LAST_PARTITION_ID = 32L;
        private static final long OPT_BIT_DEFAULT_SPEC_ID = 64L;
        private static final long OPT_BIT_CURRENT_SCHEMA_ID = 128L;
        private static final long OPT_BIT_LAST_COLUMN_ID = 256L;
        private static final long OPT_BIT_LAST_UPDATED_MS = 512L;
        private static final long OPT_BIT_LAST_SEQUENCE_NUMBER = 1024L;
        private long initBits = 1L;
        private long optBits;
        private ImmutableList.Builder<MockSnapshot> snapshots = ImmutableList.builder();
        private ImmutableList.Builder<MockSchema> schemas = ImmutableList.builder();
        private ImmutableList.Builder<MockSortOrder> sortOrders = ImmutableList.builder();
        private ImmutableList.Builder<MockPartitionSpec> partitionSpecs = ImmutableList.builder();
        private long currentSnapshotId;
        private int defaultSortOrderId;
        private int lastPartitionId;
        private int defaultSpecId;
        private int currentSchemaId;
        private int lastColumnId;
        private long lastUpdatedMs;
        private int lastSequenceNumber;
        @Nullable
        private String location;
        @Nullable
        private String tableUuid;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockTableMetadata instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllSnapshots(instance.snapshots());
            this.addAllSchemas(instance.schemas());
            this.addAllSortOrders(instance.sortOrders());
            this.addAllPartitionSpecs(instance.partitionSpecs());
            this.currentSnapshotId(instance.currentSnapshotId());
            this.defaultSortOrderId(instance.defaultSortOrderId());
            this.lastPartitionId(instance.lastPartitionId());
            this.defaultSpecId(instance.defaultSpecId());
            this.currentSchemaId(instance.currentSchemaId());
            this.lastColumnId(instance.lastColumnId());
            this.lastUpdatedMs(instance.lastUpdatedMs());
            this.lastSequenceNumber(instance.lastSequenceNumber());
            this.location(instance.location());
            this.tableUuid(instance.tableUuid());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSnapshots(MockSnapshot element) {
            this.snapshots.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSnapshots(MockSnapshot ... elements) {
            this.snapshots.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder snapshots(Iterable<? extends MockSnapshot> elements) {
            this.snapshots = ImmutableList.builder();
            return this.addAllSnapshots(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSnapshots(Iterable<? extends MockSnapshot> elements) {
            this.snapshots.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemas(MockSchema element) {
            this.schemas.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemas(MockSchema ... elements) {
            this.schemas.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemas(Iterable<? extends MockSchema> elements) {
            this.schemas = ImmutableList.builder();
            return this.addAllSchemas(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSchemas(Iterable<? extends MockSchema> elements) {
            this.schemas.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSortOrders(MockSortOrder element) {
            this.sortOrders.add((Object)element);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSortOrders(MockSortOrder ... elements) {
            this.sortOrders.add((Object[])elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortOrders(Iterable<? extends MockSortOrder> elements) {
            this.sortOrders = ImmutableList.builder();
            return this.addAllSortOrders(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSortOrders(Iterable<? extends MockSortOrder> elements) {
            this.sortOrders.addAll(elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPartitionSpecs(MockPartitionSpec element) {
            this.partitionSpecs.add((Object)element);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPartitionSpecs(MockPartitionSpec ... elements) {
            this.partitionSpecs.add((Object[])elements);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partitionSpecs(Iterable<? extends MockPartitionSpec> elements) {
            this.partitionSpecs = ImmutableList.builder();
            return this.addAllPartitionSpecs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPartitionSpecs(Iterable<? extends MockPartitionSpec> elements) {
            this.partitionSpecs.addAll(elements);
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder currentSnapshotId(long currentSnapshotId) {
            this.currentSnapshotId = currentSnapshotId;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultSortOrderId(int defaultSortOrderId) {
            this.defaultSortOrderId = defaultSortOrderId;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastPartitionId(int lastPartitionId) {
            this.lastPartitionId = lastPartitionId;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultSpecId(int defaultSpecId) {
            this.defaultSpecId = defaultSpecId;
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder currentSchemaId(int currentSchemaId) {
            this.currentSchemaId = currentSchemaId;
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastColumnId(int lastColumnId) {
            this.lastColumnId = lastColumnId;
            this.optBits |= 0x100L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastUpdatedMs(long lastUpdatedMs) {
            this.lastUpdatedMs = lastUpdatedMs;
            this.optBits |= 0x200L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastSequenceNumber(int lastSequenceNumber) {
            this.lastSequenceNumber = lastSequenceNumber;
            this.optBits |= 0x400L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder location(String location) {
            this.location = Objects.requireNonNull(location, "location");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tableUuid(String tableUuid) {
            this.tableUuid = Objects.requireNonNull(tableUuid, "tableUuid");
            return this;
        }

        public ImmutableMockTableMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMockTableMetadata(this);
        }

        private boolean schemasIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sortOrdersIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean partitionSpecsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean currentSnapshotIdIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean defaultSortOrderIdIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean lastPartitionIdIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean defaultSpecIdIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean currentSchemaIdIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean lastColumnIdIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean lastUpdatedMsIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean lastSequenceNumberIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("location");
            }
            return "Cannot build MockTableMetadata, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

