/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.iceberg.ManifestContent;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.mocks.MockManifestFile;

@Generated(from="MockManifestFile", generator="Immutables")
public final class ImmutableMockManifestFile
extends MockManifestFile {
    private final String path;
    private final int partitionSpecId;
    private final ManifestContent content;
    @Nullable
    private final ByteBuffer keyMetadata;
    private final long length;
    private final long sequenceNumber;
    private final long minSequenceNumber;
    @Nullable
    private final Long snapshotId;
    @Nullable
    private final Integer addedFilesCount;
    @Nullable
    private final Long addedRowsCount;
    @Nullable
    private final Integer existingFilesCount;
    @Nullable
    private final Long existingRowsCount;
    @Nullable
    private final Integer deletedFilesCount;
    @Nullable
    private final Long deletedRowsCount;
    private final int numEntries;
    private final String baseDataFilePath;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMockManifestFile(Builder builder) {
        this.path = builder.path;
        this.baseDataFilePath = builder.baseDataFilePath;
        if (builder.partitionSpecIdIsSet()) {
            this.initShim.partitionSpecId(builder.partitionSpecId);
        }
        if (builder.content != null) {
            this.initShim.content(builder.content);
        }
        if (builder.keyMetadataIsSet()) {
            this.initShim.keyMetadata(builder.keyMetadata);
        }
        if (builder.lengthIsSet()) {
            this.initShim.length(builder.length);
        }
        if (builder.sequenceNumberIsSet()) {
            this.initShim.sequenceNumber(builder.sequenceNumber);
        }
        if (builder.minSequenceNumberIsSet()) {
            this.initShim.minSequenceNumber(builder.minSequenceNumber);
        }
        if (builder.snapshotIdIsSet()) {
            this.initShim.snapshotId(builder.snapshotId);
        }
        if (builder.addedFilesCountIsSet()) {
            this.initShim.addedFilesCount(builder.addedFilesCount);
        }
        if (builder.addedRowsCountIsSet()) {
            this.initShim.addedRowsCount(builder.addedRowsCount);
        }
        if (builder.existingFilesCountIsSet()) {
            this.initShim.existingFilesCount(builder.existingFilesCount);
        }
        if (builder.existingRowsCountIsSet()) {
            this.initShim.existingRowsCount(builder.existingRowsCount);
        }
        if (builder.deletedFilesCountIsSet()) {
            this.initShim.deletedFilesCount(builder.deletedFilesCount);
        }
        if (builder.deletedRowsCountIsSet()) {
            this.initShim.deletedRowsCount(builder.deletedRowsCount);
        }
        if (builder.numEntriesIsSet()) {
            this.initShim.numEntries(builder.numEntries);
        }
        this.partitionSpecId = this.initShim.partitionSpecId();
        this.content = this.initShim.content();
        this.keyMetadata = this.initShim.keyMetadata();
        this.length = this.initShim.length();
        this.sequenceNumber = this.initShim.sequenceNumber();
        this.minSequenceNumber = this.initShim.minSequenceNumber();
        this.snapshotId = this.initShim.snapshotId();
        this.addedFilesCount = this.initShim.addedFilesCount();
        this.addedRowsCount = this.initShim.addedRowsCount();
        this.existingFilesCount = this.initShim.existingFilesCount();
        this.existingRowsCount = this.initShim.existingRowsCount();
        this.deletedFilesCount = this.initShim.deletedFilesCount();
        this.deletedRowsCount = this.initShim.deletedRowsCount();
        this.numEntries = this.initShim.numEntries();
        this.initShim = null;
    }

    private ImmutableMockManifestFile(String path, int partitionSpecId, ManifestContent content, @Nullable ByteBuffer keyMetadata, long length, long sequenceNumber, long minSequenceNumber, @Nullable Long snapshotId, @Nullable Integer addedFilesCount, @Nullable Long addedRowsCount, @Nullable Integer existingFilesCount, @Nullable Long existingRowsCount, @Nullable Integer deletedFilesCount, @Nullable Long deletedRowsCount, int numEntries, String baseDataFilePath) {
        this.path = path;
        this.partitionSpecId = partitionSpecId;
        this.content = content;
        this.keyMetadata = keyMetadata;
        this.length = length;
        this.sequenceNumber = sequenceNumber;
        this.minSequenceNumber = minSequenceNumber;
        this.snapshotId = snapshotId;
        this.addedFilesCount = addedFilesCount;
        this.addedRowsCount = addedRowsCount;
        this.existingFilesCount = existingFilesCount;
        this.existingRowsCount = existingRowsCount;
        this.deletedFilesCount = deletedFilesCount;
        this.deletedRowsCount = deletedRowsCount;
        this.numEntries = numEntries;
        this.baseDataFilePath = baseDataFilePath;
        this.initShim = null;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public int partitionSpecId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.partitionSpecId() : this.partitionSpecId;
    }

    @Override
    public ManifestContent content() {
        InitShim shim = this.initShim;
        return shim != null ? shim.content() : this.content;
    }

    @Override
    @Nullable
    public ByteBuffer keyMetadata() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keyMetadata() : this.keyMetadata;
    }

    @Override
    public long length() {
        InitShim shim = this.initShim;
        return shim != null ? shim.length() : this.length;
    }

    @Override
    public long sequenceNumber() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sequenceNumber() : this.sequenceNumber;
    }

    @Override
    public long minSequenceNumber() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minSequenceNumber() : this.minSequenceNumber;
    }

    @Override
    @Nullable
    public Long snapshotId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.snapshotId() : this.snapshotId;
    }

    @Override
    @Nullable
    public Integer addedFilesCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.addedFilesCount() : this.addedFilesCount;
    }

    @Override
    @Nullable
    public Long addedRowsCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.addedRowsCount() : this.addedRowsCount;
    }

    @Override
    @Nullable
    public Integer existingFilesCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.existingFilesCount() : this.existingFilesCount;
    }

    @Override
    @Nullable
    public Long existingRowsCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.existingRowsCount() : this.existingRowsCount;
    }

    @Override
    @Nullable
    public Integer deletedFilesCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deletedFilesCount() : this.deletedFilesCount;
    }

    @Override
    @Nullable
    public Long deletedRowsCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deletedRowsCount() : this.deletedRowsCount;
    }

    @Override
    public int numEntries() {
        InitShim shim = this.initShim;
        return shim != null ? shim.numEntries() : this.numEntries;
    }

    @Override
    public String baseDataFilePath() {
        return this.baseDataFilePath;
    }

    public final ImmutableMockManifestFile withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableMockManifestFile(newValue, this.partitionSpecId, this.content, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withPartitionSpecId(int value) {
        if (this.partitionSpecId == value) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, value, this.content, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withContent(ManifestContent value) {
        ManifestContent newValue = Objects.requireNonNull(value, "content");
        if (this.content == newValue) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, newValue, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withKeyMetadata(@Nullable ByteBuffer value) {
        if (this.keyMetadata == value) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, value, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withLength(long value) {
        if (this.length == value) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, value, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withSequenceNumber(long value) {
        if (this.sequenceNumber == value) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, this.length, value, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withMinSequenceNumber(long value) {
        if (this.minSequenceNumber == value) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, this.length, this.sequenceNumber, value, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withSnapshotId(@Nullable Long value) {
        if (Objects.equals(this.snapshotId, value)) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, value, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withAddedFilesCount(@Nullable Integer value) {
        if (Objects.equals(this.addedFilesCount, value)) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, value, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withAddedRowsCount(@Nullable Long value) {
        if (Objects.equals(this.addedRowsCount, value)) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, value, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withExistingFilesCount(@Nullable Integer value) {
        if (Objects.equals(this.existingFilesCount, value)) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, value, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withExistingRowsCount(@Nullable Long value) {
        if (Objects.equals(this.existingRowsCount, value)) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, value, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withDeletedFilesCount(@Nullable Integer value) {
        if (Objects.equals(this.deletedFilesCount, value)) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, value, this.deletedRowsCount, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withDeletedRowsCount(@Nullable Long value) {
        if (Objects.equals(this.deletedRowsCount, value)) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, value, this.numEntries, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withNumEntries(int value) {
        if (this.numEntries == value) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, value, this.baseDataFilePath);
    }

    public final ImmutableMockManifestFile withBaseDataFilePath(String value) {
        String newValue = Objects.requireNonNull(value, "baseDataFilePath");
        if (this.baseDataFilePath.equals(newValue)) {
            return this;
        }
        return new ImmutableMockManifestFile(this.path, this.partitionSpecId, this.content, this.keyMetadata, this.length, this.sequenceNumber, this.minSequenceNumber, this.snapshotId, this.addedFilesCount, this.addedRowsCount, this.existingFilesCount, this.existingRowsCount, this.deletedFilesCount, this.deletedRowsCount, this.numEntries, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockManifestFile && this.equalTo(0, (ImmutableMockManifestFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableMockManifestFile another) {
        return this.path.equals(another.path) && this.partitionSpecId == another.partitionSpecId && this.content.equals((Object)another.content) && Objects.equals(this.keyMetadata, another.keyMetadata) && this.length == another.length && this.sequenceNumber == another.sequenceNumber && this.minSequenceNumber == another.minSequenceNumber && Objects.equals(this.snapshotId, another.snapshotId) && Objects.equals(this.addedFilesCount, another.addedFilesCount) && Objects.equals(this.addedRowsCount, another.addedRowsCount) && Objects.equals(this.existingFilesCount, another.existingFilesCount) && Objects.equals(this.existingRowsCount, another.existingRowsCount) && Objects.equals(this.deletedFilesCount, another.deletedFilesCount) && Objects.equals(this.deletedRowsCount, another.deletedRowsCount) && this.numEntries == another.numEntries && this.baseDataFilePath.equals(another.baseDataFilePath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.partitionSpecId;
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + Objects.hashCode(this.keyMetadata);
        h += (h << 5) + Longs.hashCode((long)this.length);
        h += (h << 5) + Longs.hashCode((long)this.sequenceNumber);
        h += (h << 5) + Longs.hashCode((long)this.minSequenceNumber);
        h += (h << 5) + Objects.hashCode(this.snapshotId);
        h += (h << 5) + Objects.hashCode(this.addedFilesCount);
        h += (h << 5) + Objects.hashCode(this.addedRowsCount);
        h += (h << 5) + Objects.hashCode(this.existingFilesCount);
        h += (h << 5) + Objects.hashCode(this.existingRowsCount);
        h += (h << 5) + Objects.hashCode(this.deletedFilesCount);
        h += (h << 5) + Objects.hashCode(this.deletedRowsCount);
        h += (h << 5) + this.numEntries;
        h += (h << 5) + this.baseDataFilePath.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockManifestFile").omitNullValues().add("path", (Object)this.path).add("partitionSpecId", this.partitionSpecId).add("content", (Object)this.content).add("keyMetadata", (Object)this.keyMetadata).add("length", this.length).add("sequenceNumber", this.sequenceNumber).add("minSequenceNumber", this.minSequenceNumber).add("snapshotId", (Object)this.snapshotId).add("addedFilesCount", (Object)this.addedFilesCount).add("addedRowsCount", (Object)this.addedRowsCount).add("existingFilesCount", (Object)this.existingFilesCount).add("existingRowsCount", (Object)this.existingRowsCount).add("deletedFilesCount", (Object)this.deletedFilesCount).add("deletedRowsCount", (Object)this.deletedRowsCount).add("numEntries", this.numEntries).add("baseDataFilePath", (Object)this.baseDataFilePath).toString();
    }

    public static ImmutableMockManifestFile copyOf(MockManifestFile instance) {
        if (instance instanceof ImmutableMockManifestFile) {
            return (ImmutableMockManifestFile)instance;
        }
        return ImmutableMockManifestFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockManifestFile", generator="Immutables")
    private final class InitShim {
        private byte partitionSpecIdBuildStage = 0;
        private int partitionSpecId;
        private byte contentBuildStage = 0;
        private ManifestContent content;
        private byte keyMetadataBuildStage = 0;
        private ByteBuffer keyMetadata;
        private byte lengthBuildStage = 0;
        private long length;
        private byte sequenceNumberBuildStage = 0;
        private long sequenceNumber;
        private byte minSequenceNumberBuildStage = 0;
        private long minSequenceNumber;
        private byte snapshotIdBuildStage = 0;
        private Long snapshotId;
        private byte addedFilesCountBuildStage = 0;
        private Integer addedFilesCount;
        private byte addedRowsCountBuildStage = 0;
        private Long addedRowsCount;
        private byte existingFilesCountBuildStage = 0;
        private Integer existingFilesCount;
        private byte existingRowsCountBuildStage = 0;
        private Long existingRowsCount;
        private byte deletedFilesCountBuildStage = 0;
        private Integer deletedFilesCount;
        private byte deletedRowsCountBuildStage = 0;
        private Long deletedRowsCount;
        private byte numEntriesBuildStage = 0;
        private int numEntries;

        private InitShim() {
        }

        int partitionSpecId() {
            if (this.partitionSpecIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partitionSpecIdBuildStage == 0) {
                this.partitionSpecIdBuildStage = (byte)-1;
                this.partitionSpecId = ImmutableMockManifestFile.super.partitionSpecId();
                this.partitionSpecIdBuildStage = 1;
            }
            return this.partitionSpecId;
        }

        void partitionSpecId(int partitionSpecId) {
            this.partitionSpecId = partitionSpecId;
            this.partitionSpecIdBuildStage = 1;
        }

        ManifestContent content() {
            if (this.contentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contentBuildStage == 0) {
                this.contentBuildStage = (byte)-1;
                this.content = Objects.requireNonNull(ImmutableMockManifestFile.super.content(), "content");
                this.contentBuildStage = 1;
            }
            return this.content;
        }

        void content(ManifestContent content) {
            this.content = content;
            this.contentBuildStage = 1;
        }

        ByteBuffer keyMetadata() {
            if (this.keyMetadataBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyMetadataBuildStage == 0) {
                this.keyMetadataBuildStage = (byte)-1;
                this.keyMetadata = ImmutableMockManifestFile.super.keyMetadata();
                this.keyMetadataBuildStage = 1;
            }
            return this.keyMetadata;
        }

        void keyMetadata(ByteBuffer keyMetadata) {
            this.keyMetadata = keyMetadata;
            this.keyMetadataBuildStage = 1;
        }

        long length() {
            if (this.lengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lengthBuildStage == 0) {
                this.lengthBuildStage = (byte)-1;
                this.length = ImmutableMockManifestFile.super.length();
                this.lengthBuildStage = 1;
            }
            return this.length;
        }

        void length(long length) {
            this.length = length;
            this.lengthBuildStage = 1;
        }

        long sequenceNumber() {
            if (this.sequenceNumberBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sequenceNumberBuildStage == 0) {
                this.sequenceNumberBuildStage = (byte)-1;
                this.sequenceNumber = ImmutableMockManifestFile.super.sequenceNumber();
                this.sequenceNumberBuildStage = 1;
            }
            return this.sequenceNumber;
        }

        void sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            this.sequenceNumberBuildStage = 1;
        }

        long minSequenceNumber() {
            if (this.minSequenceNumberBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minSequenceNumberBuildStage == 0) {
                this.minSequenceNumberBuildStage = (byte)-1;
                this.minSequenceNumber = ImmutableMockManifestFile.super.minSequenceNumber();
                this.minSequenceNumberBuildStage = 1;
            }
            return this.minSequenceNumber;
        }

        void minSequenceNumber(long minSequenceNumber) {
            this.minSequenceNumber = minSequenceNumber;
            this.minSequenceNumberBuildStage = 1;
        }

        Long snapshotId() {
            if (this.snapshotIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.snapshotIdBuildStage == 0) {
                this.snapshotIdBuildStage = (byte)-1;
                this.snapshotId = ImmutableMockManifestFile.super.snapshotId();
                this.snapshotIdBuildStage = 1;
            }
            return this.snapshotId;
        }

        void snapshotId(Long snapshotId) {
            this.snapshotId = snapshotId;
            this.snapshotIdBuildStage = 1;
        }

        Integer addedFilesCount() {
            if (this.addedFilesCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.addedFilesCountBuildStage == 0) {
                this.addedFilesCountBuildStage = (byte)-1;
                this.addedFilesCount = ImmutableMockManifestFile.super.addedFilesCount();
                this.addedFilesCountBuildStage = 1;
            }
            return this.addedFilesCount;
        }

        void addedFilesCount(Integer addedFilesCount) {
            this.addedFilesCount = addedFilesCount;
            this.addedFilesCountBuildStage = 1;
        }

        Long addedRowsCount() {
            if (this.addedRowsCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.addedRowsCountBuildStage == 0) {
                this.addedRowsCountBuildStage = (byte)-1;
                this.addedRowsCount = ImmutableMockManifestFile.super.addedRowsCount();
                this.addedRowsCountBuildStage = 1;
            }
            return this.addedRowsCount;
        }

        void addedRowsCount(Long addedRowsCount) {
            this.addedRowsCount = addedRowsCount;
            this.addedRowsCountBuildStage = 1;
        }

        Integer existingFilesCount() {
            if (this.existingFilesCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.existingFilesCountBuildStage == 0) {
                this.existingFilesCountBuildStage = (byte)-1;
                this.existingFilesCount = ImmutableMockManifestFile.super.existingFilesCount();
                this.existingFilesCountBuildStage = 1;
            }
            return this.existingFilesCount;
        }

        void existingFilesCount(Integer existingFilesCount) {
            this.existingFilesCount = existingFilesCount;
            this.existingFilesCountBuildStage = 1;
        }

        Long existingRowsCount() {
            if (this.existingRowsCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.existingRowsCountBuildStage == 0) {
                this.existingRowsCountBuildStage = (byte)-1;
                this.existingRowsCount = ImmutableMockManifestFile.super.existingRowsCount();
                this.existingRowsCountBuildStage = 1;
            }
            return this.existingRowsCount;
        }

        void existingRowsCount(Long existingRowsCount) {
            this.existingRowsCount = existingRowsCount;
            this.existingRowsCountBuildStage = 1;
        }

        Integer deletedFilesCount() {
            if (this.deletedFilesCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deletedFilesCountBuildStage == 0) {
                this.deletedFilesCountBuildStage = (byte)-1;
                this.deletedFilesCount = ImmutableMockManifestFile.super.deletedFilesCount();
                this.deletedFilesCountBuildStage = 1;
            }
            return this.deletedFilesCount;
        }

        void deletedFilesCount(Integer deletedFilesCount) {
            this.deletedFilesCount = deletedFilesCount;
            this.deletedFilesCountBuildStage = 1;
        }

        Long deletedRowsCount() {
            if (this.deletedRowsCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deletedRowsCountBuildStage == 0) {
                this.deletedRowsCountBuildStage = (byte)-1;
                this.deletedRowsCount = ImmutableMockManifestFile.super.deletedRowsCount();
                this.deletedRowsCountBuildStage = 1;
            }
            return this.deletedRowsCount;
        }

        void deletedRowsCount(Long deletedRowsCount) {
            this.deletedRowsCount = deletedRowsCount;
            this.deletedRowsCountBuildStage = 1;
        }

        int numEntries() {
            if (this.numEntriesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.numEntriesBuildStage == 0) {
                this.numEntriesBuildStage = (byte)-1;
                this.numEntries = ImmutableMockManifestFile.super.numEntries();
                this.numEntriesBuildStage = 1;
            }
            return this.numEntries;
        }

        void numEntries(int numEntries) {
            this.numEntries = numEntries;
            this.numEntriesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.partitionSpecIdBuildStage == -1) {
                attributes.add("partitionSpecId");
            }
            if (this.contentBuildStage == -1) {
                attributes.add("content");
            }
            if (this.keyMetadataBuildStage == -1) {
                attributes.add("keyMetadata");
            }
            if (this.lengthBuildStage == -1) {
                attributes.add("length");
            }
            if (this.sequenceNumberBuildStage == -1) {
                attributes.add("sequenceNumber");
            }
            if (this.minSequenceNumberBuildStage == -1) {
                attributes.add("minSequenceNumber");
            }
            if (this.snapshotIdBuildStage == -1) {
                attributes.add("snapshotId");
            }
            if (this.addedFilesCountBuildStage == -1) {
                attributes.add("addedFilesCount");
            }
            if (this.addedRowsCountBuildStage == -1) {
                attributes.add("addedRowsCount");
            }
            if (this.existingFilesCountBuildStage == -1) {
                attributes.add("existingFilesCount");
            }
            if (this.existingRowsCountBuildStage == -1) {
                attributes.add("existingRowsCount");
            }
            if (this.deletedFilesCountBuildStage == -1) {
                attributes.add("deletedFilesCount");
            }
            if (this.deletedRowsCountBuildStage == -1) {
                attributes.add("deletedRowsCount");
            }
            if (this.numEntriesBuildStage == -1) {
                attributes.add("numEntries");
            }
            return "Cannot build MockManifestFile, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="MockManifestFile", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_BASE_DATA_FILE_PATH = 2L;
        private static final long OPT_BIT_PARTITION_SPEC_ID = 1L;
        private static final long OPT_BIT_KEY_METADATA = 2L;
        private static final long OPT_BIT_LENGTH = 4L;
        private static final long OPT_BIT_SEQUENCE_NUMBER = 8L;
        private static final long OPT_BIT_MIN_SEQUENCE_NUMBER = 16L;
        private static final long OPT_BIT_SNAPSHOT_ID = 32L;
        private static final long OPT_BIT_ADDED_FILES_COUNT = 64L;
        private static final long OPT_BIT_ADDED_ROWS_COUNT = 128L;
        private static final long OPT_BIT_EXISTING_FILES_COUNT = 256L;
        private static final long OPT_BIT_EXISTING_ROWS_COUNT = 512L;
        private static final long OPT_BIT_DELETED_FILES_COUNT = 1024L;
        private static final long OPT_BIT_DELETED_ROWS_COUNT = 2048L;
        private static final long OPT_BIT_NUM_ENTRIES = 4096L;
        private long initBits = 3L;
        private long optBits;
        private String path;
        private int partitionSpecId;
        private ManifestContent content;
        private ByteBuffer keyMetadata;
        private long length;
        private long sequenceNumber;
        private long minSequenceNumber;
        private Long snapshotId;
        private Integer addedFilesCount;
        private Long addedRowsCount;
        private Integer existingFilesCount;
        private Long existingRowsCount;
        private Integer deletedFilesCount;
        private Long deletedRowsCount;
        private int numEntries;
        private String baseDataFilePath;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockManifestFile instance) {
            Long deletedRowsCountValue;
            Integer deletedFilesCountValue;
            Long existingRowsCountValue;
            Integer existingFilesCountValue;
            Long addedRowsCountValue;
            Integer addedFilesCountValue;
            Objects.requireNonNull(instance, "instance");
            this.path(instance.path());
            this.partitionSpecId(instance.partitionSpecId());
            this.content(instance.content());
            ByteBuffer keyMetadataValue = instance.keyMetadata();
            if (keyMetadataValue != null) {
                this.keyMetadata(keyMetadataValue);
            }
            this.length(instance.length());
            this.sequenceNumber(instance.sequenceNumber());
            this.minSequenceNumber(instance.minSequenceNumber());
            Long snapshotIdValue = instance.snapshotId();
            if (snapshotIdValue != null) {
                this.snapshotId(snapshotIdValue);
            }
            if ((addedFilesCountValue = instance.addedFilesCount()) != null) {
                this.addedFilesCount(addedFilesCountValue);
            }
            if ((addedRowsCountValue = instance.addedRowsCount()) != null) {
                this.addedRowsCount(addedRowsCountValue);
            }
            if ((existingFilesCountValue = instance.existingFilesCount()) != null) {
                this.existingFilesCount(existingFilesCountValue);
            }
            if ((existingRowsCountValue = instance.existingRowsCount()) != null) {
                this.existingRowsCount(existingRowsCountValue);
            }
            if ((deletedFilesCountValue = instance.deletedFilesCount()) != null) {
                this.deletedFilesCount(deletedFilesCountValue);
            }
            if ((deletedRowsCountValue = instance.deletedRowsCount()) != null) {
                this.deletedRowsCount(deletedRowsCountValue);
            }
            this.numEntries(instance.numEntries());
            this.baseDataFilePath(instance.baseDataFilePath());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partitionSpecId(int partitionSpecId) {
            this.partitionSpecId = partitionSpecId;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder content(ManifestContent content) {
            this.content = Objects.requireNonNull(content, "content");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyMetadata(@Nullable ByteBuffer keyMetadata) {
            this.keyMetadata = keyMetadata;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder length(long length) {
            this.length = length;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minSequenceNumber(long minSequenceNumber) {
            this.minSequenceNumber = minSequenceNumber;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder snapshotId(@Nullable Long snapshotId) {
            this.snapshotId = snapshotId;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addedFilesCount(@Nullable Integer addedFilesCount) {
            this.addedFilesCount = addedFilesCount;
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addedRowsCount(@Nullable Long addedRowsCount) {
            this.addedRowsCount = addedRowsCount;
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder existingFilesCount(@Nullable Integer existingFilesCount) {
            this.existingFilesCount = existingFilesCount;
            this.optBits |= 0x100L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder existingRowsCount(@Nullable Long existingRowsCount) {
            this.existingRowsCount = existingRowsCount;
            this.optBits |= 0x200L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deletedFilesCount(@Nullable Integer deletedFilesCount) {
            this.deletedFilesCount = deletedFilesCount;
            this.optBits |= 0x400L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deletedRowsCount(@Nullable Long deletedRowsCount) {
            this.deletedRowsCount = deletedRowsCount;
            this.optBits |= 0x800L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder numEntries(int numEntries) {
            this.numEntries = numEntries;
            this.optBits |= 0x1000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder baseDataFilePath(String baseDataFilePath) {
            this.baseDataFilePath = Objects.requireNonNull(baseDataFilePath, "baseDataFilePath");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMockManifestFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMockManifestFile(this);
        }

        private boolean partitionSpecIdIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean keyMetadataIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean lengthIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean sequenceNumberIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean minSequenceNumberIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean snapshotIdIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean addedFilesCountIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean addedRowsCountIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean existingFilesCountIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean existingRowsCountIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean deletedFilesCountIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean deletedRowsCountIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean numEntriesIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("baseDataFilePath");
            }
            return "Cannot build MockManifestFile, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

