/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.iceberg.types.Types;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.mocks.MockManifestEntry;

@Generated(from="MockManifestEntry", generator="Immutables")
public final class ImmutableMockManifestEntry
extends MockManifestEntry {
    private final MockManifestEntry.Status status;
    @Nullable
    private final Long snapshotId;
    @Nullable
    private final Long sequenceNumber;
    private final String filePath;
    private final Types.StructType partitionType;

    private ImmutableMockManifestEntry(Builder builder) {
        this.snapshotId = builder.snapshotId;
        this.sequenceNumber = builder.sequenceNumber;
        this.filePath = builder.filePath;
        this.partitionType = builder.partitionType;
        this.status = builder.status != null ? builder.status : Objects.requireNonNull(super.status(), "status");
    }

    private ImmutableMockManifestEntry(MockManifestEntry.Status status, @Nullable Long snapshotId, @Nullable Long sequenceNumber, String filePath, Types.StructType partitionType) {
        this.status = status;
        this.snapshotId = snapshotId;
        this.sequenceNumber = sequenceNumber;
        this.filePath = filePath;
        this.partitionType = partitionType;
    }

    @Override
    public MockManifestEntry.Status status() {
        return this.status;
    }

    @Override
    @Nullable
    public Long snapshotId() {
        return this.snapshotId;
    }

    @Override
    @Nullable
    public Long sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public String filePath() {
        return this.filePath;
    }

    @Override
    public Types.StructType partitionType() {
        return this.partitionType;
    }

    public final ImmutableMockManifestEntry withStatus(MockManifestEntry.Status value) {
        MockManifestEntry.Status newValue = Objects.requireNonNull(value, "status");
        if (this.status == newValue) {
            return this;
        }
        return new ImmutableMockManifestEntry(newValue, this.snapshotId, this.sequenceNumber, this.filePath, this.partitionType);
    }

    public final ImmutableMockManifestEntry withSnapshotId(@Nullable Long value) {
        if (Objects.equals(this.snapshotId, value)) {
            return this;
        }
        return new ImmutableMockManifestEntry(this.status, value, this.sequenceNumber, this.filePath, this.partitionType);
    }

    public final ImmutableMockManifestEntry withSequenceNumber(@Nullable Long value) {
        if (Objects.equals(this.sequenceNumber, value)) {
            return this;
        }
        return new ImmutableMockManifestEntry(this.status, this.snapshotId, value, this.filePath, this.partitionType);
    }

    public final ImmutableMockManifestEntry withFilePath(String value) {
        String newValue = Objects.requireNonNull(value, "filePath");
        if (this.filePath.equals(newValue)) {
            return this;
        }
        return new ImmutableMockManifestEntry(this.status, this.snapshotId, this.sequenceNumber, newValue, this.partitionType);
    }

    public final ImmutableMockManifestEntry withPartitionType(Types.StructType value) {
        if (this.partitionType == value) {
            return this;
        }
        Types.StructType newValue = Objects.requireNonNull(value, "partitionType");
        return new ImmutableMockManifestEntry(this.status, this.snapshotId, this.sequenceNumber, this.filePath, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockManifestEntry && this.equalTo(0, (ImmutableMockManifestEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableMockManifestEntry another) {
        return this.status.equals((Object)another.status) && Objects.equals(this.snapshotId, another.snapshotId) && Objects.equals(this.sequenceNumber, another.sequenceNumber) && this.filePath.equals(another.filePath) && this.partitionType.equals((Object)another.partitionType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode(this.snapshotId);
        h += (h << 5) + Objects.hashCode(this.sequenceNumber);
        h += (h << 5) + this.filePath.hashCode();
        h += (h << 5) + this.partitionType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockManifestEntry").omitNullValues().add("status", (Object)this.status).add("snapshotId", (Object)this.snapshotId).add("sequenceNumber", (Object)this.sequenceNumber).add("filePath", (Object)this.filePath).add("partitionType", (Object)this.partitionType).toString();
    }

    public static ImmutableMockManifestEntry copyOf(MockManifestEntry instance) {
        if (instance instanceof ImmutableMockManifestEntry) {
            return (ImmutableMockManifestEntry)instance;
        }
        return ImmutableMockManifestEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockManifestEntry", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_FILE_PATH = 1L;
        private static final long INIT_BIT_PARTITION_TYPE = 2L;
        private long initBits = 3L;
        private MockManifestEntry.Status status;
        private Long snapshotId;
        private Long sequenceNumber;
        private String filePath;
        private Types.StructType partitionType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockManifestEntry instance) {
            Long sequenceNumberValue;
            Objects.requireNonNull(instance, "instance");
            this.status(instance.status());
            Long snapshotIdValue = instance.snapshotId();
            if (snapshotIdValue != null) {
                this.snapshotId(snapshotIdValue);
            }
            if ((sequenceNumberValue = instance.sequenceNumber()) != null) {
                this.sequenceNumber(sequenceNumberValue);
            }
            this.filePath(instance.filePath());
            this.partitionType(instance.partitionType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder status(MockManifestEntry.Status status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder snapshotId(@Nullable Long snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sequenceNumber(@Nullable Long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filePath(String filePath) {
            this.filePath = Objects.requireNonNull(filePath, "filePath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partitionType(Types.StructType partitionType) {
            this.partitionType = Objects.requireNonNull(partitionType, "partitionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMockManifestEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMockManifestEntry(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("filePath");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("partitionType");
            }
            return "Cannot build MockManifestEntry, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

