/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.mocks.MockPartitionSpec;
import org.projectnessie.gc.iceberg.mocks.MockPartitionSpecField;

@Generated(from="MockPartitionSpec", generator="Immutables")
public final class ImmutableMockPartitionSpec
extends MockPartitionSpec {
    private final ImmutableList<MockPartitionSpecField> fields;
    private final int specId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long JSON_NODE_LAZY_INIT_BIT = 1L;
    private transient JsonNode jsonNode;

    private ImmutableMockPartitionSpec(Builder builder) {
        if (builder.fieldsIsSet()) {
            this.initShim.fields((ImmutableList<MockPartitionSpecField>)builder.fields.build());
        }
        if (builder.specIdIsSet()) {
            this.initShim.specId(builder.specId);
        }
        this.fields = this.initShim.fields();
        this.specId = this.initShim.specId();
        this.initShim = null;
    }

    private ImmutableMockPartitionSpec(ImmutableList<MockPartitionSpecField> fields, int specId) {
        this.fields = fields;
        this.specId = specId;
        this.initShim = null;
    }

    public ImmutableList<MockPartitionSpecField> fields() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fields() : this.fields;
    }

    @Override
    public int specId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.specId() : this.specId;
    }

    public final ImmutableMockPartitionSpec withFields(MockPartitionSpecField ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMockPartitionSpec((ImmutableList<MockPartitionSpecField>)newValue, this.specId);
    }

    public final ImmutableMockPartitionSpec withFields(Iterable<? extends MockPartitionSpecField> elements) {
        if (this.fields == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMockPartitionSpec((ImmutableList<MockPartitionSpecField>)newValue, this.specId);
    }

    public final ImmutableMockPartitionSpec withSpecId(int value) {
        if (this.specId == value) {
            return this;
        }
        return new ImmutableMockPartitionSpec(this.fields, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockPartitionSpec && this.equalTo(0, (ImmutableMockPartitionSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableMockPartitionSpec another) {
        return this.fields.equals(another.fields) && this.specId == another.specId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.fields.hashCode();
        h += (h << 5) + this.specId;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockPartitionSpec").omitNullValues().add("fields", this.fields).add("specId", this.specId).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode jsonNode() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableMockPartitionSpec immutableMockPartitionSpec = this;
            synchronized (immutableMockPartitionSpec) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.jsonNode = Objects.requireNonNull(super.jsonNode(), "jsonNode");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.jsonNode;
    }

    public static ImmutableMockPartitionSpec copyOf(MockPartitionSpec instance) {
        if (instance instanceof ImmutableMockPartitionSpec) {
            return (ImmutableMockPartitionSpec)instance;
        }
        return ImmutableMockPartitionSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockPartitionSpec", generator="Immutables")
    private final class InitShim {
        private byte fieldsBuildStage = 0;
        private ImmutableList<MockPartitionSpecField> fields;
        private byte specIdBuildStage = 0;
        private int specId;

        private InitShim() {
        }

        ImmutableList<MockPartitionSpecField> fields() {
            if (this.fieldsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fieldsBuildStage == 0) {
                this.fieldsBuildStage = (byte)-1;
                this.fields = ImmutableList.copyOf((Collection)ImmutableMockPartitionSpec.super.fields());
                this.fieldsBuildStage = 1;
            }
            return this.fields;
        }

        void fields(ImmutableList<MockPartitionSpecField> fields) {
            this.fields = fields;
            this.fieldsBuildStage = 1;
        }

        int specId() {
            if (this.specIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.specIdBuildStage == 0) {
                this.specIdBuildStage = (byte)-1;
                this.specId = ImmutableMockPartitionSpec.super.specId();
                this.specIdBuildStage = 1;
            }
            return this.specId;
        }

        void specId(int specId) {
            this.specId = specId;
            this.specIdBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.fieldsBuildStage == -1) {
                attributes.add("fields");
            }
            if (this.specIdBuildStage == -1) {
                attributes.add("specId");
            }
            return "Cannot build MockPartitionSpec, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="MockPartitionSpec", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_FIELDS = 1L;
        private static final long OPT_BIT_SPEC_ID = 2L;
        private long optBits;
        private ImmutableList.Builder<MockPartitionSpecField> fields = ImmutableList.builder();
        private int specId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockPartitionSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllFields(instance.fields());
            this.specId(instance.specId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(MockPartitionSpecField element) {
            this.fields.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(MockPartitionSpecField ... elements) {
            this.fields.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fields(Iterable<? extends MockPartitionSpecField> elements) {
            this.fields = ImmutableList.builder();
            return this.addAllFields(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFields(Iterable<? extends MockPartitionSpecField> elements) {
            this.fields.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder specId(int specId) {
            this.specId = specId;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableMockPartitionSpec build() {
            return new ImmutableMockPartitionSpec(this);
        }

        private boolean fieldsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean specIdIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }
}

