/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.mocks.MockPartitionSpecField;

@Generated(from="MockPartitionSpecField", generator="Immutables")
public final class ImmutableMockPartitionSpecField
extends MockPartitionSpecField {
    private final String name;
    private final String transform;
    private final int sourceId;
    private final int fieldId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long JSON_NODE_LAZY_INIT_BIT = 1L;
    private transient JsonNode jsonNode;

    private ImmutableMockPartitionSpecField(Builder builder) {
        if (builder.name != null) {
            this.initShim.name(builder.name);
        }
        if (builder.transform != null) {
            this.initShim.transform(builder.transform);
        }
        if (builder.sourceIdIsSet()) {
            this.initShim.sourceId(builder.sourceId);
        }
        if (builder.fieldIdIsSet()) {
            this.initShim.fieldId(builder.fieldId);
        }
        this.name = this.initShim.name();
        this.transform = this.initShim.transform();
        this.sourceId = this.initShim.sourceId();
        this.fieldId = this.initShim.fieldId();
        this.initShim = null;
    }

    private ImmutableMockPartitionSpecField(String name, String transform, int sourceId, int fieldId) {
        this.name = name;
        this.transform = transform;
        this.sourceId = sourceId;
        this.fieldId = fieldId;
        this.initShim = null;
    }

    @Override
    public String name() {
        InitShim shim = this.initShim;
        return shim != null ? shim.name() : this.name;
    }

    @Override
    public String transform() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transform() : this.transform;
    }

    @Override
    public int sourceId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceId() : this.sourceId;
    }

    @Override
    public int fieldId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fieldId() : this.fieldId;
    }

    public final ImmutableMockPartitionSpecField withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableMockPartitionSpecField(newValue, this.transform, this.sourceId, this.fieldId);
    }

    public final ImmutableMockPartitionSpecField withTransform(String value) {
        String newValue = Objects.requireNonNull(value, "transform");
        if (this.transform.equals(newValue)) {
            return this;
        }
        return new ImmutableMockPartitionSpecField(this.name, newValue, this.sourceId, this.fieldId);
    }

    public final ImmutableMockPartitionSpecField withSourceId(int value) {
        if (this.sourceId == value) {
            return this;
        }
        return new ImmutableMockPartitionSpecField(this.name, this.transform, value, this.fieldId);
    }

    public final ImmutableMockPartitionSpecField withFieldId(int value) {
        if (this.fieldId == value) {
            return this;
        }
        return new ImmutableMockPartitionSpecField(this.name, this.transform, this.sourceId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockPartitionSpecField && this.equalsByValue((ImmutableMockPartitionSpecField)another);
    }

    private boolean equalsByValue(ImmutableMockPartitionSpecField another) {
        return this.name.equals(another.name) && this.transform.equals(another.transform) && this.sourceId == another.sourceId && this.fieldId == another.fieldId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.transform.hashCode();
        h += (h << 5) + this.sourceId;
        h += (h << 5) + this.fieldId;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockPartitionSpecField").omitNullValues().add("name", (Object)this.name).add("transform", (Object)this.transform).add("sourceId", this.sourceId).add("fieldId", this.fieldId).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode jsonNode() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableMockPartitionSpecField immutableMockPartitionSpecField = this;
            synchronized (immutableMockPartitionSpecField) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.jsonNode = Objects.requireNonNull(super.jsonNode(), "jsonNode");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.jsonNode;
    }

    public static ImmutableMockPartitionSpecField copyOf(MockPartitionSpecField instance) {
        if (instance instanceof ImmutableMockPartitionSpecField) {
            return (ImmutableMockPartitionSpecField)instance;
        }
        return ImmutableMockPartitionSpecField.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockPartitionSpecField", generator="Immutables")
    private final class InitShim {
        private byte nameBuildStage = 0;
        private String name;
        private byte transformBuildStage = 0;
        private String transform;
        private byte sourceIdBuildStage = 0;
        private int sourceId;
        private byte fieldIdBuildStage = 0;
        private int fieldId;

        private InitShim() {
        }

        String name() {
            if (this.nameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameBuildStage == 0) {
                this.nameBuildStage = (byte)-1;
                String computedValue = ImmutableMockPartitionSpecField.super.name();
                this.name = Objects.requireNonNull(computedValue, "name");
                this.nameBuildStage = 1;
            }
            return this.name;
        }

        void name(String name) {
            this.name = name;
            this.nameBuildStage = 1;
        }

        String transform() {
            if (this.transformBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transformBuildStage == 0) {
                this.transformBuildStage = (byte)-1;
                String computedValue = ImmutableMockPartitionSpecField.super.transform();
                this.transform = Objects.requireNonNull(computedValue, "transform");
                this.transformBuildStage = 1;
            }
            return this.transform;
        }

        void transform(String transform) {
            this.transform = transform;
            this.transformBuildStage = 1;
        }

        int sourceId() {
            if (this.sourceIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceIdBuildStage == 0) {
                int computedValue;
                this.sourceIdBuildStage = (byte)-1;
                this.sourceId = computedValue = ImmutableMockPartitionSpecField.super.sourceId();
                this.sourceIdBuildStage = 1;
            }
            return this.sourceId;
        }

        void sourceId(int sourceId) {
            this.sourceId = sourceId;
            this.sourceIdBuildStage = 1;
        }

        int fieldId() {
            if (this.fieldIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fieldIdBuildStage == 0) {
                int computedValue;
                this.fieldIdBuildStage = (byte)-1;
                this.fieldId = computedValue = ImmutableMockPartitionSpecField.super.fieldId();
                this.fieldIdBuildStage = 1;
            }
            return this.fieldId;
        }

        void fieldId(int fieldId) {
            this.fieldId = fieldId;
            this.fieldIdBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.nameBuildStage == -1) {
                attributes.add("name");
            }
            if (this.transformBuildStage == -1) {
                attributes.add("transform");
            }
            if (this.sourceIdBuildStage == -1) {
                attributes.add("sourceId");
            }
            if (this.fieldIdBuildStage == -1) {
                attributes.add("fieldId");
            }
            return "Cannot build MockPartitionSpecField, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="MockPartitionSpecField", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SOURCE_ID = 1L;
        private static final long OPT_BIT_FIELD_ID = 2L;
        private long optBits;
        private String name;
        private String transform;
        private int sourceId;
        private int fieldId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockPartitionSpecField instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.transform(instance.transform());
            this.sourceId(instance.sourceId());
            this.fieldId(instance.fieldId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transform(String transform) {
            this.transform = Objects.requireNonNull(transform, "transform");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceId(int sourceId) {
            this.sourceId = sourceId;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fieldId(int fieldId) {
            this.fieldId = fieldId;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableMockPartitionSpecField build() {
            return new ImmutableMockPartitionSpecField(this);
        }

        private boolean sourceIdIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean fieldIdIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }
}

