/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.mocks.MockField;
import org.projectnessie.gc.iceberg.mocks.MockSchema;

@Generated(from="MockSchema", generator="Immutables")
public final class ImmutableMockSchema
extends MockSchema {
    private final ImmutableList<MockField> fields;
    private final String type;
    private final int schemaId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long JSON_NODE_LAZY_INIT_BIT = 1L;
    private transient JsonNode jsonNode;

    private ImmutableMockSchema(Builder builder) {
        if (builder.fieldsIsSet()) {
            this.initShim.fields((ImmutableList<MockField>)builder.fields.build());
        }
        if (builder.type != null) {
            this.initShim.type(builder.type);
        }
        if (builder.schemaIdIsSet()) {
            this.initShim.schemaId(builder.schemaId);
        }
        this.fields = this.initShim.fields();
        this.type = this.initShim.type();
        this.schemaId = this.initShim.schemaId();
        this.initShim = null;
    }

    private ImmutableMockSchema(ImmutableList<MockField> fields, String type, int schemaId) {
        this.fields = fields;
        this.type = type;
        this.schemaId = schemaId;
        this.initShim = null;
    }

    public ImmutableList<MockField> fields() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fields() : this.fields;
    }

    @Override
    public String type() {
        InitShim shim = this.initShim;
        return shim != null ? shim.type() : this.type;
    }

    @Override
    public int schemaId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.schemaId() : this.schemaId;
    }

    public final ImmutableMockSchema withFields(MockField ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMockSchema((ImmutableList<MockField>)newValue, this.type, this.schemaId);
    }

    public final ImmutableMockSchema withFields(Iterable<? extends MockField> elements) {
        if (this.fields == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMockSchema((ImmutableList<MockField>)newValue, this.type, this.schemaId);
    }

    public final ImmutableMockSchema withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableMockSchema(this.fields, newValue, this.schemaId);
    }

    public final ImmutableMockSchema withSchemaId(int value) {
        if (this.schemaId == value) {
            return this;
        }
        return new ImmutableMockSchema(this.fields, this.type, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockSchema && this.equalsByValue((ImmutableMockSchema)another);
    }

    private boolean equalsByValue(ImmutableMockSchema another) {
        return this.fields.equals(another.fields) && this.type.equals(another.type) && this.schemaId == another.schemaId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.fields.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.schemaId;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockSchema").omitNullValues().add("fields", this.fields).add("type", (Object)this.type).add("schemaId", this.schemaId).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode jsonNode() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableMockSchema immutableMockSchema = this;
            synchronized (immutableMockSchema) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.jsonNode = Objects.requireNonNull(super.jsonNode(), "jsonNode");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.jsonNode;
    }

    public static ImmutableMockSchema copyOf(MockSchema instance) {
        if (instance instanceof ImmutableMockSchema) {
            return (ImmutableMockSchema)instance;
        }
        return ImmutableMockSchema.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockSchema", generator="Immutables")
    private final class InitShim {
        private byte fieldsBuildStage = 0;
        private ImmutableList<MockField> fields;
        private byte typeBuildStage = 0;
        private String type;
        private byte schemaIdBuildStage = 0;
        private int schemaId;

        private InitShim() {
        }

        ImmutableList<MockField> fields() {
            if (this.fieldsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fieldsBuildStage == 0) {
                this.fieldsBuildStage = (byte)-1;
                List computedValue = ImmutableMockSchema.super.fields();
                this.fields = ImmutableList.copyOf((Collection)computedValue);
                this.fieldsBuildStage = 1;
            }
            return this.fields;
        }

        void fields(ImmutableList<MockField> fields) {
            this.fields = fields;
            this.fieldsBuildStage = 1;
        }

        String type() {
            if (this.typeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeBuildStage == 0) {
                this.typeBuildStage = (byte)-1;
                String computedValue = ImmutableMockSchema.super.type();
                this.type = Objects.requireNonNull(computedValue, "type");
                this.typeBuildStage = 1;
            }
            return this.type;
        }

        void type(String type) {
            this.type = type;
            this.typeBuildStage = 1;
        }

        int schemaId() {
            if (this.schemaIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaIdBuildStage == 0) {
                int computedValue;
                this.schemaIdBuildStage = (byte)-1;
                this.schemaId = computedValue = ImmutableMockSchema.super.schemaId();
                this.schemaIdBuildStage = 1;
            }
            return this.schemaId;
        }

        void schemaId(int schemaId) {
            this.schemaId = schemaId;
            this.schemaIdBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.fieldsBuildStage == -1) {
                attributes.add("fields");
            }
            if (this.typeBuildStage == -1) {
                attributes.add("type");
            }
            if (this.schemaIdBuildStage == -1) {
                attributes.add("schemaId");
            }
            return "Cannot build MockSchema, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="MockSchema", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_FIELDS = 1L;
        private static final long OPT_BIT_SCHEMA_ID = 2L;
        private long optBits;
        private ImmutableList.Builder<MockField> fields = ImmutableList.builder();
        private String type;
        private int schemaId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockSchema instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllFields(instance.fields());
            this.type(instance.type());
            this.schemaId(instance.schemaId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(MockField element) {
            this.fields.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(MockField ... elements) {
            this.fields.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fields(Iterable<? extends MockField> elements) {
            this.fields = ImmutableList.builder();
            return this.addAllFields(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFields(Iterable<? extends MockField> elements) {
            this.fields.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaId(int schemaId) {
            this.schemaId = schemaId;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableMockSchema build() {
            return new ImmutableMockSchema(this);
        }

        private boolean fieldsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean schemaIdIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }
}

