/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.mocks.MockSortOrder;
import org.projectnessie.gc.iceberg.mocks.MockSortOrderField;

@Generated(from="MockSortOrder", generator="Immutables")
public final class ImmutableMockSortOrder
extends MockSortOrder {
    private final ImmutableList<MockSortOrderField> fields;
    private final int orderId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long JSON_NODE_LAZY_INIT_BIT = 1L;
    private transient JsonNode jsonNode;

    private ImmutableMockSortOrder(Builder builder) {
        if (builder.fieldsIsSet()) {
            this.initShim.fields((ImmutableList<MockSortOrderField>)builder.fields.build());
        }
        if (builder.orderIdIsSet()) {
            this.initShim.orderId(builder.orderId);
        }
        this.fields = this.initShim.fields();
        this.orderId = this.initShim.orderId();
        this.initShim = null;
    }

    private ImmutableMockSortOrder(ImmutableList<MockSortOrderField> fields, int orderId) {
        this.fields = fields;
        this.orderId = orderId;
        this.initShim = null;
    }

    public ImmutableList<MockSortOrderField> fields() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fields() : this.fields;
    }

    @Override
    public int orderId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.orderId() : this.orderId;
    }

    public final ImmutableMockSortOrder withFields(MockSortOrderField ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMockSortOrder((ImmutableList<MockSortOrderField>)newValue, this.orderId);
    }

    public final ImmutableMockSortOrder withFields(Iterable<? extends MockSortOrderField> elements) {
        if (this.fields == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMockSortOrder((ImmutableList<MockSortOrderField>)newValue, this.orderId);
    }

    public final ImmutableMockSortOrder withOrderId(int value) {
        if (this.orderId == value) {
            return this;
        }
        return new ImmutableMockSortOrder(this.fields, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockSortOrder && this.equalsByValue((ImmutableMockSortOrder)another);
    }

    private boolean equalsByValue(ImmutableMockSortOrder another) {
        return this.fields.equals(another.fields) && this.orderId == another.orderId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.fields.hashCode();
        h += (h << 5) + this.orderId;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockSortOrder").omitNullValues().add("fields", this.fields).add("orderId", this.orderId).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode jsonNode() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableMockSortOrder immutableMockSortOrder = this;
            synchronized (immutableMockSortOrder) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.jsonNode = Objects.requireNonNull(super.jsonNode(), "jsonNode");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.jsonNode;
    }

    public static ImmutableMockSortOrder copyOf(MockSortOrder instance) {
        if (instance instanceof ImmutableMockSortOrder) {
            return (ImmutableMockSortOrder)instance;
        }
        return ImmutableMockSortOrder.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockSortOrder", generator="Immutables")
    private final class InitShim {
        private byte fieldsBuildStage = 0;
        private ImmutableList<MockSortOrderField> fields;
        private byte orderIdBuildStage = 0;
        private int orderId;

        private InitShim() {
        }

        ImmutableList<MockSortOrderField> fields() {
            if (this.fieldsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fieldsBuildStage == 0) {
                this.fieldsBuildStage = (byte)-1;
                List computedValue = ImmutableMockSortOrder.super.fields();
                this.fields = ImmutableList.copyOf((Collection)computedValue);
                this.fieldsBuildStage = 1;
            }
            return this.fields;
        }

        void fields(ImmutableList<MockSortOrderField> fields) {
            this.fields = fields;
            this.fieldsBuildStage = 1;
        }

        int orderId() {
            if (this.orderIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.orderIdBuildStage == 0) {
                int computedValue;
                this.orderIdBuildStage = (byte)-1;
                this.orderId = computedValue = ImmutableMockSortOrder.super.orderId();
                this.orderIdBuildStage = 1;
            }
            return this.orderId;
        }

        void orderId(int orderId) {
            this.orderId = orderId;
            this.orderIdBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.fieldsBuildStage == -1) {
                attributes.add("fields");
            }
            if (this.orderIdBuildStage == -1) {
                attributes.add("orderId");
            }
            return "Cannot build MockSortOrder, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="MockSortOrder", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_FIELDS = 1L;
        private static final long OPT_BIT_ORDER_ID = 2L;
        private long optBits;
        private ImmutableList.Builder<MockSortOrderField> fields = ImmutableList.builder();
        private int orderId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockSortOrder instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllFields(instance.fields());
            this.orderId(instance.orderId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(MockSortOrderField element) {
            this.fields.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(MockSortOrderField ... elements) {
            this.fields.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fields(Iterable<? extends MockSortOrderField> elements) {
            this.fields = ImmutableList.builder();
            return this.addAllFields(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFields(Iterable<? extends MockSortOrderField> elements) {
            this.fields.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder orderId(int orderId) {
            this.orderId = orderId;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableMockSortOrder build() {
            return new ImmutableMockSortOrder(this);
        }

        private boolean fieldsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean orderIdIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }
}

