/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.immutables.value.Value;
import org.projectnessie.gc.iceberg.mocks.ImmutableMockSortOrderField;
import org.projectnessie.gc.iceberg.mocks.MockSortOrderField;

@Value.Immutable
public abstract class MockSortOrder {
    @Value.Lazy
    public JsonNode jsonNode() {
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put("order-id", this.orderId());
        this.fields(node.putArray("fields"));
        return node;
    }

    @Value.Default
    public List<MockSortOrderField> fields() {
        return Collections.singletonList(ImmutableMockSortOrderField.builder().build());
    }

    private void fields(ArrayNode fields) {
        for (MockSortOrderField field : this.fields()) {
            fields.add(field.jsonNode());
        }
    }

    @Value.Default
    public int orderId() {
        return 1;
    }
}

