/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.types.Types;
import org.immutables.value.Generated;
import org.projectnessie.gc.iceberg.mocks.MockManifestEntry;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MockManifestEntry", generator="Immutables")
@Immutable
public final class ImmutableMockManifestEntry
extends MockManifestEntry {
    private final MockManifestEntry.Status status;
    @jakarta.annotation.Nullable
    private final Long snapshotId;
    @jakarta.annotation.Nullable
    private final Long sequenceNumber;
    private final String filePath;
    private final Types.StructType partitionType;

    private ImmutableMockManifestEntry(Builder builder) {
        this.snapshotId = builder.snapshotId;
        this.sequenceNumber = builder.sequenceNumber;
        this.filePath = builder.filePath;
        this.partitionType = builder.partitionType;
        this.status = builder.status != null ? builder.status : Objects.requireNonNull(super.status(), "status");
    }

    private ImmutableMockManifestEntry(MockManifestEntry.Status status, @jakarta.annotation.Nullable Long snapshotId, @jakarta.annotation.Nullable Long sequenceNumber, String filePath, Types.StructType partitionType) {
        this.status = status;
        this.snapshotId = snapshotId;
        this.sequenceNumber = sequenceNumber;
        this.filePath = filePath;
        this.partitionType = partitionType;
    }

    @Override
    public MockManifestEntry.Status status() {
        return this.status;
    }

    @Override
    @jakarta.annotation.Nullable
    public Long snapshotId() {
        return this.snapshotId;
    }

    @Override
    @jakarta.annotation.Nullable
    public Long sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public String filePath() {
        return this.filePath;
    }

    @Override
    public Types.StructType partitionType() {
        return this.partitionType;
    }

    public final ImmutableMockManifestEntry withStatus(MockManifestEntry.Status value) {
        MockManifestEntry.Status newValue = Objects.requireNonNull(value, "status");
        if (this.status == newValue) {
            return this;
        }
        return new ImmutableMockManifestEntry(newValue, this.snapshotId, this.sequenceNumber, this.filePath, this.partitionType);
    }

    public final ImmutableMockManifestEntry withSnapshotId(@jakarta.annotation.Nullable Long value) {
        if (Objects.equals(this.snapshotId, value)) {
            return this;
        }
        return new ImmutableMockManifestEntry(this.status, value, this.sequenceNumber, this.filePath, this.partitionType);
    }

    public final ImmutableMockManifestEntry withSequenceNumber(@jakarta.annotation.Nullable Long value) {
        if (Objects.equals(this.sequenceNumber, value)) {
            return this;
        }
        return new ImmutableMockManifestEntry(this.status, this.snapshotId, value, this.filePath, this.partitionType);
    }

    public final ImmutableMockManifestEntry withFilePath(String value) {
        String newValue = Objects.requireNonNull(value, "filePath");
        if (this.filePath.equals(newValue)) {
            return this;
        }
        return new ImmutableMockManifestEntry(this.status, this.snapshotId, this.sequenceNumber, newValue, this.partitionType);
    }

    public final ImmutableMockManifestEntry withPartitionType(Types.StructType value) {
        if (this.partitionType == value) {
            return this;
        }
        Types.StructType newValue = Objects.requireNonNull(value, "partitionType");
        return new ImmutableMockManifestEntry(this.status, this.snapshotId, this.sequenceNumber, this.filePath, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMockManifestEntry && this.equalTo(0, (ImmutableMockManifestEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableMockManifestEntry another) {
        return this.status.equals((Object)another.status) && Objects.equals(this.snapshotId, another.snapshotId) && Objects.equals(this.sequenceNumber, another.sequenceNumber) && this.filePath.equals(another.filePath) && this.partitionType.equals((Object)another.partitionType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode(this.snapshotId);
        h += (h << 5) + Objects.hashCode(this.sequenceNumber);
        h += (h << 5) + this.filePath.hashCode();
        h += (h << 5) + this.partitionType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MockManifestEntry").omitNullValues().add("status", (Object)this.status).add("snapshotId", (Object)this.snapshotId).add("sequenceNumber", (Object)this.sequenceNumber).add("filePath", (Object)this.filePath).add("partitionType", (Object)this.partitionType).toString();
    }

    public static ImmutableMockManifestEntry copyOf(MockManifestEntry instance) {
        if (instance instanceof ImmutableMockManifestEntry) {
            return (ImmutableMockManifestEntry)instance;
        }
        return ImmutableMockManifestEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MockManifestEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FILE_PATH = 1L;
        private static final long INIT_BIT_PARTITION_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private MockManifestEntry.Status status;
        @Nullable
        private Long snapshotId;
        @Nullable
        private Long sequenceNumber;
        @Nullable
        private String filePath;
        @Nullable
        private Types.StructType partitionType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MockManifestEntry instance) {
            Long sequenceNumberValue;
            Objects.requireNonNull(instance, "instance");
            this.status(instance.status());
            Long snapshotIdValue = instance.snapshotId();
            if (snapshotIdValue != null) {
                this.snapshotId(snapshotIdValue);
            }
            if ((sequenceNumberValue = instance.sequenceNumber()) != null) {
                this.sequenceNumber(sequenceNumberValue);
            }
            this.filePath(instance.filePath());
            this.partitionType(instance.partitionType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder status(MockManifestEntry.Status status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder snapshotId(@jakarta.annotation.Nullable Long snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sequenceNumber(@jakarta.annotation.Nullable Long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filePath(String filePath) {
            this.filePath = Objects.requireNonNull(filePath, "filePath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partitionType(Types.StructType partitionType) {
            this.partitionType = Objects.requireNonNull(partitionType, "partitionType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMockManifestEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMockManifestEntry(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("filePath");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("partitionType");
            }
            return "Cannot build MockManifestEntry, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

