/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg.mocks;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.ByteBufferInputStream;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewMetadataParser;
import org.projectnessie.gc.iceberg.mocks.MockManifestFile;
import org.projectnessie.gc.iceberg.mocks.MockSnapshot;
import org.projectnessie.gc.iceberg.mocks.MockTableMetadata;

public abstract class IcebergFileIOMocking
implements FileIO {
    public static String tableBase(String tableUuid) {
        return String.format("mock://data/%s/", tableUuid);
    }

    public static String tableMetadataLocation(String tableUuid, long snapshotId) {
        return String.format("%s%d/foo.metadata.json", IcebergFileIOMocking.tableBase(tableUuid), snapshotId);
    }

    public static String viewMetadataLocation(String tableUuid, long snapshotId) {
        return String.format("%s%d/foo.metadata.json", IcebergFileIOMocking.tableBase(tableUuid), snapshotId);
    }

    public static String manifestListLocation(String tableUuid, long snapshotId) {
        return String.format("%s%d/manifest-list.json", IcebergFileIOMocking.tableBase(tableUuid), snapshotId);
    }

    public static String manifestFileLocation(String tableUuid, long snapshotId, int num) {
        return String.format("%s%d/manifest-file-%d.avro", IcebergFileIOMocking.tableBase(tableUuid), snapshotId, num);
    }

    public static String dataFileBase(String tableUuid, long snapshotId, int num) {
        return String.format("%s%d/data-file-%d", IcebergFileIOMocking.tableBase(tableUuid), snapshotId, num);
    }

    public static String dataFilePath(String tableUuid, long snapshotId, int num, int dataFileNum) {
        return String.format("%s%d/data-file-%d-%d.parquet", IcebergFileIOMocking.tableBase(tableUuid), snapshotId, num, dataFileNum);
    }

    public static String dataFilePath(String dataFilePrefix, int dataFileNum) {
        return String.format("%s-%d.parquet", dataFilePrefix, dataFileNum);
    }

    public static IcebergFileIOMocking forSingleSnapshot(final MockTableMetadata tableMetadata) {
        return new IcebergFileIOMocking(){

            public InputFile newInputFile(String path) {
                String meta = 1.tableMetadataLocation(tableMetadata.tableUuid(), tableMetadata.currentSnapshotId());
                if (path.equals(meta)) {
                    return 1.inputFile(meta, tableMetadata.jsonNode());
                }
                for (MockSnapshot snapshot : tableMetadata.snapshots()) {
                    if (path.equals(snapshot.manifestListLocation())) {
                        WrappedOutputFile output = new WrappedOutputFile(path);
                        snapshot.generateManifestList(output);
                        return output.toInputFile();
                    }
                    Optional<MockManifestFile> manifestFile = snapshot.manifestFiles().filter(mf -> mf.path().equals(path)).findFirst();
                    if (!manifestFile.isPresent()) continue;
                    WrappedOutputFile output = new WrappedOutputFile(path);
                    manifestFile.get().write(output);
                    return output.toInputFile();
                }
                return 1.notFound(path);
            }
        };
    }

    public static IcebergFileIOMocking forSingleVersion(final ViewMetadata viewMetadata) {
        return new IcebergFileIOMocking(){

            public InputFile newInputFile(String path) {
                String meta = 2.tableMetadataLocation(viewMetadata.uuid(), viewMetadata.currentVersionId());
                if (path.equals(meta)) {
                    return 2.inputFile(meta, ViewMetadataParser.toJson((ViewMetadata)viewMetadata).getBytes(StandardCharsets.UTF_8));
                }
                return 2.notFound(path);
            }
        };
    }

    public static InputFile notFound(final String path) {
        return new InputFile(){

            public long getLength() {
                throw new NotFoundException("%s", new Object[]{path});
            }

            public SeekableInputStream newStream() {
                throw new NotFoundException("%s", new Object[]{path});
            }

            public String location() {
                return path;
            }

            public boolean exists() {
                return false;
            }
        };
    }

    public static InputFile inputFile(String location, JsonNode jsonNode) {
        return IcebergFileIOMocking.inputFile(location, jsonNode.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static InputFile inputFile(final String location, final byte[] data) {
        return new InputFile(){

            public long getLength() {
                return data.length;
            }

            public SeekableInputStream newStream() {
                return ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(data)});
            }

            public String location() {
                return location;
            }

            public boolean exists() {
                return true;
            }
        };
    }

    public OutputFile newOutputFile(String path) {
        throw new UnsupportedOperationException();
    }

    public void deleteFile(String path) {
        throw new UnsupportedOperationException();
    }

    public static final class WrappedOutputFile
    implements OutputFile {
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();
        private final String location;

        public WrappedOutputFile(String location) {
            this.location = location;
        }

        public PositionOutputStream create() {
            return new PositionOutputStream(){

                public long getPos() {
                    return output.size();
                }

                public void write(int b) {
                    output.write(b);
                }

                public void write(byte[] b) throws IOException {
                    output.write(b);
                }

                public void write(byte[] b, int off, int len) {
                    output.write(b, off, len);
                }
            };
        }

        public PositionOutputStream createOrOverwrite() {
            return this.create();
        }

        public String location() {
            return this.location;
        }

        public InputFile toInputFile() {
            return IcebergFileIOMocking.inputFile(this.location, this.asBytes());
        }

        public byte[] asBytes() {
            return this.output.toByteArray();
        }
    }
}

