/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg;

import com.google.common.base.Preconditions;
import org.projectnessie.gc.contents.ContentReference;
import org.projectnessie.gc.identify.ContentToContentReference;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergContent;

public final class IcebergContentToContentReference
implements ContentToContentReference {
    public static final IcebergContentToContentReference INSTANCE = new IcebergContentToContentReference();

    private IcebergContentToContentReference() {
    }

    public ContentReference contentToReference(Content content, String commitId, ContentKey key) {
        Content.Type contentType = content.getType();
        if (contentType.equals((Object)Content.Type.ICEBERG_TABLE) || contentType.equals((Object)Content.Type.ICEBERG_VIEW)) {
            Preconditions.checkArgument((boolean)contentType.type().isInstance(content), (String)"Expect %s, but got %s", (Object)contentType.type().getSimpleName(), (Object)content.getClass().getName());
            IcebergContent icebergContent = (IcebergContent)content;
            return ContentReference.icebergContent((Content.Type)contentType, (String)content.getId(), (String)commitId, (ContentKey)key, (String)icebergContent.getMetadataLocation(), (long)icebergContent.getVersionId());
        }
        throw new IllegalArgumentException("Expect ICEBERG_TABLE/ICEBERG_VIEW, but got " + String.valueOf(contentType));
    }
}

