/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.iceberg;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.MustBeClosed;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.immutables.value.Value;
import org.projectnessie.gc.contents.ContentReference;
import org.projectnessie.gc.expire.ContentToFiles;
import org.projectnessie.gc.files.FileReference;
import org.projectnessie.gc.iceberg.ImmutableIcebergContentToFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class IcebergContentToFiles
implements ContentToFiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergContentToFiles.class);
    public static final String S3_KEY_NOT_FOUND = "software.amazon.awssdk.services.s3.model.NoSuchKeyException";

    public static Builder builder() {
        return ImmutableIcebergContentToFiles.builder();
    }

    abstract FileIO io();

    @MustBeClosed
    public Stream<FileReference> extractFiles(ContentReference contentReference) {
        TableMetadata tableMetadata;
        FileIO io = this.io();
        try {
            tableMetadata = TableMetadataParser.read((FileIO)io, (String)contentReference.metadataLocation());
        }
        catch (Exception notFoundCandidate) {
            if (notFoundCandidate instanceof NotFoundException || S3_KEY_NOT_FOUND.equals(notFoundCandidate.getClass().getName())) {
                LOGGER.info("Table metadata {} for snapshot ID {} for content-key {} at Nessie commit {} does not exist, probably already deleted, assuming no files", new Object[]{contentReference.metadataLocation(), contentReference.snapshotId(), contentReference.contentKey(), contentReference.commitId()});
                return Stream.empty();
            }
            throw new RuntimeException(notFoundCandidate);
        }
        long snapshotId = Objects.requireNonNull(contentReference.snapshotId(), "Iceberg content is expected to have a non-null snapshot-ID");
        Snapshot snapshot = snapshotId < 0L ? tableMetadata.currentSnapshot() : tableMetadata.snapshot(snapshotId);
        Stream<URI> allFiles = IcebergContentToFiles.elementaryUrisFromSnapshot(snapshot, contentReference);
        if (snapshot != null) {
            allFiles = Stream.concat(allFiles, Stream.of("").flatMap(x -> {
                Stream<URI> r = IcebergContentToFiles.allManifestsAndDataFiles(io, snapshot, contentReference);
                return r;
            }));
        }
        URI baseUri = IcebergContentToFiles.baseUri(tableMetadata, contentReference);
        return allFiles.map(baseUri::relativize).map(u -> FileReference.of((URI)u, (URI)baseUri, (long)-1L));
    }

    @MustBeClosed
    static Stream<URI> allManifestsAndDataFiles(FileIO io, Snapshot snapshot, ContentReference contentReference) {
        return IcebergContentToFiles.allManifests(io, snapshot).flatMap(mf -> {
            URI manifestFileUri = IcebergContentToFiles.manifestFileUri(mf, contentReference);
            Stream<URI> allDataFile = IcebergContentToFiles.allDataFiles(io, mf, contentReference);
            return Stream.concat(Stream.of(manifestFileUri), allDataFile);
        });
    }

    static Stream<ManifestFile> allManifests(FileIO io, Snapshot snapshot) {
        return snapshot.allManifests(io).stream();
    }

    @MustBeClosed
    static Stream<URI> allDataFiles(FileIO io, ManifestFile manifestFile, ContentReference contentReference) {
        CloseableIterable iter = ManifestFiles.readPaths((ManifestFile)manifestFile, (FileIO)io);
        return (Stream)StreamSupport.stream(iter.spliterator(), false).map(dataFilePath -> IcebergContentToFiles.dataFileUri(dataFilePath, contentReference)).onClose(() -> {
            try {
                iter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    static URI checkUri(String type, URI uri, ContentReference contentReference) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            String path = uri.getPath();
            Preconditions.checkArgument((boolean)path.startsWith("/"), (String)"Iceberg content reference points to the %s URI '%s' as content-key %s on commit %s without a scheme and with a relative path, which is not supported.", (Object)type, (Object)uri, (Object)contentReference.contentKey(), (Object)contentReference.commitId());
            uri = URI.create("file://" + path);
        }
        if ("file".equals(scheme)) {
            String schemeSpecific = uri.getSchemeSpecificPart();
            Preconditions.checkArgument((boolean)schemeSpecific.startsWith("/"), (String)"Iceberg content reference points to the %s URI '%s' as content-key %s on commit %s with a non-absolute scheme-specific-part %s, which is not supported.", (Object[])new Object[]{type, uri, contentReference.contentKey(), contentReference.commitId(), schemeSpecific});
            Preconditions.checkArgument((uri.getHost() == null ? 1 : 0) != 0, (String)"Iceberg content reference points to the host-specific %s URI '%s' as content-key %s on commit %s without a scheme, which is not supported.", (Object)type, (Object)uri, (Object)contentReference.contentKey(), (Object)contentReference.commitId());
            if (!schemeSpecific.startsWith("///")) {
                uri = URI.create("file://" + uri.getPath());
            }
        }
        return uri;
    }

    static Stream<URI> elementaryUrisFromSnapshot(Snapshot snapshot, ContentReference contentReference) {
        String metadataLocation = (String)Preconditions.checkNotNull((Object)contentReference.metadataLocation(), (String)"Iceberg content is expected to have a non-null metadata-location for content-key %s on commit %s", (Object)contentReference.contentKey(), (Object)contentReference.commitId());
        URI metadataUri = URI.create(metadataLocation);
        metadataUri = IcebergContentToFiles.checkUri("metadata", metadataUri, contentReference);
        if (snapshot == null) {
            return Stream.of(metadataUri);
        }
        String manifestListLocation = snapshot.manifestListLocation();
        if (manifestListLocation == null) {
            return Stream.of(metadataUri);
        }
        URI manifestListUri = URI.create(snapshot.manifestListLocation());
        manifestListUri = IcebergContentToFiles.checkUri("manifest list", manifestListUri, contentReference);
        return Stream.of(metadataUri, manifestListUri);
    }

    static URI baseUri(@javax.annotation.Nonnull @Nonnull TableMetadata tableMetadata, @javax.annotation.Nonnull @Nonnull ContentReference contentReference) {
        String location = tableMetadata.location();
        URI uri = URI.create((String)(location.endsWith("/") ? location : location + "/"));
        return IcebergContentToFiles.checkUri("location", uri, contentReference);
    }

    static URI manifestFileUri(@javax.annotation.Nonnull @Nonnull ManifestFile mf, @javax.annotation.Nonnull @Nonnull ContentReference contentReference) {
        String manifestFilePath = (String)Preconditions.checkNotNull((Object)mf.path(), (String)"Iceberg manifest file is expected to have a non-null path for content-key %s on commit %s", (Object)contentReference.contentKey(), (Object)contentReference.commitId());
        URI manifestFile = URI.create(manifestFilePath);
        return IcebergContentToFiles.checkUri("manifest file", manifestFile, contentReference);
    }

    static URI dataFileUri(@javax.annotation.Nonnull @Nonnull String dataFilePath, @javax.annotation.Nonnull @Nonnull ContentReference contentReference) {
        URI uri = URI.create(dataFilePath);
        return IcebergContentToFiles.checkUri("data file", uri, contentReference);
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder io(FileIO var1);

        public IcebergContentToFiles build();
    }
}

