/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.rest.NessieBadResponseException;
import org.projectnessie.error.ImmutableNessieError;

public class HttpResponse {
    private final ResponseContext responseContext;
    private final ObjectMapper mapper;

    public HttpResponse(ResponseContext context, ObjectMapper mapper) {
        this.responseContext = context;
        this.mapper = mapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <V> V readEntity(ObjectReader reader) {
        try {
            if (this.responseContext.getResponseCode().getCode() == Status.NO_CONTENT.getCode()) {
                return null;
            }
            try (InputStream is = this.responseContext.getInputStream();){
                if (!this.responseContext.isJsonCompatibleResponse()) {
                    this.nonJsonResponse();
                }
                Object object = reader.readValue(is);
                return (V)object;
            }
        }
        catch (IOException e) {
            throw new HttpClientException("Cannot parse response.", e);
        }
    }

    private void nonJsonResponse() throws IOException {
        Status status = this.responseContext.getResponseCode();
        throw new NessieBadResponseException(ImmutableNessieError.builder().status(status.getCode()).message(status.getReason()).reason(String.format("Expected the server to return a JSON compatible response, but the server returned with Content-Type '%s' from '%s'. Check the Nessie REST API base URI. Nessie REST API base URI usually end in '/api/v1', but your service provider may have a different URL pattern.", this.responseContext.getContentType(), this.responseContext.getRequestedUri())).build());
    }

    public <V> V readEntity(Class<V> clazz) {
        return this.readEntity(this.mapper.readerFor(clazz));
    }
}

