/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.builder;

import java.util.HashMap;
import java.util.Map;
import org.projectnessie.client.api.OnBranchBuilder;
import org.projectnessie.client.builder.BaseOnBranchBuilder;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;

public abstract class BaseMergeTransplantBuilder<B extends OnBranchBuilder<B>>
extends BaseOnBranchBuilder<B> {
    protected String fromRefName;
    protected Boolean keepIndividualCommits;
    protected Boolean dryRun;
    protected Boolean returnConflictAsResult;
    protected Boolean fetchAdditionalInfo;
    protected MergeBehavior defaultMergeMode;
    protected Map<ContentKey, MergeKeyBehavior> mergeModes;
    protected String message;

    public B message(String message) {
        this.message = message;
        return (B)this;
    }

    public B fromRefName(String fromRefName) {
        this.fromRefName = fromRefName;
        return (B)this;
    }

    public B keepIndividualCommits(boolean keepIndividualCommits) {
        this.keepIndividualCommits = keepIndividualCommits;
        return (B)this;
    }

    public B dryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return (B)this;
    }

    public B fetchAdditionalInfo(boolean fetchAdditionalInfo) {
        this.fetchAdditionalInfo = fetchAdditionalInfo;
        return (B)this;
    }

    public B returnConflictAsResult(boolean returnConflictAsResult) {
        this.returnConflictAsResult = returnConflictAsResult;
        return (B)this;
    }

    public B defaultMergeMode(MergeBehavior mergeBehavior) {
        this.defaultMergeMode = mergeBehavior;
        return (B)this;
    }

    public B mergeMode(ContentKey key, MergeBehavior mergeBehavior) {
        if (this.mergeModes == null) {
            this.mergeModes = new HashMap<ContentKey, MergeKeyBehavior>();
        }
        this.mergeModes.put(key, MergeKeyBehavior.of(key, mergeBehavior));
        return (B)this;
    }
}

