/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.IOException;
import org.projectnessie.api.NessieVersion;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.RequestContext;

final class OpentelemetryTracing {
    private OpentelemetryTracing() {
    }

    static void addTracing(HttpClient.Builder httpClient) {
        OpenTelemetry otel = GlobalOpenTelemetry.get();
        Tracer tracer = otel.getTracer("Nessie");
        if (tracer != null) {
            httpClient.addRequestFilter(context -> {
                Span span = tracer.spanBuilder("Nessie-HTTP").setSpanKind(SpanKind.CLIENT).startSpan().setAttribute(SemanticAttributes.HTTP_URL, (Object)context.getUri().toString()).setAttribute(SemanticAttributes.HTTP_METHOD, (Object)context.getMethod().name()).setAttribute("nessie.version", NessieVersion.NESSIE_VERSION);
                W3CTraceContextPropagator.getInstance().inject(Context.current().with((ImplicitContextKeyed)span), (Object)context, RequestContext::putHeader);
                context.addResponseCallback((responseContext, exception) -> {
                    if (responseContext != null) {
                        try {
                            span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, responseContext.getResponseCode().getCode());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (exception != null) {
                        span.setStatus(StatusCode.ERROR).recordException((Throwable)exception);
                    } else {
                        span.setStatus(StatusCode.OK);
                    }
                    span.end();
                });
            });
        }
    }
}

