/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.DiscriminatorMapping;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentMetadata;
import org.projectnessie.model.Documentation;
import org.projectnessie.model.ImmutableDelete;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.ImmutableUnchanged;
import org.projectnessie.model.ser.Views;

@Schema(type=SchemaType.OBJECT, title="Operation", description="Describes an operation to be performed against one content object.\n\nThe Nessie backend will validate the correctness of the operations.", oneOf={Put.class, Unchanged.class, Delete.class}, discriminatorMapping={@DiscriminatorMapping(value="PUT", schema=Put.class), @DiscriminatorMapping(value="UNCHANGED", schema=Unchanged.class), @DiscriminatorMapping(value="DELETE", schema=Delete.class)}, discriminatorProperty="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Put.class), @JsonSubTypes.Type(value=Delete.class), @JsonSubTypes.Type(value=Unchanged.class)})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public interface Operation {
    @NotNull
    public ContentKey getKey();

    @JsonSerialize(as=ImmutableUnchanged.class)
    @JsonDeserialize(as=ImmutableUnchanged.class)
    @JsonTypeName(value="UNCHANGED")
    @Value.Immutable
    public static interface Unchanged
    extends Operation {
        public static Unchanged of(ContentKey key) {
            return ImmutableUnchanged.builder().key(key).build();
        }
    }

    @Schema(type=SchemaType.OBJECT, title="Delete-'Content'-operation for a 'ContentKey'.", description="Used to delete an existing content key.\n\nIf the key for a content shall change (aka a rename), then use a `Delete` operation using the current (old) key and a `Put` operation using the new key with the current `Content` in the the `value` field. See `Put` operation.")
    @JsonSerialize(as=ImmutableDelete.class)
    @JsonDeserialize(as=ImmutableDelete.class)
    @JsonTypeName(value="DELETE")
    @Value.Immutable
    public static interface Delete
    extends Operation {
        public static Delete of(ContentKey key) {
            return ImmutableDelete.builder().key(key).build();
        }
    }

    @Schema(type=SchemaType.OBJECT, title="Put-'Content'-operation for a 'ContentKey'.", description="Used to add new content or to update existing content.\n\nA new content object is created by populating the `value` field, the content-id in the content object must not be present (null).\n\nA content object is updated by populating the `value` containing the correct content-id.\n\nIf the key for a content shall change (aka a rename), then use a `Delete` operation using the current (old) key and a `Put` operation using the new key with the `value` having the correct content-id. Both operations must happen in the same commit.\n\nA content object can be replaced (think: `DROP TABLE xyz` + `CREATE TABLE xyz`) with a `Delete` operation and a `Put` operation for a content using a `value`representing a new content object, so without a content-id, in the same commit.")
    @JsonSerialize(as=ImmutablePut.class)
    @JsonDeserialize(as=ImmutablePut.class)
    @JsonTypeName(value="PUT")
    @Value.Immutable
    public static interface Put
    extends Operation {
        @NotNull
        public Content getContent();

        @Nullable
        @Deprecated
        @JsonView(value={Views.V1.class})
        public Content getExpectedContent();

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonView(value={Views.V2.class})
        public List<ContentMetadata> getMetadata();

        @Nullable
        @JsonView(value={Views.V2.class})
        public Documentation getDocumentation();

        public static Put of(ContentKey key, Content content) {
            return ImmutablePut.builder().key(key).content(content).build();
        }

        public static Put of(ContentKey key, Content content, Documentation documentation) {
            return ImmutablePut.builder().key(key).content(content).documentation(documentation).build();
        }

        @Deprecated
        public static Put of(ContentKey key, Content content, Content expectedContent) {
            return ImmutablePut.builder().key(key).content(content).expectedContent(expectedContent).build();
        }
    }
}

