/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.JacksonSerializers;
import org.projectnessie.client.auth.oauth2.RefreshToken;
import org.projectnessie.client.auth.oauth2.RefreshTokensResponse;
import org.projectnessie.client.auth.oauth2.TokensResponseBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RefreshTokensResponse", generator="Immutables")
@Immutable
final class ImmutableRefreshTokensResponse
implements RefreshTokensResponse {
    private final String tokenType;
    private final String accessTokenPayload;
    @Nullable
    private final Instant accessTokenExpirationTime;
    @Nullable
    private final String refreshTokenPayload;
    @Nullable
    private final Instant refreshTokenExpirationTime;
    @Nullable
    private final String scope;
    private final Map<String, Object> extraParameters;
    private volatile transient long lazyInitBitmap;
    private static final long ACCESS_TOKEN_LAZY_INIT_BIT = 1L;
    private transient AccessToken accessToken;
    private static final long REFRESH_TOKEN_LAZY_INIT_BIT = 2L;
    private transient RefreshToken refreshToken;

    private ImmutableRefreshTokensResponse(String tokenType, String accessTokenPayload, @Nullable Instant accessTokenExpirationTime, @Nullable String refreshTokenPayload, @Nullable Instant refreshTokenExpirationTime, @Nullable String scope, Map<String, Object> extraParameters) {
        this.tokenType = tokenType;
        this.accessTokenPayload = accessTokenPayload;
        this.accessTokenExpirationTime = accessTokenExpirationTime;
        this.refreshTokenPayload = refreshTokenPayload;
        this.refreshTokenExpirationTime = refreshTokenExpirationTime;
        this.scope = scope;
        this.extraParameters = extraParameters;
    }

    @Override
    @JsonProperty(value="token_type")
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    @JsonProperty(value="access_token")
    public String getAccessTokenPayload() {
        return this.accessTokenPayload;
    }

    @Override
    @JsonProperty(value="expires_in")
    @JsonUnwrapped
    @JsonSerialize(using=JacksonSerializers.InstantToSecondsSerializer.class)
    @JsonDeserialize(using=JacksonSerializers.SecondsToInstantDeserializer.class)
    @Nullable
    public Instant getAccessTokenExpirationTime() {
        return this.accessTokenExpirationTime;
    }

    @Override
    @JsonProperty(value="refresh_token")
    @Nullable
    public String getRefreshTokenPayload() {
        return this.refreshTokenPayload;
    }

    @Override
    @JsonProperty(value="refresh_expires_in")
    @JsonSerialize(using=JacksonSerializers.InstantToSecondsSerializer.class)
    @JsonDeserialize(using=JacksonSerializers.SecondsToInstantDeserializer.class)
    @Nullable
    public Instant getRefreshTokenExpirationTime() {
        return this.refreshTokenExpirationTime;
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="extraParameters")
    @JsonAnyGetter
    public Map<String, Object> getExtraParameters() {
        return this.extraParameters;
    }

    public final ImmutableRefreshTokensResponse withTokenType(String value) {
        String newValue = Objects.requireNonNull(value, "tokenType");
        if (this.tokenType.equals(newValue)) {
            return this;
        }
        return new ImmutableRefreshTokensResponse(newValue, this.accessTokenPayload, this.accessTokenExpirationTime, this.refreshTokenPayload, this.refreshTokenExpirationTime, this.scope, this.extraParameters);
    }

    public final ImmutableRefreshTokensResponse withAccessTokenPayload(String value) {
        String newValue = Objects.requireNonNull(value, "accessTokenPayload");
        if (this.accessTokenPayload.equals(newValue)) {
            return this;
        }
        return new ImmutableRefreshTokensResponse(this.tokenType, newValue, this.accessTokenExpirationTime, this.refreshTokenPayload, this.refreshTokenExpirationTime, this.scope, this.extraParameters);
    }

    public final ImmutableRefreshTokensResponse withAccessTokenExpirationTime(@Nullable Instant value) {
        if (this.accessTokenExpirationTime == value) {
            return this;
        }
        return new ImmutableRefreshTokensResponse(this.tokenType, this.accessTokenPayload, value, this.refreshTokenPayload, this.refreshTokenExpirationTime, this.scope, this.extraParameters);
    }

    public final ImmutableRefreshTokensResponse withRefreshTokenPayload(@Nullable String value) {
        if (Objects.equals(this.refreshTokenPayload, value)) {
            return this;
        }
        return new ImmutableRefreshTokensResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpirationTime, value, this.refreshTokenExpirationTime, this.scope, this.extraParameters);
    }

    public final ImmutableRefreshTokensResponse withRefreshTokenExpirationTime(@Nullable Instant value) {
        if (this.refreshTokenExpirationTime == value) {
            return this;
        }
        return new ImmutableRefreshTokensResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpirationTime, this.refreshTokenPayload, value, this.scope, this.extraParameters);
    }

    public final ImmutableRefreshTokensResponse withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableRefreshTokensResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpirationTime, this.refreshTokenPayload, this.refreshTokenExpirationTime, value, this.extraParameters);
    }

    public final ImmutableRefreshTokensResponse withExtraParameters(Map<String, ? extends Object> entries) {
        if (this.extraParameters == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableRefreshTokensResponse.createUnmodifiableMap(true, false, entries);
        return new ImmutableRefreshTokensResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpirationTime, this.refreshTokenPayload, this.refreshTokenExpirationTime, this.scope, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefreshTokensResponse && this.equalTo(0, (ImmutableRefreshTokensResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableRefreshTokensResponse another) {
        return this.tokenType.equals(another.tokenType) && this.accessTokenPayload.equals(another.accessTokenPayload) && Objects.equals(this.accessTokenExpirationTime, another.accessTokenExpirationTime) && Objects.equals(this.refreshTokenPayload, another.refreshTokenPayload) && Objects.equals(this.refreshTokenExpirationTime, another.refreshTokenExpirationTime) && Objects.equals(this.scope, another.scope) && this.extraParameters.equals(another.extraParameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tokenType.hashCode();
        h += (h << 5) + this.accessTokenPayload.hashCode();
        h += (h << 5) + Objects.hashCode(this.accessTokenExpirationTime);
        h += (h << 5) + Objects.hashCode(this.refreshTokenPayload);
        h += (h << 5) + Objects.hashCode(this.refreshTokenExpirationTime);
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + this.extraParameters.hashCode();
        return h;
    }

    public String toString() {
        return "RefreshTokensResponse{tokenType=" + this.tokenType + ", accessTokenPayload=" + this.accessTokenPayload + ", accessTokenExpirationTime=" + this.accessTokenExpirationTime + ", refreshTokenPayload=" + this.refreshTokenPayload + ", refreshTokenExpirationTime=" + this.refreshTokenExpirationTime + ", scope=" + this.scope + ", extraParameters=" + this.extraParameters + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRefreshTokensResponse fromJson(Json json) {
        Builder builder = ImmutableRefreshTokensResponse.builder();
        if (json.tokenType != null) {
            builder.tokenType(json.tokenType);
        }
        if (json.accessTokenPayload != null) {
            builder.accessTokenPayload(json.accessTokenPayload);
        }
        if (json.accessTokenExpirationTime != null) {
            builder.accessTokenExpirationTime(json.accessTokenExpirationTime);
        }
        if (json.refreshTokenPayload != null) {
            builder.refreshTokenPayload(json.refreshTokenPayload);
        }
        if (json.refreshTokenExpirationTime != null) {
            builder.refreshTokenExpirationTime(json.refreshTokenExpirationTime);
        }
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.extraParameters != null) {
            builder.putAllExtraParameters(json.extraParameters);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccessToken getAccessToken() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableRefreshTokensResponse immutableRefreshTokensResponse = this;
            synchronized (immutableRefreshTokensResponse) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.accessToken = Objects.requireNonNull(RefreshTokensResponse.super.getAccessToken(), "accessToken");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefreshToken getRefreshToken() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableRefreshTokensResponse immutableRefreshTokensResponse = this;
            synchronized (immutableRefreshTokensResponse) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.refreshToken = RefreshTokensResponse.super.getRefreshToken();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.refreshToken;
    }

    public static ImmutableRefreshTokensResponse copyOf(RefreshTokensResponse instance) {
        if (instance instanceof ImmutableRefreshTokensResponse) {
            return (ImmutableRefreshTokensResponse)instance;
        }
        return ImmutableRefreshTokensResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="RefreshTokensResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN_TYPE = 1L;
        private static final long INIT_BIT_ACCESS_TOKEN_PAYLOAD = 2L;
        private long initBits = 3L;
        @Nullable
        private String tokenType;
        @Nullable
        private String accessTokenPayload;
        @Nullable
        private Instant accessTokenExpirationTime;
        @Nullable
        private String refreshTokenPayload;
        @Nullable
        private Instant refreshTokenExpirationTime;
        @Nullable
        private String scope;
        private Map<String, Object> extraParameters = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RefreshTokensResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokensResponseBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Instant accessTokenExpirationTimeValue;
            Instant refreshTokenExpirationTimeValue;
            String refreshTokenPayloadValue;
            String scopeValue;
            TokensResponseBase instance;
            long bits = 0L;
            if (object instanceof RefreshTokensResponse) {
                instance = (RefreshTokensResponse)object;
                if ((bits & 1L) == 0L) {
                    this.accessTokenPayload(instance.getAccessTokenPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    refreshTokenPayloadValue = instance.getRefreshTokenPayload();
                    if (refreshTokenPayloadValue != null) {
                        this.refreshTokenPayload(refreshTokenPayloadValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.putAllExtraParameters(instance.getExtraParameters());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    refreshTokenExpirationTimeValue = instance.getRefreshTokenExpirationTime();
                    if (refreshTokenExpirationTimeValue != null) {
                        this.refreshTokenExpirationTime(refreshTokenExpirationTimeValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.tokenType(instance.getTokenType());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    accessTokenExpirationTimeValue = instance.getAccessTokenExpirationTime();
                    if (accessTokenExpirationTimeValue != null) {
                        this.accessTokenExpirationTime(accessTokenExpirationTimeValue);
                    }
                    bits |= 0x40L;
                }
            }
            if (object instanceof TokensResponseBase) {
                instance = (TokensResponseBase)object;
                if ((bits & 1L) == 0L) {
                    this.accessTokenPayload(instance.getAccessTokenPayload());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    refreshTokenPayloadValue = instance.getRefreshTokenPayload();
                    if (refreshTokenPayloadValue != null) {
                        this.refreshTokenPayload(refreshTokenPayloadValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.putAllExtraParameters(instance.getExtraParameters());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    refreshTokenExpirationTimeValue = instance.getRefreshTokenExpirationTime();
                    if (refreshTokenExpirationTimeValue != null) {
                        this.refreshTokenExpirationTime(refreshTokenExpirationTimeValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.tokenType(instance.getTokenType());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    accessTokenExpirationTimeValue = instance.getAccessTokenExpirationTime();
                    if (accessTokenExpirationTimeValue != null) {
                        this.accessTokenExpirationTime(accessTokenExpirationTimeValue);
                    }
                    bits |= 0x40L;
                }
            }
        }

        @JsonProperty(value="token_type")
        @CanIgnoreReturnValue
        public final Builder tokenType(String tokenType) {
            this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="access_token")
        @CanIgnoreReturnValue
        public final Builder accessTokenPayload(String accessTokenPayload) {
            this.accessTokenPayload = Objects.requireNonNull(accessTokenPayload, "accessTokenPayload");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="expires_in")
        @JsonUnwrapped
        @JsonSerialize(using=JacksonSerializers.InstantToSecondsSerializer.class)
        @JsonDeserialize(using=JacksonSerializers.SecondsToInstantDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder accessTokenExpirationTime(@Nullable Instant accessTokenExpirationTime) {
            this.accessTokenExpirationTime = accessTokenExpirationTime;
            return this;
        }

        @JsonProperty(value="refresh_token")
        @CanIgnoreReturnValue
        public final Builder refreshTokenPayload(@Nullable String refreshTokenPayload) {
            this.refreshTokenPayload = refreshTokenPayload;
            return this;
        }

        @JsonProperty(value="refresh_expires_in")
        @JsonSerialize(using=JacksonSerializers.InstantToSecondsSerializer.class)
        @JsonDeserialize(using=JacksonSerializers.SecondsToInstantDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder refreshTokenExpirationTime(@Nullable Instant refreshTokenExpirationTime) {
            this.refreshTokenExpirationTime = refreshTokenExpirationTime;
            return this;
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putExtraParameters(String key, Object value) {
            this.extraParameters.put(Objects.requireNonNull(key, "extraParameters key"), value == null ? Objects.requireNonNull(value, "extraParameters value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraParameters(Map.Entry<String, ? extends Object> entry) {
            Object v;
            String k = entry.getKey();
            this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "extraParameters value for key: " + k) : v);
            return this;
        }

        @JsonProperty(value="extraParameters")
        @CanIgnoreReturnValue
        public final Builder extraParameters(Map<String, ? extends Object> entries) {
            this.extraParameters.clear();
            return this.putAllExtraParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraParameters(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                Object v;
                String k = e.getKey();
                this.extraParameters.put(Objects.requireNonNull(k, "extraParameters key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "extraParameters value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableRefreshTokensResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRefreshTokensResponse(this.tokenType, this.accessTokenPayload, this.accessTokenExpirationTime, this.refreshTokenPayload, this.refreshTokenExpirationTime, this.scope, ImmutableRefreshTokensResponse.createUnmodifiableMap(false, false, this.extraParameters));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tokenType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("accessTokenPayload");
            }
            return "Cannot build RefreshTokensResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RefreshTokensResponse", generator="Immutables")
    static final class Json
    implements RefreshTokensResponse {
        @Nullable
        String tokenType;
        @Nullable
        String accessTokenPayload;
        @Nullable
        Instant accessTokenExpirationTime;
        @Nullable
        String refreshTokenPayload;
        @Nullable
        Instant refreshTokenExpirationTime;
        @Nullable
        String scope;
        final Map<String, Object> extraParameters = new HashMap<String, Object>();

        Json() {
        }

        @JsonProperty(value="token_type")
        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @JsonProperty(value="access_token")
        public void setAccessTokenPayload(String accessTokenPayload) {
            this.accessTokenPayload = accessTokenPayload;
        }

        @JsonProperty(value="expires_in")
        @JsonUnwrapped
        @JsonSerialize(using=JacksonSerializers.InstantToSecondsSerializer.class)
        @JsonDeserialize(using=JacksonSerializers.SecondsToInstantDeserializer.class)
        public void setAccessTokenExpirationTime(@Nullable Instant accessTokenExpirationTime) {
            this.accessTokenExpirationTime = accessTokenExpirationTime;
        }

        @JsonProperty(value="refresh_token")
        public void setRefreshTokenPayload(@Nullable String refreshTokenPayload) {
            this.refreshTokenPayload = refreshTokenPayload;
        }

        @JsonProperty(value="refresh_expires_in")
        @JsonSerialize(using=JacksonSerializers.InstantToSecondsSerializer.class)
        @JsonDeserialize(using=JacksonSerializers.SecondsToInstantDeserializer.class)
        public void setRefreshTokenExpirationTime(@Nullable Instant refreshTokenExpirationTime) {
            this.refreshTokenExpirationTime = refreshTokenExpirationTime;
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonAnySetter
        public void setExtraParameters(String key, Object value) {
            this.extraParameters.put(key, value);
        }

        @Override
        public String getTokenType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAccessTokenPayload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getAccessTokenExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRefreshTokenPayload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getRefreshTokenExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getExtraParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AccessToken getAccessToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RefreshToken getRefreshToken() {
            throw new UnsupportedOperationException();
        }
    }
}

