/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest.v1;

import jakarta.validation.Valid;
import java.util.Locale;
import javax.validation.constraints.NotNull;
import org.projectnessie.api.v1.http.HttpTreeApi;
import org.projectnessie.api.v1.params.CommitLogParams;
import org.projectnessie.api.v1.params.EntriesParams;
import org.projectnessie.api.v1.params.GetReferenceParams;
import org.projectnessie.api.v1.params.Merge;
import org.projectnessie.api.v1.params.ReferencesParams;
import org.projectnessie.api.v1.params.Transplant;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.FetchOption;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;

class RestV1TreeClient
implements HttpTreeApi {
    private final HttpClient client;

    RestV1TreeClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public ReferencesResponse getAllReferences(ReferencesParams params) {
        return this.client.newRequest().path("trees").queryParam("maxRecords", params.maxRecords()).queryParam("pageToken", params.pageToken()).queryParam("fetch", FetchOption.getFetchOptionName(params.fetchOption())).queryParam("filter", params.filter()).get().readEntity(ReferencesResponse.class);
    }

    @Override
    public Reference createReference(String sourceRefName, @NotNull @jakarta.validation.constraints.NotNull Reference reference) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/tree").queryParam("sourceRefName", sourceRefName).post(reference).readEntity(Reference.class);
    }

    @Override
    public Reference getReferenceByName(@NotNull @jakarta.validation.constraints.NotNull GetReferenceParams params) throws NessieNotFoundException {
        return this.client.newRequest().path("trees/tree/{ref}").queryParam("fetch", FetchOption.getFetchOptionName(params.fetchOption())).resolveTemplate("ref", params.getRefName()).get().readEntity(Reference.class);
    }

    @Override
    public void assignReference(@NotNull @jakarta.validation.constraints.NotNull Reference.ReferenceType referenceType, @NotNull @jakarta.validation.constraints.NotNull String referenceName, @NotNull @jakarta.validation.constraints.NotNull String expectedHash, @javax.validation.Valid @Valid @NotNull @jakarta.validation.constraints.NotNull Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("trees/{referenceType}/{referenceName}").resolveTemplate("referenceType", referenceType.name().toLowerCase(Locale.ROOT)).resolveTemplate("referenceName", referenceName).queryParam("expectedHash", expectedHash).put(assignTo);
    }

    @Override
    public void deleteReference(@NotNull @jakarta.validation.constraints.NotNull Reference.ReferenceType referenceType, @NotNull @jakarta.validation.constraints.NotNull String referenceName, @NotNull @jakarta.validation.constraints.NotNull String expectedHash) throws NessieConflictException, NessieNotFoundException {
        this.client.newRequest().path("trees/{referenceType}/{referenceName}").resolveTemplate("referenceType", referenceType.name().toLowerCase(Locale.ROOT)).resolveTemplate("referenceName", referenceName).queryParam("expectedHash", expectedHash).delete();
    }

    @Override
    public Branch getDefaultBranch() {
        return this.client.newRequest().path("trees/tree").get().readEntity(Branch.class);
    }

    @Override
    public LogResponse getCommitLog(@NotNull @jakarta.validation.constraints.NotNull String ref, @NotNull @jakarta.validation.constraints.NotNull CommitLogParams params) throws NessieNotFoundException {
        HttpRequest builder = this.client.newRequest().path("trees/tree/{ref}/log").resolveTemplate("ref", ref);
        return builder.queryParam("maxRecords", params.maxRecords()).queryParam("pageToken", params.pageToken()).queryParam("filter", params.filter()).queryParam("startHash", params.startHash()).queryParam("endHash", params.endHash()).queryParam("fetch", FetchOption.getFetchOptionName(params.fetchOption())).get().readEntity(LogResponse.class);
    }

    @Override
    public MergeResponse transplantCommitsIntoBranch(@NotNull @jakarta.validation.constraints.NotNull String branchName, @NotNull @jakarta.validation.constraints.NotNull String expectedHash, String message, @javax.validation.Valid @Valid Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/branch/{branchName}/transplant").resolveTemplate("branchName", branchName).queryParam("expectedHash", expectedHash).queryParam("message", message).post(transplant).readEntity(MergeResponse.class);
    }

    @Override
    public MergeResponse mergeRefIntoBranch(@NotNull @jakarta.validation.constraints.NotNull String branchName, @NotNull @jakarta.validation.constraints.NotNull String expectedHash, @NotNull @jakarta.validation.constraints.NotNull @javax.validation.Valid @Valid Merge merge) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/branch/{branchName}/merge").resolveTemplate("branchName", branchName).queryParam("expectedHash", expectedHash).post(merge).readEntity(MergeResponse.class);
    }

    @Override
    public EntriesResponse getEntries(@NotNull @jakarta.validation.constraints.NotNull String refName, @NotNull @jakarta.validation.constraints.NotNull EntriesParams params) throws NessieNotFoundException {
        HttpRequest builder = this.client.newRequest().path("trees/tree/{ref}/entries").resolveTemplate("ref", refName);
        return builder.queryParam("maxRecords", params.maxRecords()).queryParam("pageToken", params.pageToken()).queryParam("filter", params.filter()).queryParam("hashOnRef", params.hashOnRef()).queryParam("namespaceDepth", params.namespaceDepth() == null ? null : String.valueOf(params.namespaceDepth())).get().readEntity(EntriesResponse.class);
    }

    @Override
    public Branch commitMultipleOperations(String branch, @NotNull @jakarta.validation.constraints.NotNull String expectedHash, @NotNull @jakarta.validation.constraints.NotNull Operations operations) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/branch/{branchName}/commit").resolveTemplate("branchName", branch).queryParam("expectedHash", expectedHash).post(operations).readEntity(Branch.class);
    }
}

