/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.nessie.cli.cmdspec;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.cli.cmdspec.CatalogAware;
import org.projectnessie.nessie.cli.cmdspec.CommandSpec;
import org.projectnessie.nessie.cli.cmdspec.DropContentCommandSpec;
import org.projectnessie.nessie.cli.cmdspec.RefCommandSpec;
import org.projectnessie.nessie.cli.grammar.Node;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DropContentCommandSpec", generator="Immutables")
@Immutable
public final class ImmutableDropContentCommandSpec
implements DropContentCommandSpec {
    @jakarta.annotation.Nullable
    private final String inCatalog;
    @jakarta.annotation.Nullable
    private final Node sourceNode;
    private final String contentKind;
    private final String contentKey;
    @jakarta.annotation.Nullable
    private final String ref;

    private ImmutableDropContentCommandSpec(@jakarta.annotation.Nullable String inCatalog, @jakarta.annotation.Nullable Node sourceNode, String contentKind, String contentKey, @jakarta.annotation.Nullable String ref) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.contentKind = Objects.requireNonNull(contentKind, "contentKind");
        this.contentKey = Objects.requireNonNull(contentKey, "contentKey");
        this.ref = ref;
    }

    private ImmutableDropContentCommandSpec(Builder builder) {
        this.inCatalog = builder.inCatalog;
        this.contentKind = builder.contentKind;
        this.contentKey = builder.contentKey;
        this.ref = builder.ref;
        this.sourceNode = builder.sourceNodeIsSet() ? builder.sourceNode : DropContentCommandSpec.super.sourceNode();
    }

    private ImmutableDropContentCommandSpec(ImmutableDropContentCommandSpec original, @jakarta.annotation.Nullable String inCatalog, @jakarta.annotation.Nullable Node sourceNode, String contentKind, String contentKey, @jakarta.annotation.Nullable String ref) {
        this.inCatalog = inCatalog;
        this.sourceNode = sourceNode;
        this.contentKind = contentKind;
        this.contentKey = contentKey;
        this.ref = ref;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getInCatalog() {
        return this.inCatalog;
    }

    @Override
    @jakarta.annotation.Nullable
    public Node sourceNode() {
        return this.sourceNode;
    }

    @Override
    public String getContentKind() {
        return this.contentKind;
    }

    @Override
    public String getContentKey() {
        return this.contentKey;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getRef() {
        return this.ref;
    }

    public final ImmutableDropContentCommandSpec withInCatalog(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.inCatalog, value)) {
            return this;
        }
        return new ImmutableDropContentCommandSpec(this, value, this.sourceNode, this.contentKind, this.contentKey, this.ref);
    }

    public final ImmutableDropContentCommandSpec withSourceNode(@jakarta.annotation.Nullable Node value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutableDropContentCommandSpec(this, this.inCatalog, value, this.contentKind, this.contentKey, this.ref);
    }

    public final ImmutableDropContentCommandSpec withContentKind(String value) {
        String newValue = Objects.requireNonNull(value, "contentKind");
        if (this.contentKind.equals(newValue)) {
            return this;
        }
        return new ImmutableDropContentCommandSpec(this, this.inCatalog, this.sourceNode, newValue, this.contentKey, this.ref);
    }

    public final ImmutableDropContentCommandSpec withContentKey(String value) {
        String newValue = Objects.requireNonNull(value, "contentKey");
        if (this.contentKey.equals(newValue)) {
            return this;
        }
        return new ImmutableDropContentCommandSpec(this, this.inCatalog, this.sourceNode, this.contentKind, newValue, this.ref);
    }

    public final ImmutableDropContentCommandSpec withRef(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.ref, value)) {
            return this;
        }
        return new ImmutableDropContentCommandSpec(this, this.inCatalog, this.sourceNode, this.contentKind, this.contentKey, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDropContentCommandSpec && this.equalTo(0, (ImmutableDropContentCommandSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableDropContentCommandSpec another) {
        return Objects.equals(this.inCatalog, another.inCatalog) && Objects.equals(this.sourceNode, another.sourceNode) && this.contentKind.equals(another.contentKind) && this.contentKey.equals(another.contentKey) && Objects.equals(this.ref, another.ref);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inCatalog);
        h += (h << 5) + Objects.hashCode(this.sourceNode);
        h += (h << 5) + this.contentKind.hashCode();
        h += (h << 5) + this.contentKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.ref);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DropContentCommandSpec").omitNullValues().add("inCatalog", (Object)this.inCatalog).add("sourceNode", (Object)this.sourceNode).add("contentKind", (Object)this.contentKind).add("contentKey", (Object)this.contentKey).add("ref", (Object)this.ref).toString();
    }

    public static ImmutableDropContentCommandSpec of(@jakarta.annotation.Nullable String inCatalog, @jakarta.annotation.Nullable Node sourceNode, String contentKind, String contentKey, @jakarta.annotation.Nullable String ref) {
        return new ImmutableDropContentCommandSpec(inCatalog, sourceNode, contentKind, contentKey, ref);
    }

    public static ImmutableDropContentCommandSpec copyOf(DropContentCommandSpec instance) {
        if (instance instanceof ImmutableDropContentCommandSpec) {
            return (ImmutableDropContentCommandSpec)instance;
        }
        return ImmutableDropContentCommandSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DropContentCommandSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONTENT_KIND = 1L;
        private static final long INIT_BIT_CONTENT_KEY = 2L;
        private static final long OPT_BIT_SOURCE_NODE = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String inCatalog;
        @Nullable
        private Node sourceNode;
        @Nullable
        private String contentKind;
        @Nullable
        private String contentKey;
        @Nullable
        private String ref;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CatalogAware instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DropContentCommandSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String inCatalogValue;
            String refValue;
            Node sourceNodeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof CommandSpec) {
                instance = (CommandSpec)object;
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof RefCommandSpec) {
                instance = (RefCommandSpec)object;
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof CatalogAware) {
                instance = (CatalogAware)object;
                if ((bits & 4L) == 0L) {
                    inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof DropContentCommandSpec) {
                instance = (DropContentCommandSpec)object;
                this.contentKey(instance.getContentKey());
                if ((bits & 1L) == 0L) {
                    refValue = instance.getRef();
                    if (refValue != null) {
                        this.ref(refValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    sourceNodeValue = instance.sourceNode();
                    if (sourceNodeValue != null) {
                        this.sourceNode(sourceNodeValue);
                    }
                    bits |= 2L;
                }
                this.contentKind(instance.getContentKind());
                if ((bits & 4L) == 0L) {
                    inCatalogValue = instance.getInCatalog();
                    if (inCatalogValue != null) {
                        this.inCatalog(inCatalogValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder inCatalog(@jakarta.annotation.Nullable String inCatalog) {
            this.inCatalog = inCatalog;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceNode(@jakarta.annotation.Nullable Node sourceNode) {
            this.sourceNode = sourceNode;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentKind(String contentKind) {
            this.contentKind = Objects.requireNonNull(contentKind, "contentKind");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentKey(String contentKey) {
            this.contentKey = Objects.requireNonNull(contentKey, "contentKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ref(@jakarta.annotation.Nullable String ref) {
            this.ref = ref;
            return this;
        }

        public ImmutableDropContentCommandSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDropContentCommandSpec(this);
        }

        private boolean sourceNodeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("contentKind");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentKey");
            }
            return "Cannot build DropContentCommandSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

