/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.annotation.Nullable;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.CommitConsistency;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ImmutableReferenceHistoryState;

@Schema(type=SchemaType.OBJECT, title="ReferenceHistoryState", description="Describes the consistency status of a commit within a `ReferenceHistoryResponse` object.\n\nPossible values of the `CommitConsistency` enum:\n- `NOT_CHECKED` means: Consistency was not checked.\n- `COMMIT_CONSISTENT` means: The commit object, its index information and all reachable content is present.\n- `COMMIT_CONTENT_INCONSISTENT` means: The commit object is present and its index is accessible, but some content reachable from the commit is not present.\n- `COMMIT_INCONSISTENT` means: The commit is inconsistent in a way that makes it impossible to access the commit, for example if the commit object itself or its index information is missing.")
@JsonSerialize(as=ImmutableReferenceHistoryState.class)
@JsonDeserialize(as=ImmutableReferenceHistoryState.class)
@Value.Immutable
public interface ReferenceHistoryState {
    @Schema(description="Nessie commit ID.")
    @Value.Parameter(order=1)
    public String commitHash();

    @Schema(description="Consistency status of the commit.")
    @Value.Parameter(order=2)
    public CommitConsistency commitConsistency();

    @Schema(description="Meta information from the commit, if available.")
    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=3)
    public CommitMeta meta();

    public static ReferenceHistoryState referenceHistoryElement(String commitHash, CommitConsistency commitConsistency, CommitMeta meta) {
        return ImmutableReferenceHistoryState.of(commitHash, commitConsistency, meta);
    }
}

