/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.v2.params.GetReferenceParamsBuilder;
import org.projectnessie.model.FetchOption;

public class GetReferenceParams {
    @Parameter(description="Specifies a reference to a particular commit history branch or tag.\n\nThis reference can be specification in these forms:\n- \\- (literal minus character) - identifies the default branch.\n- name - Identifies the named branch or tag.\n", examples={@ExampleObject(ref="ref"), @ExampleObject(ref="refDefault")})
    @PathParam(value="ref")
    @NotNull
    @Pattern(regexp="^([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?(@([0-9a-fA-F]{8,64})?)?|@[0-9a-fA-F]{8,64})|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    private @NotNull @Pattern(regexp="^([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?(@([0-9a-fA-F]{8,64})?)?|@[0-9a-fA-F]{8,64})|-$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String ref;
    @Parameter(description="Specify how much information to be returned. Will fetch additional metadata for references if set to 'ALL'.\n\nA returned Branch instance will have the following information:\n\n- numCommitsAhead (number of commits ahead of the default branch)\n\n- numCommitsBehind (number of commits behind the default branch)\n\n- commitMetaOfHEAD (the commit metadata of the HEAD commit)\n\n- commonAncestorHash (the hash of the common ancestor in relation to the default branch).\n\n- numTotalCommits (the total number of commits in this reference).\n\nA returned Tag instance will only contain the 'commitMetaOfHEAD' and 'numTotalCommits' fields.\n\nNote that computing & fetching additional metadata might be computationally expensive on the server-side, so this flag should be used with care.")
    @QueryParam(value="fetch")
    @Nullable
    private FetchOption fetchOption;

    public GetReferenceParams() {
    }

    @Builder.Constructor
    GetReferenceParams(@NotNull String ref, @Nullable FetchOption fetchOption) {
        this.ref = ref;
        this.fetchOption = fetchOption;
    }

    @Nullable
    public FetchOption fetchOption() {
        return this.fetchOption;
    }

    public String getRef() {
        return this.ref;
    }

    public static GetReferenceParamsBuilder builder() {
        return new GetReferenceParamsBuilder();
    }
}

