/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.annotation.Nullable;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Branch")
@JsonSerialize(as=ImmutableBranch.class)
@JsonDeserialize(as=ImmutableBranch.class)
@JsonTypeName(value="BRANCH")
@Value.Immutable
public interface Branch
extends Reference {
    @Override
    @Value.Parameter(order=1)
    public String getName();

    @Override
    @Nullable
    @Value.Parameter(order=3)
    public ReferenceMetadata getMetadata();

    @Override
    @Nullable
    @Value.Parameter(order=2)
    public String getHash();

    @Value.Check
    default public void checkName() {
        Validation.validateReferenceName(this.getName());
    }

    @Override
    default public Reference.ReferenceType getType() {
        return Reference.ReferenceType.BRANCH;
    }

    public static ImmutableBranch.Builder builder() {
        return ImmutableBranch.builder();
    }

    public static Branch of(String name, @Nullable String hash) {
        return ImmutableBranch.of(name, hash, null);
    }

    public static Branch of(String name, @Nullable String hash, ReferenceMetadata metadata) {
        return ImmutableBranch.of(name, hash, metadata);
    }
}

