/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.api.v2.params.ParsedReference;
import org.projectnessie.model.Reference;

@ParametersAreNonnullByDefault
@Generated(from="ParsedReference", generator="Immutables")
@Immutable
public final class ImmutableParsedReference
implements ParsedReference {
    private final String name;
    private final String hashWithRelativeSpec;
    private final Reference.ReferenceType type;

    private ImmutableParsedReference(String name, String hashWithRelativeSpec, Reference.ReferenceType type) {
        this.name = name;
        this.hashWithRelativeSpec = hashWithRelativeSpec;
        this.type = type;
    }

    private ImmutableParsedReference(ImmutableParsedReference original, String name, String hashWithRelativeSpec, Reference.ReferenceType type) {
        this.name = name;
        this.hashWithRelativeSpec = hashWithRelativeSpec;
        this.type = type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String hashWithRelativeSpec() {
        return this.hashWithRelativeSpec;
    }

    @Override
    public Reference.ReferenceType type() {
        return this.type;
    }

    public final ImmutableParsedReference withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return ImmutableParsedReference.validate(new ImmutableParsedReference(this, value, this.hashWithRelativeSpec, this.type));
    }

    public final ImmutableParsedReference withHashWithRelativeSpec(String value) {
        if (Objects.equals(this.hashWithRelativeSpec, value)) {
            return this;
        }
        return ImmutableParsedReference.validate(new ImmutableParsedReference(this, this.name, value, this.type));
    }

    public final ImmutableParsedReference withType(Reference.ReferenceType value) {
        if (this.type == value) {
            return this;
        }
        return ImmutableParsedReference.validate(new ImmutableParsedReference(this, this.name, this.hashWithRelativeSpec, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParsedReference && this.equalTo(0, (ImmutableParsedReference)another);
    }

    private boolean equalTo(int synthetic, ImmutableParsedReference another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.hashWithRelativeSpec, another.hashWithRelativeSpec) && Objects.equals((Object)this.type, (Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.hashWithRelativeSpec);
        h += (h << 5) + Objects.hashCode((Object)this.type);
        return h;
    }

    public String toString() {
        return "ParsedReference{name=" + this.name + ", hashWithRelativeSpec=" + this.hashWithRelativeSpec + ", type=" + (Object)((Object)this.type) + "}";
    }

    public static ImmutableParsedReference of(String name, String hashWithRelativeSpec, Reference.ReferenceType type) {
        return ImmutableParsedReference.validate(new ImmutableParsedReference(name, hashWithRelativeSpec, type));
    }

    private static ImmutableParsedReference validate(ImmutableParsedReference instance) {
        instance.check();
        return instance;
    }

    public static ImmutableParsedReference copyOf(ParsedReference instance) {
        if (instance instanceof ImmutableParsedReference) {
            return (ImmutableParsedReference)instance;
        }
        return ImmutableParsedReference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ParsedReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String hashWithRelativeSpec;
        @Nullable
        private Reference.ReferenceType type;

        private Builder() {
        }

        public final Builder from(ParsedReference instance) {
            Reference.ReferenceType typeValue;
            String hashWithRelativeSpecValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((hashWithRelativeSpecValue = instance.hashWithRelativeSpec()) != null) {
                this.hashWithRelativeSpec(hashWithRelativeSpecValue);
            }
            if ((typeValue = instance.type()) != null) {
                this.type(typeValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Builder hashWithRelativeSpec(String hashWithRelativeSpec) {
            this.hashWithRelativeSpec = hashWithRelativeSpec;
            return this;
        }

        public final Builder type(Reference.ReferenceType type) {
            this.type = type;
            return this;
        }

        public ImmutableParsedReference build() {
            return ImmutableParsedReference.validate(new ImmutableParsedReference(null, this.name, this.hashWithRelativeSpec, this.type));
        }
    }
}

